#
# FILE
#	gnusun.mak
#
#	Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.
#	All rights reserved.
#	
#	This software (including any documentation) is untested, has not been
#	fully tested for viruses and has been provided to you without charge.
#	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
#	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
#	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
#	risk of nonperformance, loss of data and other problems and Fujitsu
#	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
#	contract, negligence, strict liability or other theory for any damages
#	including, without limitation, direct, consequential or incidental nor
#	be required to provide substitute goods, services or technology.
#
# DESCRIPTION
#	This is the SUN version of the Fujitsu monitor makefile on the 
#	SPARClite Evaluation Board using the Cygnus GNU compiler.
#
# HISTORY
#	April 1993	Clark Li
#	November 1995	CCF
# 

#.SCCS_GET:

CHIP 		= 933H
MHZ 		= 20
TOOLPATH	= /usr/cygnus/progressive-95q2/H-sparc-sun-sunos4.1.3
TOOLPATH1	= $(TOOLPATH)/sparclite-coff/bin
TOOLPATH2	= $(TOOLPATH)/lib/gcc-lib/sparclite-coff/2.6-95q2
CC 		= $(TOOLPATH1)/gcc
CPP		= $(TOOLPATH2)/cpp
AS 		= $(TOOLPATH1)/as
LN		= $(TOOLPATH1)/ld
STRIP		= $(TOOLPATH1)/strip
OBJCOPY		= $(TOOLPATH)/bin/sparclite-coff-objcopy
REMOVE		= rm -f
CFLAGS		= -O -c -DMASTER_CK_$(MHZ) -DBOARD_$(CHIP)
AFLAGS		= 
LFLAGS		= -Tldscript -Ttext 40008000 -Bstatic -N
CPPFLAGS	= -DMASTER_CK_$(MHZ) -DBOARD_$(CHIP)

SRC		= ../src

TARGET		= sl$(MHZ)$(CHIP)

TARGETFILE	= $(TARGET).cof

BINFILE		= $(TARGET).bin

CREATECKSUM	= ../cksum/e_cksum -f $(TARGETFILE) -h $(SRC)/cksumsl.h

PRINTCKSUM	= ../cksum/e_cksum -f $(TARGETFILE)

MAKEIMAGE	= $(OBJCOPY) --output-target binary $(TARGETFILE) $(BINFILE)
	
include ../src/prom.mak
