#
# FILE
#	promsl.mak
#
#	Copyright(c) 1993, FMI, Fujitsu Microelectronics, Inc.
#	All rights reserved.
#
#	This software (including any documentation) is untested, has not been
#	fully tested for viruses and has been provided to you without charge.
#	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
#	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
#	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
#	risk of nonperformance, loss of data and other problems and Fujitsu
#	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
#	contract, negligence, strict liability or other theory for any damages
#	including, without limitation, direct, consequential or incidental nor
#	be required to provide substitute goods, services or technology.
#
# DESCRIPTION
#	This is the makefile for the Fujitsu monitor on the SPARClite
#	Evaluation Board.
#
# HISTORY
#	August 1992	Roland Chu
#	April 1993	Clark Li
#	November 1995	CCF
# 

.SCCS_GET:
CHIP 		= 933H
MHZ 		= 20
CC 		= mccsp
AS 		= asmsp
LN		= lnksp
CFLAGS		= -plite -c -DMASTER_CK_$(MHZ) -DBOARD_$(CHIP)
AFLAGS		= -DMASTER_CK_$(MHZ) -DBOARD_936$(CHIP)
LFLAGS		= -e $(ENTRY) -c ram.cmd -m > $(TARGET).map
COMMONFLAGS	=

TARGET		= sl$(MHZ)$(CHIP)

ENTRY		= _traptbl
OBJECTS		= thndlrsl.o resetsl.o utilsl.o sdtrsl.o flash.o
CSOURCES	= flash.c
SSOURCES	= ttblsl.s thndlrsl.s resetsl.s utilsl.s sdtrsl.s
SOURCES		= $(SSOURCES) $(CSOURCES)
HEADERS		= utilsl.h

NESRCS		= ne.c nes.s
NEOBJS		= ne.o nes.o
NEHEADERS	= splite.h net.h

.s.o:
	$(AS) $(AFLAGS) -o $*.o $*.s
.c.o:
	$(CC) $(CFLAGS) $*.c

$(TARGET):	$(OBJECTS) $(HEADERS) $(NEOBJS) $(NEHEADERS)
#
# make pertinent files writable
#
	chmod -f 664 $(TARGET).cof $(TARGET).map $(TARGET).sr
#
# create initial cksumsl.h file containing a temporary value of "0"
#
	echo ".zero	4" > cksumsl.h
#
# remove ttblsl.o to assure recompile.
#
	rm -f ttblsl.o
	$(AS) $(AFLAGS) ttblsl.s
	$(LN) $(LFLAGS) -o $(TARGET).cof ttblsl.o $(OBJECTS) $(NEOBJS)
#
# checksum the initially linked coff file creating the real checksum complement
# in chksumsl.h. The value contained herein will be the last item of data
# and will be added to the cumulative 2 byte sum of all which went before,
# text and data, to obtain zero.
#
# NOTE that the e_cksum utility, when invoked with the "-h" option outputs
# (and writes to named header file) the 2 byte value, which when added to the
# computed checksum of the coff file, yields zero. Without the -h option
# e_cksum returns the actual 2 byte checksum.
#
	../cksum/e_cksum -f $(TARGET).cof -h cksumsl.h
	$(AS) $(AFLAGS) ttblsl.s
	$(LN) $(LFLAGS) -o $(TARGET).cof ttblsl.o $(OBJECTS) $(NEOBJS)
#
# for a sanity check, invoke e_cksum without "-h" to yield the real checksum
# for the newly linked prom which should now be zero.
#
	../cksum/e_cksum -f $(TARGET).cof
	rm -f $(OBJECTS)
	coffsp2s $(TARGET).cof $(TARGET).sr
	chmod -f 444 $(TARGET).cof $(TARGET).map $(TARGET).sr


