
#
# FILE
#	promslpc.mak
#
#	Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.
#	All rights reserved.
#	
#	This software (including any documentation) is untested, has not been
#	fully tested for viruses and has been provided to you without charge.
#	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
#	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
#	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
#	risk of nonperformance, loss of data and other problems and Fujitsu
#	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
#	contract, negligence, strict liability or other theory for any damages
#	including, without limitation, direct, consequential or incidental nor
#	be required to provide substitute goods, services or technology.
#
# DESCRIPTION
#	This is the PC version of the Fujitsu monitor makefile on the 
#	SPARClite Evaluation Board.
#
# HISTORY
#	April 1993	Clark Li
#	November 1995	CCF
# 

#.SCCS_GET:
CHIP 		= 933H
MHZ 		= 20
CC 		= mccsp
AS 		= asmsp
LN		= lnksp
CFLAGS		= -plite -c -DMASTER_CK_$(MHZ) -DBOARD_$(CHIP)
AFLAGS		= -DMASTER_CK_$(MHZ) -DBOARD_$(CHIP)
LFLAGS		= -c ram.cmd 
COMMONFLAGS	=

TARGET		= sl$(MHZ)$(CHIP)

ENTRY		= _traptbl
OBJECTS		= thndlrsl.obj resetsl.obj utilsl.obj sdtrsl.obj flash.obj
CSOURCES	= flash.c
SSOURCES	= ttblsl.s thndlrsl.s resetsl.s utilsl.s sdtrsl.s
SOURCES		= $(SSOURCES) $(CSOURCES)
HEADERS		= utilsl.h

NESRCS          = ne.c nes.s
NEOBJS          = ne.obj nes.obj
NEHEADERS       = splite.h net.h

$(TARGET):	$(OBJECTS) $(HEADERS) $(NEOBJS) $(NEHEADERS)
#
# create initial cksumsl.h file containing a temporary value of "0"
#
	echo .zero	4 > cksumsl.h
#
# always compile ttblsl.s
#
	$(AS) $(AFLAGS) ttblsl.s
	$(LN) $(LFLAGS) -o $(TARGET).cof ttblsl.obj $(OBJECTS) $(NEOBJS)
#
# checksum the initially linked coff file creating the real checksum complement
# in chksumsl.h. The value contained herein will be the last item of data
# and will be added to the cumulative 2 byte sum of all which went before,
# text and data, to obtain zero.
#
# NOTE that the e_cksum utility, when invoked with the "-h" option outputs
# (and writes to named header file) the 2 byte value, which when added to the
# computed checksum of the coff file, yields zero. Without the -h option
# e_cksum returns the actual 2 byte checksum.
#
	..\cksum\e_cksump -f $(TARGET).cof -h cksumsl.h
	$(AS) $(AFLAGS) ttblsl.s
	$(LN) $(LFLAGS) -o $(TARGET).cof ttblsl.obj $(OBJECTS) $(NEOBJS)
#
# for a sanity check, invoke e_cksum without "-h" to yield the real checksum
# for the newly linked prom which should now be zero.
#
	..\cksum\e_cksump -f $(TARGET).cof
	del *.obj
	coffsp2s $(TARGET).cof $(TARGET).sr

# Individual object dependencies
ttblsl.obj:		ttblsl.s
	$(AS) $(AFLAGS) ttblsl.s
thndlrsl.obj:	thndlrsl.s $(HEADERS)
	$(AS) $(AFLAGS) thndlrsl.s
resetsl.obj:		resetsl.s $(HEADERS)
	$(AS) $(AFLAGS) resetsl.s
mdiag.obj:		mdiag.s
	$(AS) $(AFLAGS) mdiag.s
mdmain.obj:		mdmain.s fakeram.h
	$(AS) $(AFLAGS) mdmain.s
utilsl.obj:		utilsl.s
	$(AS) $(AFLAGS) utilsl.s
sdtrsl.obj:		sdtrsl.s
	$(AS) $(AFLAGS) sdtrsl.s
ne.obj:			ne.c net.h splite.h
	$(CC) $(CFLAGS) $*.c
nes.obj:		nes.s 
	$(AS) $(AFLAGS) nes.s
flash.obj:		flash.c 
	$(CC) $(CFLAGS) flash.c
	
