!	Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.          
!	All rights reserved.                                                  

!	This software (including any documentation) is untested, has not been 
!	fully tested for viruses and has been provided to you without charge. 
!	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR    
!	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,  
!	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all    
!	risk of nonperformance, loss of data and other problems and Fujitsu   
!	Microelectronics, Inc. and Fujitsu Limited will not be liable under   
!	any contract, negligence, strict liability or other theory for any    
!	damages including, without limitation, direct, consequential or       
!	incidental nor be required to provide substitute goods, services      
!	or technology.                                                        

! DESCRIPTION
!	This file contains the diagnostic startup code for the EVIL EPROM.
!	Functions:
!	1. Configure SPARClite eval board;
!	2. Test SRAM, DRAM, EPROM checksum, NICE chip, AT interface, timer
!	   interrupt;
!	3. If all tests pass and Ethernet is connected, jump to Ethernet 
!	   monitor;  otherwise, jump to serial line monitor.

! HISTORY
!	July 1991	Roland Chu
!	April 1993	Clark Li
!	March 1995	CCF
! 

.def   	IRQ_ON, 0
.include "utilsl.h"
	.text
	.global	_reset

! Reset Initialization
_reset:					! Initialize everything on reset

! SPARClite initialization
	wr	%g0, PSR_RESET, %psr	! Initialize %psr by chip version

	wr	%g0, 0x1, %wim		! Initialize %wim to window 0

	wr	%g0, 0x0, %tbr		! Initialize %tbr to 0


	! This should be redone after DRAM initialization so the stack can
	!  be put at the top of the DRAM address range.
	sethi	%hi(DRAM_HI_START), %fp	! Initialize frame pointer
	add	%fp, DEFAULT_STACK_FRAME, %sp	! Allocate stack frame.

	! We are presumably in the window we have just designated as
	! invalid, so a save should put things right
	save	%sp, DEFAULT_STACK_FRAME, %sp

.ifdef	SINGLE_VECTOR_TRAP
	.align	4			! Set Ancillary Register 17 bit 1
	.word	0xa3802001		!  to enable single vector trapping
.endif

	! Address Range Register and Address Mask Register are set here
	!  Only the highest nibble of the addresses are used for mapping
	!  the different -CS signals
	! Note: Address range register for -CS0 is preset to 0x04 80 00 00
	!	ASI=0x9, addr<31:10>=0x0

	sethi	%hi(0x41<<19), %l0
				! Set address range register for -CS1:
	or	%g0, 0x124, %l1	!  ASI=0x4, addr<31:28>=0x1
	sta	%l0, [%l1] 1
	nop

	sethi	%hi(0x42<<19), %l0
				! Set address range register for -CS2:
	or	%g0, 0x128, %l1	!  ASI=0x4, addr<31:28>=0x2
	sta	%l0, [%l1] 1
	nop

	sethi	%hi(0xb3<<19), %l0
				! Set address range register for -CS3:
	or	%g0, 0x12c, %l1	!  ASI=0xb, addr<31:28>=0x3
	sta	%l0, [%l1] 1
	nop

	sethi	%hi(0xb4<<19), %l0
				! Set address range register for -CS4:
	or	%g0, 0x130, %l1	!  ASI=0xb, addr<31:28>=0x4
	sta	%l0, [%l1] 1
	nop

.ifdef BOARD_934
	sethi	%hi(0xb5<<19), %l0
.else
	sethi	%hi(0x45<<19), %l0
.endif
				! Set address range register for -CS5:
	or	%g0, 0x134, %l1	!  ASI=0x4, addr<31:28>=0x5
	sta	%l0, [%l1] 1
	nop

	sethi	%hi(0xfdf<<19), %l0   !  ASI<1>=x, addr<27:0>=0xXXXXXXX 
	xnor    %g0, %l0, %l0   !SI and SD ASI, addr=0x0XXXXXXX
	or	%g0, 0x140, %l1 ! Set address mask register for -CS0     	
	or	%g0, 0x144, %l2	! Set address mask register for -CS1 
	sta	%l0, [%l2] 1
	sta	%l0, [%l1] 1
	nop

	! original CS1 (CC1) and CS2 (NICE/AT) masks did not care 
	! about ASI. But these addresses
	! must be accessed with load/store alternate instructions to
	! avoid caching, so we shall let bus timeout police this
	! situation.

	
	sethi	%hi(0x7f<<19), %l0
	xnor	%g0, %l0, %l0	! Set address mask register for -CS1
	or	%g0, 0x144, %l1	!  addr<27:0>=0xXXXXXXX
	sta	%l0, [%l1] 1	!  ASI=4, addr=0x1XXXXXXX
	nop
	
	sethi	%hi(0x7f<<19), %l0
	xnor	%g0, %l0, %l0	! Set address mask register for -CS2
	or	%g0, 0x148, %l1	!  addr<27:0>=0xXXXXXXX
	sta	%l0, [%l1] 1	!  ASI=4, addr=0x2XXXXXXX
	nop

	sethi	%hi(0xfcfff8<<7), %l0 
	or	%l0, %lo(0xfcfff8<<7), %l0
	xnor	%g0, %l0, %l0	! Set address mask register for -CS3
	or	%g0, 0x14c, %l1	!  addr<27:0>=0xXXXXXXX
	sta	%l0, [%l1] 1	!  SI, SD, UI and UD ASI, end addr=0x3001ffff
	nop

	sethi	%hi(0xfcff<<15), %l0 
	xnor	%g0, %l0, %l0	! Set address mask register for -CS4
	or	%g0, 0x150, %l1	!  ASI<1,0>=xx, addr<27:0>=0xXXXXXXX
	sta	%l0, [%l1] 1	!  SI, SD, UI and UD ASI, end addr=0x40ffffff

.ifdef BOARD_934
	sethi	%hi(0xfcff<<15), %l0
.else
	sethi	%hi(0xf<<19), %l0
.endif
	xnor	%g0, %l0, %l0	! Set address mask register for -CS5
	or	%g0, 0x154, %l1	!  addr<27:0>=0xXXXXXXX
	sta	%l0, [%l1] 1	!  ASI=4, addr=0x5XXXXXXX
	nop

	! Set Wait State Specifier Registers
	!  (count=WS-1, WS+1=cycles, count=cycles-2)
        ! set wait state for -CS0(EPROM, lower) and -CS1(CC1, higher)
        or      %g0, 0x160, %l2         ! %l2 = address
        sethi   %hi(0x214<<19), %l1     ! set CC1 value(higher) to %l1
        or      %g0, WS_EPROM, %l0      ! construct EPROM value
        sll     %l0, 6, %l0
        or      %l0, %l1, %l1           ! combine both values
        sta     %l1, [%l2] 1            ! set wait state value
 
        ! set wait state for -CS2(AT/NICE, lower) and -CS3(SRAM, higher)
        or      %g0, 0x164, %l2         ! %l2 = address
        sethi   %hi(0x10d<<19), %l1     ! set SRAM value to %l1
        sta     %l1, [%l2] 1            ! set wait state value
 
        ! set wait state for -CS4(DRAM, lower) and -CS5(OB, higher)
        or      %g0, 0x168, %l2         ! %l2 = address
        or      %g0, 0x0, %l1           ! both values = 0
        sta 	%l1, [%l2] 1            ! set wait state value

.ifdef BOARD_933H
        ! set bus width register 
        set     0x16c, %l2         	! %l2 = address
	set	0x0, %l1		! set all to 32 bits
        sta 	%l1, [%l2] 1            ! set 
.endif

	! set cache/bus-io control register
	sta	%g0, [%g0] 1		! Write Cache/BIU Control Reg
					! Write buffer, prefetch buffer,
					! data cache and instruction cache
					! are all disabled.  Neither cache is
					! locked.

        ! Initialize the Timer Pre-Load Register which is used for Bus Timeout
	! and DRAM refresh.
	! The timer needs to pulse about every 15 us based on the Mhz
        ! of the clock so have the timer go off every REFRESH_PRELOAD cycles.
        or	%g0, REFRESH_PRELOAD, %l0
.ifdef CLK_DOUBLED
	sll	%l0, 1, %l0
.endif
        or	%g0, 0x178, %l1
        sta     %l0, [%l1] 1

.ifdef TIMER_REGISTER
	! Initialize the Timer register as well for the 933H and 936
        or	%g0, REFRESH_PRELOAD, %l0
.ifdef CLK_DOUBLED
	sll	%l0, 1, %l0
.endif
	or	%g0, 0x174, %l1
	sta	%l0, [%l1] 1
.endif

.ifdef BOARD_936
	! Initialize timer for timeout circuit to be 15 KHz
	or	%g0, 0x0990, %l0
	or	%g0, 0x244, %l1
	sta	%l0, [%l1] 1
				! Set TCR3:CE=1, CS=0 (internal clock),
				!  OCONT=3, IV=0 (non inverting O/P),
				!  Mode=2 (square wave generator),
				!  Event=0 (low level).

	or	%g0, REFRESH_PRELOAD, %l0
	or	%g0, 0x248, %l1
	sta	%l0, [%l1] 1
.endif

        ! Initialize Same Page Mask Register
        sethi	%hi(0x7F800000), %l0 ! SAME PG MSK Reg set up for 1M drams
.ifdef BOARD_933H
	or	%l0, 0x0, %l0	     ! SAME PG MSK set up for 256K DRAMS
.else
	or	%l0, 0x6, %l0
.endif
        or	%g0, 0x120, %l1
        sta     %l0, [%l1] 1

	or	%g0, 0x3c, %l0	! Set System Support Control Reg:
	or	%g0, 0x80, %l1	!  -SAME_PAGE, -CS<1:5>, WS generator and
	sta	%l0, [%l1] 1	!  -TIMER_OVF are all enabled

	call	_liteled
	or	%g0, 0xfe, %o0

	set	10000,%l1	! This blips the LEDs on startup 
loopx1:
	subcc	%l1, 0x1, %l1
	bnz	loopx1
	nop

	call	_liteled
	or	%g0, 0x1, %o0

	set	10000,%l1
loopx2:
	subcc	%l1, 0x1, %l1
	bnz	loopx2
	nop

	call	_liteled
	or	%g0, 0xfe, %o0

	! Initialize global registers
	! %g7 = diagnostic test log
	!	bit 0 = 1	sram  test failed
	!	bit 1 = 1	dram  test failed
	!	bit 2 = 1	cksum test failed
	!	bit 3 = 1	nice  test failed
	!	bit 4 = 1	at test failed
	!	bit 5 = 1	timer test failed
	! %g6 = SRAM start addr (0x30000000)
	! %g5 = DRAM end addr 
	clr	%g7
	set	PROG_MEM_START, %g6
	set	SRAM_HI_START, %g5

! SRAM Diagnostics
! Note:
!  1. SRAM is located at 0x3XXXXXXX, ie. -CS3.
!  2. Only 32K or 128K word of address are valid depending on configuration.
	sethi	%hi(SRAM_END), %o0	! First invalid address over 128K.
	sethi	%hi(SRAM_HI_START), %o1	! Upper 96K SRAM start address.
	sethi	%hi(SRAM_START), %o2	! SRAM start address.
	call	_ramtest
	nop
	or	%o0, %g0, %l5		! save return value to %l5

	subcc	%o0, 0x3, %g0		! does sparclite have hi sram?
	be,a	_cont_sram
	sethi	%hi(SRAM_END), %g5	! set top to end of SRAM
	
	sethi	%hi(0xfcfffe<<7), %l0 ! if not, reset address mask register
				! to facilitate bus errors on bad addresses
	or	%l0, %lo(0xfcfffe<<7), %l0
	xnor	%g0, %l0, %l0	! Set address mask register for -CS3
	or	%g0, 0x14c, %l1	!  addr<27:0>=0xXXXXXXX
	sta	%l0, [%l1] 1	!  SI, SD, UI and UD ASI, addr=0x3001XXXX
	nop
	nop
	nop
	nop

_cont_sram:
	set	0x1, %l7
	subcc	%l5, 0x2, %g0	! if sram test failed, set %g7 bit 0 = 1
	bne	LA1
	nop
	or	%g7, 0x1, %g7
.ifdef SDRAM
	mov	%g0, %l7	! put in led save register
.endif
	set	DRAM_HI_START, %g5	! no sram available, set top to DRAM
LA1:
.ifndef SDRAM
	mov	%o0, %l7
.else
	mov	%l7, %o0
.endif
	call	_liteled	! %o0 will have led pattern
	orn	%g0, %o0, %o0	! invert the bits

	! if SRAM is OK, copy program from EPROM to SRAM
	subcc	%l5, 0x2,%g0
	be	done_sram
	nop
	clr	%l0
	set	edata, %l1
        sub     %l1, %g6, %l1           ! minus PROG_MEM_START
	set	SRAM_START, %l2
LA2:
        ld      [%l0], %l3
        st      %l3, [%l2]
        add     %l0, 4, %l0
        add     %l2, 4, %l2
        subcc   %l1, %l0, %g0
        bne     LA2
        nop
done_sram:

.ifdef SDRAM
! SDRAM Diagnostics
! Initialize SDRAM registers
!  Do not initialize SDRAM if switch register position 6 (bit 5) is on
	set	0x1000003, %l2	! switch register
	ldub	[%l2], %l3	
	andcc	%l3, 0x40, %l3
	be	done_sdram
	nop

	set	0x600, %l2	! Set SDRAM mode register
	set	0x3a, %l3	! cas latency of 3,
				!  interleaved burst,
				!  burst length of 4
	sta	%l3, [%l2] 1

	set	0x608, %l2	! Set SDRAM refresh register for 16 us
	set	0x1e0, %l3	! 25 MHz
	sta	%l3, [%l2] 1

	set	0x604, %l2	! Set configuration register
	set	0x9, %l3	! x8 sdram, 64-bit bus, enable sdiu
	sta	%l3, [%l2] 1

	set	(0x1e0*8), %l3	! loop counter for at least 8 auto refreshes
LB1:	
	subcc	%l3, 0x1, %l3	! decrement and loop if not zero
	bne	LB1
	nop

! Note:
!  SDRAM is located at 0x5XXXXXXX, ie. -CS5.
	sethi	%hi(SDRAM_END), %o0
	sethi	%hi(SDRAM_HI_START), %o1
	sethi	%hi(SDRAM_START), %o2	! SDRAM start address.
	call	_ramtest
	nop
	or	%o0, %g0, %l5		! save return value to %l5

	subcc	%o0, 0x3, %g0		! does sparclite have hi sdram?
	be,a	_cont_sdram
	sethi	%hi(SDRAM_END), %g5	! set top to end of SDRAM
	
_cont_sdram:
	subcc	%l5, 0x2, %g0	! sdram test failed?
	be	done_sdram
	nop
	set	DRAM_HI_START, %g5	! no sdram available, set top to DRAM
	or	%l7, 0x2, %l7
	call	_liteled	! %o0 will have led pattern
	orn	%g0, %l7, %o0	! invert the bits

done_sdram:
.endif

! DRAM Diagnostics
! Note:
!  1. DRAM is located at 0x4XXXXXXX, ie. -CS4.
!  2. Only 4MB or 16MB of address are valid depending on configuration.

! Special note for 933:
!  For chip 933, reset procedure takes about 34 seconds. To speed up reset,
!  test DRAM from SRAM.  If SRAM test passed, the above code has moved program
!  from EPROM to SRAM.

.ifdef DRAM_CONFIG_REGS
	set	0x033, %l1 		! 4mb bank
	set	0x7d0, %l0		! DRAM Bank Configuration (bank 0)
	sta	%l1, [%l0] 1

	set	0x433, %l1 		! 4mb bank
	set	0x7d4, %l0		! DRAM Bank Configuration (bank 1)
	sta	%l1, [%l0] 1

	set	0x833, %l1 		! 4mb bank
	set	0x7d8, %l0		! DRAM Bank Configuration (bank 2)
	sta	%l1, [%l0] 1

	set	0xc33, %l1 		! 4mb bank
	set	0x7dc, %l0		! DRAM Bank Configuration (bank 3)
	sta	%l1, [%l0] 1

					! Set DRAM timing for 30 MHz
	set	0x4, %l1 		! RAS precharge = 1 (Henry)
.ifdef CLK_DOUBLED
	set	0x475c, %l1 		! 30 MHZ (Doubled) or slower
.endif
	set	0x7e0, %l0		! DRAM Timing Register 1
	sta	%l1, [%l0] 1

	set	0x4100, %l1 		! CBR = 1, RAS pulse width = 1 (Henry)
.ifdef CLK_DOUBLED
	set	0xc700, %l1 		! 30 MHZ (Doubled) or slower
.endif
	set	0x7e4, %l0		! DRAM Timing Register 2
	sta	%l1, [%l0] 1

	set	0x80, %l0		! system control register
	lda	[%l0] 1, %l1		! read it
	or	%l1, 0x40, %l1 		! enable DRAM controller (bit 6)
	sta	%l1, [%l0] 1
.endif

.ifdef CHIP_933H
! For 933H, set default bank size to 4MB with two banks before initiating
!  memory sizing algorithm.  In fact, if one wishes to use a standard memory
!  configuration, all the work to do dynamic sizing after the next 12 lines
!  is unnecessary.
	set	0x02, %l1 		! 4mb bank
	set	0x7d0, %l0		! DRAM Bank Configuration (bank 0)
	sta	%l1, [%l0] 1

	set	0x402, %l1 		! 4mb bank
	set	0x7d4, %l0		! DRAM Bank Configuration (bank 1)
	sta	%l1, [%l0] 1

	set	0x80, %l0		! system control register
	lda	[%l0] 1, %l1		! read it
	or	%l1, 0x40, %l1 		! enable DRAM controller (bit 6)
	sta	%l1, [%l0] 1

! Calculate valid memory locations before calling ramtest.  Reset base address
!  and size of banks after determining configuration.

! This section writes each megabyte with a word from the top down to the bottom.!  It then looks from the bottom to the top to see if the data is readable.
!  From this it determines size and reprograms bank and size registers
        sethi   %hi(DRAM_END), %l0    	! End of DRAM
        sethi   %hi(DRAM_HI_START - DRAM_START), %l1 ! Minimum size increment 
        sethi   %hi(DRAM_START), %l2    ! DRAM start address.
	set	0xaa55a500, %l3		! Unique value (bank num in low nibble)
	or	%l3, %lo((DRAM_END - DRAM_START) >> 20), %l3 ! number of banks
	sub	%l0, %l1, %l4		! Check first location in each bank
	clr	%l6			! Bit map for valid banks

LC1:					! Write unique value
	sub	%l3, 1, %l3		! Actual bank number now in low nibble
	st	%l3, [%l4]		! Store unique value into last bank loc
	sub	%l4, %l1, %l4		! Move down to previous bank
	subcc	%l4, %l2, %g0		! Check to see if we are back to base loc
	bge	LC1
	nop

LC2:					! Read unique value
        sethi   %hi(DRAM_END), %l0    	! End of DRAM
	add	%l4, %l1, %l4		! Increment location by bank size
	subcc	%l4, %l0, %g0		! Compare to top location
	bge	reset_regs
	nop
	ld	[%l4], %l0		! Read value back
	st	%g0, [%l4]		! Write zero to clear data bus
	subcc	%l0, %l3, %g0		! Compare read with written value
	bne	LC3
	nop
	and	%l0, 0xff, %l0		! Grab off good bank number
	or	%g0, 1, %l2
	sll	%l2, %l0, %l0		! Set bit for this good bank
	or	%l6, %l0, %l6		! Set good bank bit in valid bank mask
LC3:					! No match found
	add	%l3, 1, %l3		! Increment value for next bank
	b	LC2	
	nop

reset_regs:				! Bit map done
	and	%l6, 0x0f, %l4
	and	%l6, 0xf0, %l5

	set	0x400, %l3		
	cmp	%l4, 0x0f		! Check for 4MB in first bank
	bne	LD1
	set	0x2, %l2
	cmp	%l5, 0xf0		! Check for 4MB in second bank
	be,a	LD2
	set	0x402, %l3
	ba,a	LD2

LD1:
	set	0x400, %l2		
	cmp	%l5, 0xf0		! Check for 4MB in second bank
	be	LD2
	set	0x2, %l3
	
	set	0x100, %l3
	cmp	%l4, 0x03		! Check for 1MB in first bank
	be	LD2
	clr	%l2

	set	0x100, %l2
	clr	%l3

LD2:					! Reset DRAM Bank Configuration Register
	set	0x7d0, %l1		! DRAM Bank Configuration (bank 0)
	sta	%l2, [%l1] 1
	set	0x7d4, %l1		! DRAM Bank Configuration (bank 1)
	sta	%l3, [%l1] 1

	cmp	%l4, %g0
	be,a	LD3
	nop
	add	%l4, 1, %l4		! Calculate mem size from bank bit map
	sll	%l4, 18, %l4
LD3:
	cmp	%l5, %g0
	be	LD4
	nop
	srl	%l5, 4, %l5	
	add	%l5, 1, %l5
	sll	%l5, 18, %l5
LD4:
	add	%l4, %l5, %g5		! Store in global DRAM size register
	cmp	%g5, %g0		
	be,a	ramtest_done		! If no DRAM, skip test
	or	%g0, 2, %o0		!  set return value as failed

	sethi	%hi(DRAM_START), %o0
	add	%g5, %o0, %g5
	or	%g5, %g0, %o0

	set	0x100000,%l1		! 1 MB adjustment for proper LED action
	cmp	%l4, %g0		! We want one LED to light if one SIMM
	be,a	LD5			!  is installed, two if two are 
	add	%l1, %o0, %o0		!  installed.
LD5:
	cmp	%l5, %g0
	be,a	LD6
	add	%l1, %o0, %o0
LD6:
	ba,a	LD7
	
.endif

        sethi	%hi(DRAM_END), %o0 	! End of DRAM 
LD7:
        sethi   %hi(DRAM_HI_START), %o1 ! Minimum DRAM high address
        sethi   %hi(DRAM_START), %o2    ! DRAM start address.

	andcc	%g7, 0x1, %g0		! SRAM test failed?
	bne	ramtest_EPROM		!  If yes, test DRAM from EPROM
	nop

	
	! run DRAM test from SRAM 
	
	! constructs the beginning address of _ramtest in SRAM
	set	_ramtest, %l1
	set	PROG_MEM_START, %l2
	sub	%l1, %l2, %l1		! minus PROG_MEM_START
	set	SRAM_START, %l2
	add	%l1, %l2, %l1		! add SRAM_START

	jmpl	%l1, %o7		! Jump to SRAM to test DRAM,
	nop				!  return addr is in %o7
	ba,a	ramtest_done
	nop

ramtest_EPROM:
	call	_ramtest
	nop

ramtest_done:
	mov	%o0, %l5	! save test result

.ifdef BOARD_933H
				! Reset Address Mask Register
	set	(0xfcfffffe>>1), %l0 ! if not, reset address mask register
	sethi	%hi(DRAM_START), %l1
	sub	%g5, %l1, %l2	! Valid memory
	srl	%l2, 9, %l2	! Shift bits to match address mask register
	set	0x2800, %l3
	subcc	%l3, %l2, %g0	! If 5 MBs, set register to be 8 MBs
	be,a	LE1
	set	0x4000, %l2
LE1:
	set	2, %l3
	sub	%l2, %l3, %l2
	xor	%l2, %l0, %l0

	xnor	%g0, %l0, %l0	! Set address mask register for -CS4
	or	%g0, 0x150, %l1	!  ASI<1,0>=xx, addr<27:0>=0xXXXXXXX
	sta	%l0, [%l1] 1	!  SI, SD, UI and UD ASI, end addr=0x40ffffff
	nop
	nop
	nop
	nop
	nop

.else

	subcc	%o0, 0x2, %g0	! does sparclite have no dram?
	be	_cont_dram	!  if so, leave top at end of SRAM
	nop
	sethi	%hi(DRAM_HI_START), %g5 ! set top to minimum DRAM
	subcc	%o0, 0x3, %g0	! does sparclite have hi dram?
	be	_hi_dram_fixup
	nop
	

	sethi	%hi(0xfcffc<<11), %l0 ! if not, reset address mask register
				! to facilitate bus errors on bad addresses
	xnor	%g0, %l0, %l0	! Set address mask register for -CS4
	or	%g0, 0x150, %l1	!  ASI<1,0>=xx, addr<27:0>=0xXXXXXXX
	sta	%l0, [%l1] 1	!  SI, SD, UI and UD ASI, addr=0x403XXXXX
	nop
	nop
	nop
	nop
	ba	_cont_dram
	nop

_hi_dram_fixup:
        ! re-Initialize Same Page Mask Register
        sethi	%hi(0x7F800000), %l0 ! SAME PG MSK Reg set up for 1M drams
	or	%l0, 0x6, %l0
        or	%g0, 0x120, %l1
        sta     %l0, [%l1] 1
	! change end of DRAM to reflect full complement of memory
	sethi	%hi(DRAM_END), %g5

.endif

_cont_dram:
	! reset stack to top of hi-dram
	restore %g0, %g0, %g0	! get back to original window
	or	%g0, %g5, %fp	! Top of stack is at end of DRAM or SRAM
	add	%fp, DEFAULT_STACK_FRAME, %sp	! Allocate stack frame.
	save	%sp, DEFAULT_STACK_FRAME, %sp	! save again

.ifdef DRAM_BURST
!------ On 932 or 936 board, test 1K block dram by burst mode 
	set	0x20, %l0	! Bus Control register address
	set	0x2,  %l1
	sta	%l1,  [%l0] 1	! turn on data burst mode
	set	0x4,  %l1
	sta	%l1,  [%g0] 1	! turn on data cache

	set	DRAM_START + 0x400, %o0	! DRAM_START + 1K
	set	DRAM_START + 0x400, %o1	! DRAM_START + 1K
        set   	DRAM_START, %o2    	! DRAM start address.
	call	_ramtest
	nop

	set	0x20, %l0	! Bus Control register address
	sta	%g0,  [%g0] 1	! turn off cache
	sta	%g0,  [%l0] 1	! turn off data and instruction burst mode

	cmp	%o0, 0x2	! test error?
	be,a	LF1		! dram burst mode test error
	mov	%o0, %l5	! save test result 

.endif

LF1:
	sll	%l5, 2, %l5
	or	%l7, %l5, %l7	! keep current led bits around in %l7
	call	_liteled	! %o0 will have led pattern
	orn	%g0, %l7, %o0	! invert the bits

	subcc	%l5, 0x8, %g0	! if dram test failed, set %g7 bit 1 = 1
	be,a	LF2
	or	%g7, 0x2, %g7

LF2:
	! if DRAM is OK, copy program from EPROM to DRAM
	subcc	%l5, 0x2,%g0
	be	test_cksum
	nop
	clr	%l0
	set	edata, %l1
        sub     %l1, %g6, %l1           ! minus PROG_MEM_START
	set	PROG_MEM_START, %l2
LF3:
        ld      [%l0], %l3
        st      %l3, [%l2]
        add     %l0, 4, %l0
        add     %l2, 4, %l2
        subcc   %l1, %l0, %g0
        bne     LF3
        nop
 

!------ Eprom checksum, if ok, light fifth led
test_cksum:
	set	edata, %o0	! tell cksum where to stop
	call	_prom_cksum
	sub	%o0, %g6, %o0	! minus PROG_MEM_START
	subcc	%o0, %g0, %g0
	bne	test_cksum_fail	! test cksum failed 
	nop
	or	%l7, 0x10, %l7	! keep current led bits around in %l7
	call	_liteled	! %o0 will have led pattern
	orn	%g0, %l7, %o0	! invert the bits
	ba,a	test_nice
test_cksum_fail:
	or	%g7, 0x4, %g7	! cksum test failed, set %g7 bit 2 = 1


!------ Eprom nice diags; light sixth led if ok
test_nice:
	call	_nicetest
	nop
	subcc	%o0, %g0, %g0
	bne	test_nice_fail	! test nice failed
	nop
	or	%l7, 0x20, %l7	! keep current led bits around in %l7
	call	_liteled	! %o0 will have led pattern
	orn	%g0, %l7, %o0	! invert the bits
	ba,a	test_at
test_nice_fail:
	or	%g7, 0x8, %g7	! cksum test failed, set %g7 bit 3 = 1
	

! Check AT interface
! Not much to do here except verify initial value in low two bits of
! the AT status reg.

test_at:
.ifndef AT_INTERFACE
	ba,a	test_flashram
.endif
	sethi	%hi(0x24000000), %l0	! AT interface base addr
	or	%l0, 0x3, %l0		! offset of status byte
	lduba	[%l0] 4, %l6		! get the reg
	and	%l6, 0x3, %l6		! mask bottom bits
	subcc	%l6, 0x2, %g0		! 0x2 is what we should see
	bne	test_at_fail
	nop
	or	%l7, 0x40, %l7
	call	_liteled	! %o0 will have led pattern
	orn	%g0, %l7, %o0	! invert the bits
	ba,a	test_timer
test_at_fail:
	or	%g7, 0x10, %g7	! at test failed, set %g7 bit 4 = 1


test_flashram:
.ifndef FLASH
	ba,a	test_timer
.endif
	! constructs the beginning address of _flash_test in SRAM
	set	_flash_test, %l1

	set	PROG_MEM_START, %l2	! if not, run from SRAM
	sub	%l1, %l2, %l1		! minus PROG_MEM_START

	andcc	%g7, 0x1, %g0		! did we fail the SRAM test?
	bnz	LG1			! if so, run from EPROM
	nop

	set	SRAM_START, %l2		! change to SRAM address
	add	%l1, %l2, %l1		! add SRAM_START

LG1:
	mov	%g7, %l4		! save diagnostic test log
	mov	%g6, %l6		! save PROG_MEM_START
	mov	%g5, %l5		! save DRAM_END (or SRAM end if no DRAM)
	jmpl	%l1, %o7		! Jump to SRAM to test FLASHRAM,
	nop				!  return addr is in %o7
	mov	%l4, %g7		! restore diagnostic test log
	mov	%l6, %g6		! restore PROG_MEM_START
	mov	%l5, %g5		! restore DRAM_END
	cmp	%o0, 0x0
	be	test_flashram_passed
	nop


! FLASH not installed or not working should not generate errror
!	or	%g7, 0x10, %g7	! flashram test failed, set %g7 bit 3 = 1

	ba,a	test_flashram_end
	nop

test_flashram_passed:
	or	%l7, 0x40, %l7
	call	_liteled	! %o0 will have led pattern
	orn	%g0, %l7, %o0	! invert the bits

test_flashram_end:


! MB86940 (CC1) Initialization
! Note:
!  1. SPARClite DATA<31:16> are used as CC1 DATA<15:0>, ie. 16-bit data.
!  2. SPARClite ADDR<6:2> are used as CC1 RS<4:0>
!  3. CC1 is located at ASI 4, 0x1XXXXXXX, ie. -CS1 for MB86930
! For MB86931, CC1 is:
!  1. SPARClite DATA<15:0> is CC1 DATA<15:0>
!  2. SPARClite ADDR<6:2> are used as CC1 RS<4:0>
!  3. CC1 is located at ASI 1, 0x000002XX

! Timer0 (To OB)
!  Prescale Register is at 0x10
!  Timer Control Register is at 0x11
!  Reload Value Register is at 0x12
!  Count Value Register is at 0x13

! Timer1 (To Int3/8)
! NOTE: Timer1 was formerly initialized here but said initialization has
! 	been moved down to beyond the IRC initialization section in order
!	to also accomodate the power-on interrupt test.

! Timer2 (To Int1/13)
!  Timer Control Register is at 0x19
!  Reload Value Register is at 0x1a
!  Count Value Register is at 0x1b

! Timer3 (To TCLK and RCLK of both SDTR)
!  Timer Control Register is at 0x1d
!  Reload Value Register is at 0x1e
!  Count Value Register is at 0x1f

test_timer:

        sethi   %hi(CC1_BASE_ADDR), %l1    ! %l1=TMR0 address.
	or	%l1, %lo(CC1_BASE_ADDR), %l1
	or	%l1, 0x11<<2, %l2
	or	%l1, 0x12<<2, %l3
	or	%l1, 0x19<<2, %l4
	or	%l1, 0x1d<<2, %l5
	or	%l1, 0x1e<<2, %l6


	sethi	%hi(0x09900000), %l0
	CC1_STA_HI %l0, [%l2]
				! Set TCR0:CE=1, CS=0 (internal clock),
				!  OCONT=3, IV=0 (non inverting O/P),
				!  Mode=2 (square wave generator),
				!  Event=0 (low level).

	sethi	%hi(0x61a0000), %l0
	CC1_STA_HI %l0, [%l3]
				! Set RVR0=0x61a so the square wave is 9.6KHz
				!  with a 30MHz input clock.
				! Writing to RVR after CE=1 in TCR starts
				!  the timer.
	sethi	%hi(0x07100000), %l0
	CC1_STA_HI %l0, [%l4]
				! Set TCR2: Timer2 is off, the O/P is set low.


	sethi	%hi(0x09900000), %l0
.ifdef ALT_CLOCK
	sethi	%hi(0x0b900000), %l0
.endif
	CC1_STA_HI %l0, [%l5]
				! Set TCR3:CE=1, CS=0 (internal clock),
				!  OCONT=3, IV=0 (non inverting O/P),
				!  Mode=2 (square wave generator),
				!  Event=0 (low level).

	sethi	%hi(TMR3_RELOAD), %l0
.ifdef ALT_CLOCK
	sethi	%hi(TMR3_RELOAD_SER), %l0
.endif
	CC1_STA_HI %l0, [%l6]
				! Set RVR3=TMR3_RELOAD 
				! so the square wave is 153.6KHz
				! with the given MHz input clock.
				! Writing to RVR after CE=1 in TCR starts
				! the timer.


! Read back some registers to see if CC is configured correctly.
        lda    [%l2] CC1_ASI,   %l0    !TCR0 REG
        nop
        nop
        lda    [%l3] CC1_ASI,   %l0    !RVR0 REG
        nop
        nop
        lda    [%l4] CC1_ASI,   %l0    !TCR2 REG
        nop
        nop
        lda    [%l5] CC1_ASI,   %l0    !TCR3 REG
        nop
        nop
        lda    [%l6] CC1_ASI,   %l0    !RVR3 LATCH
        nop
        nop





! SDTR Initialization
	! SDTR0
	! Data Register 0, DR0, is at 0x8
	! Command/Status Register 0, CSR0, is at 0x9
	! SDTR1
	! Data Register 1, DR1, is at 0xc
	! Command/Status Register 1, CSR1, is at 0xd
	! Note: Only the lower byte of each register is used,
	!       the upper byte should be set to 0.
	!       A delay of 10 clock cylces is needed after each SDTR reg access.

        sethi   %hi(CC1_BASE_ADDR), %l1    ! %l1=TMR0 address.
	or	%l1, %lo(CC1_BASE_ADDR), %l1
	! CSR0 address
	or	%l1, 0x9<<2, %l2
	! CSR1 address
	or	%l1, 0xd<<2, %l3

	! Initialization sequence to put the SDTR in a known reset state
	sethi	%hi(0x0), %l0
	sta	%l0, [%l2] CC1_ASI 
	call	_delay10
	nop
	sta	%l0, [%l3] CC1_ASI 
	call	_delay10
	nop
	sta	%l0, [%l2] CC1_ASI
	call	_delay10
	nop
	sta	%l0, [%l3] CC1_ASI
	call	_delay10
	nop
	sta	%l0, [%l2] CC1_ASI
	call	_delay10
	nop
	sta	%l0, [%l3] CC1_ASI
	call	_delay10
	nop
	sethi	%hi(0x400000), %l0
	CC1_STA_HI %l0, [%l2]
	call	_delay10
	nop
	sta	%l0, [%l3] CC1_ASI
	call	_delay10
	nop

	! Set internal mode register by writing to CSR
	! Internal mode register format for asynchronous mode:
	!  Bits 7, 6: Stop bit length
	!          5: Parity
	!          4: Availability of parity bit
	!       3, 2: Data bit length
	!       1, 0: Data baud rate (must be > 0)
	sethi	%hi(0x4e0000), %l0
	CC1_STA_HI %l0, [%l2]
			 	! Stop bit length=1, No parity, 8 bit data,
				!  Baud rate=Clock input x 1/16
	call	_delay10
	nop
	sta	%l0, [%l3] CC1_ASI
	call	_delay10
	nop

	! Set internal command register by writing to CSR after mode is set
	! Internal command register format:
	!  Bit 7: Not used in asynchronous mode
	!      6: Internal reset
	!      5: -RTS pin
	!      4: Reset internal status register error flags
	!      3: Break code transmit through TRNDT pin
	!      2: Receive enable
	!      1: -DTR pin
	!      0: Transmit enable
	sethi	%hi(0x350000), %l0
	CC1_STA_HI %l0, [%l2]
				! No reset, RTS=0,
				!  Internal status register flags are reset,
				!  Break off-TRNDT normally L, Receive enabled,
				!  DTR=1, Transmit enabled.
	call	_delay10
	nop
	sta	%l0, [%l3] CC1_ASI
	call	_delay10
	nop

! Interrupt Controller Initialization
!  Note:
!	Trigger Mode Register 0, TMR0 is at 0x00.  It controls ch 15:8.
!	Trigger Mode Register 1, TMR1 is at 0x01.  It controls ch 7:1.
!	REQ Clear Register, RCR, is at 0x03.
!	Mask Register, MR, is at 0x04
	
        sethi   %hi(CC1_BASE_ADDR), %l0    ! %l0=TMR0 address.
	or	%l0, %lo(CC1_BASE_ADDR), %l0

        or      %l0, 0x1<<2, %l1        ! %l1=TMR1 address.
        or      %l0, 0x2<<2, %l2        ! %l2=RSR address.
        or      %l0, 0x3<<2, %l3        ! %l3=RCR address.
        or      %l0, 0x4<<2, %l4        ! %l4=MR address.
        or      %l0, 0x5<<2, %l5        ! %l5=ILCR address.

        sethi   %hi(TRIGGER_MODE0), %l6
	CC1_STA_HI %l6, [%l0]         ! Set trigger mode 0.
        sethi   %hi(TRIGGER_MODE1), %l6
	CC1_STA_HI %l6, [%l1]         ! Set trigger mode 1.
        xnor    %g0, %g0, %l6
        sta     %l6, [%l4] CC1_ASI          ! Mask off all interrupts.
        sta     %l6, [%l3] CC1_ASI          ! Clear the REQ-FF.
        sethi   %hi(IRL_CLEAR), %l6
	CC1_STA_HI %l6, [%l5]
	sethi	%hi(IRQ_MASK), %l6
	CC1_STA_HI %l6, [%l4]              ! Mask interrupts.

! Read back some registers to see if CC is configured correctly.
        lda    [%l0] CC1_ASI,   %l6    !TM0 REG
        nop
        nop
        lda    [%l1] CC1_ASI,   %l6    !TM1 REG
        nop
        nop
        lda    [%l4] CC1_ASI,   %l6    !MASK REG
        nop
        nop
        lda    [%l5] CC1_ASI,   %l6    !IRL LATCH
        nop
        nop

	!.ifdef	IRQ_ON
        lda      [%l2] CC1_ASI, %l6         ! Get RSR
        rd      %psr, %l6               ! Get current psr.
        nop
        nop
        nop
        andn    %l6, 0x0f00, %l6        ! Unmask all interrupts.
        wr      %l6, %g0, %psr
        nop
        nop
        nop
	!.endif

! Timer1 (To Int3/8)
!  Prescale Register is at 0x14
!  Timer Control Register is at 0x15
!  Reload Value Register is at 0x16
!  Count Value Register is at 0x17

        sethi   %hi(CC1_BASE_ADDR), %l1    ! %l1=TMR0 address.
	or	%l1, %lo(CC1_BASE_ADDR), %l1

	or	%l1, 0x16<<2, %l3
	or	%l1, 0x15<<2, %l2
	or	%l1, 0x14<<2, %l1
	sethi	%hi(TMR1_PRESCALE), %l0
	CC1_STA_HI %l0, [%l1]
	
	! before we start this timer for real, let us perform some
	! diag which will (at least partially) validate two things:
	
	! 1) we are sucessfully communicating with the MB86940 and
	! 2) we can sucessfully take an interrupt.
	
	! to accomplish this, we will clear the global counter at 0x30003ff8
	! we will then program the timer for mode 1
	! (time-out) and a very small reload value, so we do not have
	! to poll long for results.
	! 
	! After this test we will reprogram Timer1 as a 1 second timer.
	
	sethi	%hi(0x30003ff8), %l6
	or	%l6, %lo(0x30003ff8), %l6
	st	%g0, [%l6]

	sethi	%hi(0x0c000000), %l0
	CC1_STA_HI %l0, [%l2]
				! Set TCR1:CE=1, CS=0 (internal clock),
				!  OCONT=3, IV=0 (non inverting O/P),
				!  Mode=2 (square wave generator),
				!  Event=0 (low level).
	sethi	%hi(0x1000000), %l0 ! program interrupt to fire
				!  in approximately 1/40th of a second.
	CC1_STA_HI %l0, [%l3]
	
	! now poll for a reasonable amount of time waiting for the interrupt
	! to occur.
	sethi	%hi(TMR1_POLL), %l0
poll4int:

	ld	[%l6], %l5
	subcc	%l5, %g0, %g0	! is contents of counter non-zero?
	bne,a	end_poll
	or	%l7, 0x80, %l7	! update led bits signifying success
	nop
	subcc	%l0, 0x1, %l0
	bne	poll4int
	nop
end_poll:
	and	%l7, 0x80, %l0
	subcc	%l0, %g0, %g0	! if timer test failed, set %g7 bit 5 = 1
	bne	LH1
	nop
	or	%g7, 0x20, %g7
LH1:
	call	_liteled	! %o0 will have led pattern
	orn	%g0, %l7, %o0	! invert the bits
	! now set-up Timer for real

	sethi	%hi(0x0c000000), %l0
	CC1_STA_HI %l0, [%l2]
				! Set TCR1:CE=1, CS=0 (internal clock),
				!  OCONT=3, IV=0 (non inverting O/P),
				!  Mode=2 (square wave generator),
				!  Event=0 (low level).
	sethi	%hi(TMR1_RELOAD), %l0 ! This was 0x4e830000 in v1.1 and before
	CC1_STA_HI %l0, [%l3]

.ifdef INT_MODE1
! initialize interrupt mode 1 if switch 8 is off
	set	0x2000003, %l2	! switch register
	ldub	[%l2], %l3	
	andcc	%l3, 0x80, %l3
	bne	done_intmod
	nop

	set	0x00000210, %l4	! IRL MASK register (mask off all ints)
	set	0x0000ffff, %l3
	sta	%l3, [%l4] 1
	lda	[%l4] 1, %l3

	set	0x0000020c, %l4	! IRL REQUEST CLEAR register (clear pendings)
	set	0x0000fffe, %l3
	sta	%l3, [%l4] 1

	set	0x00000208, %l4	! IRL REQUEST SENSE  register
	lda	[%l4] 1, %l3

	set	0x00000214, %l4	! IRL LATCH register (clear)
	set	0x00000010, %l3
	sta	%l3, [%l4] 1
	lda	[%l4] 1, %l3

	set	0x00000210, %l4	! IRL MASK register (turn on int 15)
	set	0x00007ffe, %l3
	sta	%l3, [%l4] 1
	lda	[%l4] 1, %l3

	set	0x00000218, %l4
	set	0x00058d11, %l3 ! CH5:5 CH4:4 CH3:3 CH2:2 CH1:1 Mode1
	sta	%l3, [%l4] 1
	lda	[%l4] 1, %l3

done_intmod:
.endif


!--------------------------------------------------------------------
! Diagnostic test finished.  Jump to monitor.
!--------------------------------------------------------------------
	mov	%g7, %l7		! save diagnostic test log
	mov	%g6, %l6		! save PROG_MEM_START
	mov	%g5, %l5		! save DRAM size

!------ turn on cache for maximum performance 
	call	_cache_on
	nop

!------ turn on FPU (if it is there) for convenience 
	call	_FPUEN
	nop

!------ if alternate monitor location has been modified, jump to that location
	sethi	%hi(_alt_monitor), %l0
	or	%l0, %lo(_alt_monitor), %l0
	ld	[%l0], %l1
	set	0x6d6f6e69, %l2		! string "moni" of "monitor entry" 
	cmp	%l1, %l2
	be	no_alt_mon
	nop
	jmpl	%l0, %o7		! jump to _alt_monitor 
	nop

!------ if no test errors, go to C entry in RAM; otherwise, go to
!       SDTR monitor in EPROM.
no_alt_mon:
	subcc	%g7, %g0, %g0
	bne	to_sdtr_monitor
	nop

!------ Jump to C entry point in RAM
to_c_ram:
	mov	%g5, %o0		! Size of RAM
	set	__main, %l0
	jmpl	%l0, %o7
	nop


to_sdtr_monitor:
	mov	%l7, %g7		! restore diagnostic test log
	mov	%l6, %g6		! restore PROG_MEM_START
        sethi   %hi(CC1_BASE_ADDR), %o0 ! set CSR0 and DR0 address
	or	%o0, %lo(CC1_BASE_ADDR), %o0
	mov	%o0, %o1
	or	%o0, 0x9<<2, %o0
	or	%o1, 0x8<<2, %o1
	call	_SDTR_monitor
	nop

_error:
	call	_liteled		! Indicate error on LED.
	or	%g0, %g0, %o0
	ba	_err_flash_leds
	nop
