
! FILE
!       sdtrsl.s

!	Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.          
!	All rights reserved.                                                  

!	This software (including any documentation) is untested, has not been 
!	fully tested for viruses and has been provided to you without charge. 
!	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR    
!	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,  
!	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all    
!	risk of nonperformance, loss of data and other problems and Fujitsu   
!	Microelectronics, Inc. and Fujitsu Limited will not be liable under   
!	any contract, negligence, strict liability or other theory for any    
!	damages including, without limitation, direct, consequential or       
!	incidental nor be required to provide substitute goods, services      
!	or technology.                                                        

! DESCRIPTION
!       This file contains the SDTR monitor which communicates through the
!	 RS232 port of the EVIL board.  The monitor calls the _xmodem routine
!	 to perform file transfers.  The _xmodem routine utilizes the XMODEM
!	 protocol.

! INTERNAL DESCRIPTION
!       - _SDTR_monitor

.include "utilsl.h"
.def   	aebug, 0
.def   	aebug1, 0
.def   	noxmodem, 0
        .text
	.global _SDTR_monitor

_SDTR_monitor:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
SDTR1:
        or      %g0, %i0, %o0		! CSR to use
	call	_wait4RRDY
        or      %g0, %i1, %o1		! DR to use
	CC1_LDA_LO	[%i1], %l0
        and     %l0, 0xff, %l0
        subcc   %g0, %l0, %g0		! Is it code 0x00
        be      query			! Yes
        nop
        subcc   %l0, 0x1, %g0		! Is it code 0x01
        be      loadram			! Yes
        nop
        subcc   %l0, 0x2, %g0		! Is it code 0x02
        be      run			! Yes
        nop
        subcc   %l0, 0x3, %g0		! Is it code 0x03
        be      execute			! Yes
        nop
        subcc   %l0, 0x4, %g0		! Is it code 0x04
        be      trap2sram		! Yes
        nop
        subcc   %l0, 0x5, %g0		! Is it code 0x05
        be      report_version		! Yes
        nop
        ba      SDTR1
        nop

query:
        call    _wait4TRDY
        sethi   %hi(0xaa0000), %l0
	CC1_STA_HI	%l0, [%i1]	! Transmit ready code: 0xaa
        call    _wait4RRDY
        nop
	lda	[%i1] CC1_ASI, %l0
        call    _wait4TRDY
        nop
        sta     %l0, [%i1] CC1_ASI    ! Transmit received ready code
        call    _liteled
        or      %g0, 0xfe, %o0
        ba      SDTR1
        nop

loadram:
        call    _wait4TRDY
        sethi   %hi(0x5a0000), %l0
	CC1_STA_HI	%l0, [%i1]	   ! Reply to PC
        call    _liteled
        or      %g0, 0xfd, %o0
        or      %g0, %i0, %o0        ! CSR
	call	_sdtr_getword		! Get starting address.
	or	%i1, %g0, %o1	! DR
.ifdef	noxmodem
	call	_sdtr_getfile
	nop
.endif
.ifdef	xmodem
        call    _xmodem
	nop
.endif
        ba      SDTR1
        nop

run:
        call    _wait4TRDY
        sethi   %hi(0x550000), %l0
	CC1_STA_HI	%l0, [%i1]    ! Reply to PC
        or      %g0, %i0, %o0        ! CSR
	call	_sdtr_getword		! Get starting address.
	or	%i1, %g0, %o1	! DR
        call    _liteled
        or      %g0, 0xfc, %o0
        jmpl    %o2, %o7
	nop
donerun:
        call    _wait4RRDY
        or	%g0, %i0, %o0
	lda	[%i1] CC1_ASI, %l0
        call    _wait4TRDY
        nop
        sta     %l0, [%i1] CC1_ASI    ! Transmit received ready code
        call    _liteled
        or      %g0, 0xfb, %o0
        ba      SDTR1
        nop

execute:
        call    _wait4TRDY
        sethi   %hi(0x550000), %l0
	CC1_STA_HI	%l0, [%i1]    ! Reply to PC
        or      %g0, %i0, %o0        ! CSR
	call	_sdtr_getword		! Get starting address.
	or	%i1, %g0, %o1	! DR
        call    _liteled
        or      %g0, 0xfa, %o0
        jmpl    %o2, %o7
	nop
        ba      SDTR1
        nop

trap2sram:
	! %g7 keeps record of diagnostic test result;  if bit0 = 1, 
	! SRAM test failed, so trap table could not be transferred to
	! SRAM.
	andcc	%g7, 0x1, %g0		! test %g7 bit0
	be	LA1			! SRAM is OK
	nop
        call    _wait4TRDY		! SRAM is not OK	
        sethi   %hi(0xad0000), %l0	! Transmit ready code: 0xad
        CC1_STA_HI      %l0, [%i1]      
	ba,a	LA2
	nop
LA1:
        call    _wait4TRDY		! Transmit ready code: 0xab
        sethi   %hi(0xab0000), %l0
        CC1_STA_HI      %l0, [%i1]      
	sethi	%hi(SRAM_START), %l1	! Set %tbr = SRAM_START 
	wr	%l1, 0x0, %tbr
LA2:
        ba      SDTR1
        nop

report_version:
        call    _wait4TRDY
        sethi   %hi(0xac0000), %l0
	CC1_STA_HI	%l0, [%i1]		! Transmit ready code: 0xac

	sethi	%hi(_version), %l1		! get version number address
	or	%l1, %lo(_version), %l1
	set	PROG_MEM_START, %g6		
	sub	%l1, %g6, %l1			! minus PROG_MEM_START
	ldub	[%l1 + 0x0], %l0		! get version number 1 
	sll	%l0, 16, %l0
        call    _wait4TRDY
	nop
	CC1_STA_HI	%l0, [%i1]		! Transmit version number 1

	ldub	[%l1 + 0x1], %l0		! get version number 2
	sll	%l0, 16, %l0
        call    _wait4TRDY
	nop
	CC1_STA_HI	%l0, [%i1]		! Transmit version number 2

        call    _liteled
        or      %g0, 0xfe, %o0
        ba      SDTR1
        nop

done_SDTR_monitor:
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0
 
        ! FUNCTION
        !       _sdtr_getword
        ! DESCRIPTION
        !       This function gets a word from the SDTR and returns the value.
        ! INPUT
        !       - %i0=CSR
        !       - %i1=DR
        ! INTERNAL DESCRIPTION
        !       - Set up some registers
        ! RETURN
        !       - %i2=data
_sdtr_getword:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
	or	%g0, 4, %l0		! Set byte count to 4.
	or	%g0, %g0, %i2		! Initialize return value to 0.
	or	%g0, %i0, %o0		! CSR to use.
sdtrgetword:
	call	_wait4RRDY
	nop
	CC1_LDA_LO	[%i1], %l7
	and	%l7, 0xff, %l7		! Only LSB is valid.
	sub	%l0, 1, %l6		! Byte location.
	sll	%l6, 3, %l6		! Number of bits to shift.
	sll	%l7, %l6, %l7		! Shift byte to proper location.
	or	%l7, %i2, %i2		! Accumulate.
	subcc	%l0, 1, %l0
	bne	sdtrgetword
	nop
done_sdtr_getword:
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

        ! FUNCTION
        !       count_1s
        ! DESCRIPTION
        !       This function get a char from the SDTR and returns the value,
        !        if no data is available for over 1s failure is returned.
        ! INPUT
        !       - %i0=CSR
        !       - %i1=DR
        ! INTERNAL DESCRIPTION
        !       - Set up some registers
        !       - %l1=RRDY mask
        !       - %l2=cycle counter
        ! RETURN
        !       - %i2=0 if failed
        !       - %i3=data if %i2!=0
count_1s:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
        or      %g0, 1, %i2     ! Initialize to indicate valid data
        sethi   %hi(0x20000), %l1
        sethi   %hi(0x10000), %l2
count_1s1:
        subcc   %l2, 1, %l2
        be      fail_count1s
        nop
	CC1_LDA_HI	[%i0], %l0
        and     %l1, %l0, %l0
        subcc   %g0, %l0, %g0
        be      count_1s1
        nop
	CC1_LDA_LO	[%i1], %i3
        and     %i3, 0xff, %i3
        ba      done_count1s
        nop
fail_count1s:
        or      %g0, 0, %i2     ! Indicate invalid data
done_count1s:
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0
 
        ! FUNCTION
        !       count_10s
        ! DESCRIPTION
        !       This function waits for 0x01 from the SDTR and returns,
        !        if no data is available for over 10s failure is returned.
        ! INPUT
        !       - %i0=CSR
        !       - %i1=DR
        ! INTERNAL DESCRIPTION
        !       - Set up some registers
        !       - %l1=RRDY mask
        !       - %l2=cycle counter
        ! RETURN
        !       - %i2=0 no data for more than 10s
        !       - %i3=data if %i2!=0
count_10s:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
        or      %g0, 1, %i2     ! Initialize to indicate valid data
        sethi   %hi(0x20000), %l1
        sethi   %hi(0x1000000), %l2
count_10s1:
        subcc   %l2, 1, %l2
        be      fail_count10s
        nop
	CC1_LDA_HI	[%i0], %l0
        and     %l1, %l0, %l0
        subcc   %g0, %l0, %g0
        be      count_10s1
        nop
	CC1_LDA_LO	[%i1], %i3
        and     %i3, 0xff, %i3
        ba      done_count10s
        nop
fail_count10s:
        or      %g0, 0, %i2     ! Indicate invalid data
done_count10s:
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0
 
        ! FUNCTION
        !       clear_SDTR
        ! DESCRIPTION
        !       This function gets all the data from the SDTR and returns
        !        if no data is available for 1s.
        ! INPUT
        !       - %i0=CSR
        !       - %i1=DR
        ! INTERNAL DESCRIPTION
        ! RETURN
        !       - None
clear_SDTR:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
        sethi   %hi(0x20000), %l1
        sethi   %hi(0x10000), %l2
clear_1s:
        subcc   %l2, 1, %l2
        be      done_clear
        nop
	CC1_LDA_HI	[%i0], %l0
        and     %l1, %l0, %l0
        subcc   %g0, %l0, %g0
        be      clear_1s
        nop
	CC1_LDA_HI	[%i1], %i3
        ba      clear_1s
        sethi   %hi(0x10000), %l2
done_clear:
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0
 
        ! FUNCTION
        !       _sdtr_getfile
        ! DESCRIPTION
        !       This function gets a file from the SDTR and puts it into memory
        !        using a simple protocol.
        ! INPUT
        !       - %i0=CSR
        !       - %i1=DR
        !       - %i2=memory start address
        ! INTERNAL DESCRIPTION
        ! RETURN
        !       - None
_sdtr_getfile:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
! Get filesize
	or	%g0, %i0, %o0
	call	_sdtr_getword
	or	%g0, %i1, %o1
	or	%o2, %g0, %l6	! %l6=filesize
! Get actual file, put into memory, accumulate checksum
! Send checksum
        or      %g0, %g0, %l5   ! Initialize checksum
receive_file:
        call	_wait4RRDY
	nop
	CC1_LDA_LO	[%i1], %l4
        stb     %l4, [%i2]      ! Write to RAM
        add     %i2, 1, %i2     ! Advance RAM address
        add     %l4, %l5, %l5   ! Accumulate local checksum
        subcc   %l6, 1, %l6     ! Decrement data count
        bne     receive_file
        nop
	and	%l5, 0xff, %l5	! Ignore high bytes 
        call    _wait4TRDY
	nop
	CC1_STA_LO	%l5, [%i1]    ! Send checksum
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

        ! FUNCTION
        !       _xmodem
        ! DESCRIPTION
        !       This function gets a file from the SDTR and puts it into memory
        !        using the XMODEM protocol.
        ! INPUT
        !       - %i0=CSR
        !       - %i1=DR
        !       - %i2=memory start address
        ! INTERNAL DESCRIPTION
        ! RETURN
        !       - %i3=0 if failed
 
_xmodem:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
        or      %g0, %i2, %i3   ! Save starting address
NAK:
        mov     %i0, %o0
        call    _wait4TRDY
        sethi   %hi(0x150000), %l0
	CC1_STA_HI	%l0, [%i1]    ! Send NAK
        call    count_10s       ! Resend NAK every 10s
        or      %g0, %i1, %o1
        subcc   %o3, 1, %g0     ! Is it START byte
        bne     resend  ! No
        nop
receive_block:
        call	_wait4RRDY
        or      %g0, %i2, %i3   ! Starting address of this block
	lda	[%i1] CC1_ASI, %l3	! Receive block number
        call	_wait4RRDY
        or      %g0, 128, %l6   ! Initialize data count
	lda	[%i1] CC1_ASI, %l3	! Receive one complement of block number
        or      %g0, %g0, %l5   ! Initialize checksum
receive_data:
	call	_wait4RRDY
	nop
	CC1_LDA_LO	[%i1], %l4	! Receive data
        stb     %l4, [%i2]      ! Write to RAM
        add     %i2, 1, %i2     ! Advance RAM address
        add     %l4, %l5, %l5   ! Accumulate local checksum
        subcc   %l6, 1, %l6     ! Decrement data count
        bne     receive_data
        nop
 
	call	_wait4RRDY
	nop
	CC1_LDA_LO	[%i1], %l4	! Receive checksum
	and	%l4, 0xff, %l4
        and     %l5, 0xff, %l5  ! Ignore carry
 
        subcc   %l4, %l5, %g0   ! Compare checksum
        bne     resend
        nop
        call    _wait4TRDY
        nop
        sethi   %hi(0x060000), %l0
	CC1_STA_HI	%l0, [%i1]    ! ACK
EOT_check:
	call	_wait4RRDY
	nop
	CC1_LDA_LO	[%i1], %l0
	and	%l0, 0xff, %l0
	subcc   %l0, 0x1, %g0   ! Is it START byte
        be      receive_block
        nop
	subcc   %l0, 0x4, %g0   ! Is it EOT
        be      done_xmodem
        nop
 
resend:
        call    clear_SDTR
        or      %g0, %i3, %i2   ! Restore memory pointer to same block
        call    _wait4TRDY
        sethi   %hi(0x150000), %l0
	CC1_STA_HI	%l0, [%i1] 	! NAK
 
        call    count_10s
        nop
        subcc   %o2, 0, %g0
        bne     receive_block
        nop
        or      %g0, 0, %i3     ! Report failure
 
done_xmodem:
        call    _wait4TRDY
        nop
        sethi   %hi(0x060000), %l0
	CC1_STA_HI	%l0, [%i1]    ! ACK
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0
