
! FILE
!	ttblsl.s

!	Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.          
!	All rights reserved.                                                  

!	This software (including any documentation) is untested, has not been 
!	fully tested for viruses and has been provided to you without charge. 
!	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR    
!	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,  
!	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all    
!	risk of nonperformance, loss of data and other problems and Fujitsu   
!	Microelectronics, Inc. and Fujitsu Limited will not be liable under   
!	any contract, negligence, strict liability or other theory for any    
!	damages including, without limitation, direct, consequential or       
!	incidental nor be required to provide substitute goods, services      
!	or technology.                                                        

! DESCRIPTION
!       This file contains the trap table at address 0x0 of the superviser
!	instruction ASI.
!	Note: Four intructions are allowed for each trap type.
!	      tbr is assumed to be set to 0.

! HISTORY
!	1992		Roland
!	April 1993	Clark Li
!	March 1995	CCF
! 

.include	"utilsl.h"
! 	.equ	stepA, 0

	.data
	.ascii "Copyright Fujitsu 1993,1995"  ! insert copyright at beginning 
					  !  of data section

	.global	_version 	! insert version number
_version:			! Version 2.0
	.byte	2
	.byte	0

	.align 8		! cksum should be very last piece of data
	.global _cksumsl
_cksumsl:

.include	"cksumsl.h"
! Declare section at 0x0 where SPARClite looks for instructions after reset
!        .sect   init, text,absolute 0x0
!        .use    init
	.text
	.global	start
	.global	_start
	.global	_traptbl
	
start:
_start:
_traptbl:
! tt = undefined
reset_trap:
.ifdef stepA
	xnor	%g0, %g0, %l0	! Set all bits in Mask Reg 0 to 1
	or      %g0, 0x140, %l1 !  ie. all bits are do not cares
        sta     %l0, [%l1] 1    !  This makes all addresses accessible
	ba,a	_reset_entry	!  So we can branch to the reset trap handler.
.endif
.ifndef	stepA
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba	_reset_entry	! Branch to the reset trap handler.
	nop
.endif
	! Note: The above code is necessary because on reset only 1K words of
	!	the supervisor instruction space is available.  This will be
	!	revised to be 4K words on the production IC.
! tt = 1
instr_access_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_instr_access
! tt = 2
illegal_instr_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_illegal_instr
! tt = 3
privil_instr_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_privil_instr
! tt = 4
fp_disable_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_fp_disable
! tt = 5
win_ovf_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba	_win_ovf
	nop
! tt = 6
win_unf_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba	_win_unf
	nop
! tt = 7
mem_misalign_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_mem_misalign
! tt = 8
fp_exception_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_fp_exception
! tt = 9
data_access_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_data_access
! tt = 10
tag_ovf_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_tag_ovf
! tt = 11
	nop
	nop
	nop
	nop
! tt = 12
	nop
	nop
	nop
	nop
! tt = 13
	nop
	nop
	nop
	nop
! tt = 14
	nop
	nop
	nop
	nop
! tt = 15
	nop
	nop
	nop
	nop
! tt = 16
	nop
	nop
	nop
	nop
! tt = 17
int_1_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_1
! tt = 18
int_2_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_2
! tt = 19
int_3_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_3
! tt = 20
int_4_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_4
! tt = 21
int_5_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_5
! tt = 22
int_6_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_6
! tt = 23
int_7_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_7
! tt = 24
int_8_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_8
! tt = 25
int_9_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_9
! tt = 26
int_10_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_10
! tt = 27
int_11_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_11
! tt = 28
int_12_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_12
! tt = 29
int_13_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_13
! tt = 30
int_14_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_14
! tt = 31
int_15_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_int_15
! tt = 32
	nop
	nop
	nop
	nop
! tt = 33
	nop
	nop
	nop
	nop
! tt = 34
	nop
	nop
	nop
	nop
! tt = 35
	nop
	nop
	nop
	nop
! tt = 36
cp_disable_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_cp_disable
! tt = 37
	nop
	nop
	nop
	nop
! tt = 38
	nop
	nop
	nop
	nop
! tt = 39
	nop
	nop
	nop
	nop
! tt = 40
cp_exception_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_cp_exception
! tt = 41
	nop
	nop
	nop
	nop
! tt = 42
	nop
	nop
	nop
	nop
! tt = 43
	nop
	nop
	nop
	nop
! tt = 44
	nop
	nop
	nop
	nop
! tt = 45
	nop
	nop
	nop
	nop
! tt = 46
	nop
	nop
	nop
	nop
! tt = 47
	nop
	nop
	nop
	nop
! tt = 48
	nop
	nop
	nop
	nop
! tt = 49
	nop
	nop
	nop
	nop
! tt = 50
	nop
	nop
	nop
	nop
! tt = 51
	nop
	nop
	nop
	nop
! tt = 52
	nop
	nop
	nop
	nop
! tt = 53
	nop
	nop
	nop
	nop
! tt = 54
	nop
	nop
	nop
	nop
! tt = 55
	nop
	nop
	nop
	nop
! tt = 56
	nop
	nop
	nop
	nop
! tt = 57
	nop
	nop
	nop
	nop
! tt = 58
	nop
	nop
	nop
	nop
! tt = 59
	nop
	nop
	nop
	nop
! tt = 60
	nop
	nop
	nop
	nop
! tt = 61
	nop
	nop
	nop
	nop
! tt = 62
	nop
	nop
	nop
	nop
! tt = 63
	nop
	nop
	nop
	nop
! tt = 64
	nop
	nop
	nop
	nop
! tt = 65
	nop
	nop
	nop
	nop
! tt = 66
	nop
	nop
	nop
	nop
! tt = 67
	nop
	nop
	nop
	nop
! tt = 68
	nop
	nop
	nop
	nop
! tt = 69
	nop
	nop
	nop
	nop
! tt = 70
	nop
	nop
	nop
	nop
! tt = 71
	nop
	nop
	nop
	nop
! tt = 72
	nop
	nop
	nop
	nop
! tt = 73
	nop
	nop
	nop
	nop
! tt = 74
	nop
	nop
	nop
	nop
! tt = 75
	nop
	nop
	nop
	nop
! tt = 76
	nop
	nop
	nop
	nop
! tt = 77
	nop
	nop
	nop
	nop
! tt = 78
	nop
	nop
	nop
	nop
! tt = 79
	nop
	nop
	nop
	nop
! tt = 80
	nop
	nop
	nop
	nop
! tt = 81
	nop
	nop
	nop
	nop
! tt = 82
	nop
	nop
	nop
	nop
! tt = 83
	nop
	nop
	nop
	nop
! tt = 84
	nop
	nop
	nop
	nop
! tt = 85
	nop
	nop
	nop
	nop
! tt = 86
	nop
	nop
	nop
	nop
! tt = 87
	nop
	nop
	nop
	nop
! tt = 88
	nop
	nop
	nop
	nop
! tt = 89
	nop
	nop
	nop
	nop
! tt = 90
	nop
	nop
	nop
	nop
! tt = 91
	nop
	nop
	nop
	nop
! tt = 92
	nop
	nop
	nop
	nop
! tt = 93
	nop
	nop
	nop
	nop
! tt = 94
	nop
	nop
	nop
	nop
! tt = 95
	nop
	nop
	nop
	nop
! tt = 96
	nop
	nop
	nop
	nop
! tt = 97
	nop
	nop
	nop
	nop
! tt = 98
	nop
	nop
	nop
	nop
! tt = 99
	nop
	nop
	nop
	nop
! tt = 100
	nop
	nop
	nop
	nop
! tt = 101
	nop
	nop
	nop
	nop
! tt = 102
	nop
	nop
	nop
	nop
! tt = 103
	nop
	nop
	nop
	nop
! tt = 104
	nop
	nop
	nop
	nop
! tt = 105
	nop
	nop
	nop
	nop
! tt = 106
	nop
	nop
	nop
	nop
! tt = 107
	nop
	nop
	nop
	nop
! tt = 108
	nop
	nop
	nop
	nop
! tt = 109
	nop
	nop
	nop
	nop
! tt = 110
	nop
	nop
	nop
	nop
! tt = 111
	nop
	nop
	nop
	nop
! tt = 112
	nop
	nop
	nop
	nop
! tt = 113
	nop
	nop
	nop
	nop
! tt = 114
	nop
	nop
	nop
	nop
! tt = 115
	nop
	nop
	nop
	nop
! tt = 116
	nop
	nop
	nop
	nop
! tt = 117
	nop
	nop
	nop
	nop
! tt = 118
	nop
	nop
	nop
	nop
! tt = 119
	nop
	nop
	nop
	nop
! tt = 120
	nop
	nop
	nop
	nop
! tt = 121
	nop
	nop
	nop
	nop
! tt = 122
	nop
	nop
	nop
	nop
! tt = 123
	nop
	nop
	nop
	nop
! tt = 124
	nop
	nop
	nop
	nop
! tt = 125
	nop
	nop
	nop
	nop
! tt = 126
	nop
	nop
	nop
	nop
! tt = 127
	nop
	nop
	nop
	nop
! tt 128 to 254 are software instruction traps.
! tt = 128
_Ticc_1_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_1
! tt = 129
_Ticc_2_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_2
! tt = 130
_Ticc_3_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_3
! tt = 131
_Ticc_4_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_4
! tt = 132
_Ticc_5_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_5
! tt = 133
_Ticc_6_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_6
! tt = 134
_Ticc_7_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_7
! tt = 135
_Ticc_8_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_8
! tt = 136
_Ticc_9_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_9
! tt = 137
_Ticc_10_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_10
! tt = 138
_Ticc_11_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_11
! tt = 139
_Ticc_12_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_12
! tt = 140
_Ticc_13_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_13
! tt = 141
_Ticc_14_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_14
! tt = 142
_Ticc_15_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_15
! tt = 143
_Ticc_16_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_16
! tt = 144
_Ticc_17_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_17
! tt = 145
_Ticc_18_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_18
! tt = 146
_Ticc_19_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_19
! tt = 147
_Ticc_20_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_20
! tt = 148
_Ticc_21_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_21
! tt = 149
_Ticc_22_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_22
! tt = 150
_Ticc_23_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_23
! tt = 151
_Ticc_24_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_24
! tt = 152
_Ticc_25_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_25
! tt = 153
_Ticc_26_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_26
! tt = 154
_Ticc_27_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_27
! tt = 155
_Ticc_28_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_28
! tt = 156
_Ticc_29_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_29
! tt = 157
_Ticc_30_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_30
! tt = 158
_Ticc_31_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_31
! tt = 159
_Ticc_32_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_32
! tt = 160
_Ticc_33_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_33
! tt = 161
_Ticc_34_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_34
! tt = 162
_Ticc_35_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_35
! tt = 163
_Ticc_36_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_36
! tt = 164
_Ticc_37_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_37
! tt = 165
_Ticc_38_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_38
! tt = 166
_Ticc_39_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_39
! tt = 167
_Ticc_40_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_40
! tt = 168
_Ticc_41_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_41
! tt = 169
_Ticc_42_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_42
! tt = 170
_Ticc_43_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_43
! tt = 171
_Ticc_44_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_44
! tt = 172
_Ticc_45_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_45
! tt = 173
_Ticc_46_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_46
! tt = 174
_Ticc_47_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_47
! tt = 175
_Ticc_48_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_48
! tt = 176
_Ticc_49_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_49
! tt = 177
_Ticc_50_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_50
! tt = 178
_Ticc_51_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_51
! tt = 179
_Ticc_52_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_52
! tt = 180
_Ticc_53_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_53
! tt = 181
_Ticc_54_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_54
! tt = 182
_Ticc_55_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_55
! tt = 183
_Ticc_56_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_56
! tt = 184
_Ticc_57_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_57
! tt = 185
_Ticc_58_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_58
! tt = 186
_Ticc_59_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_59
! tt = 187
_Ticc_60_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_60
! tt = 188
_Ticc_61_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_61
! tt = 189
_Ticc_62_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_62
! tt = 190
_Ticc_63_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_63
! tt = 191
_Ticc_64_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_64
! tt = 192
_Ticc_65_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_65
! tt = 193
_Ticc_66_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_66
! tt = 194
_Ticc_67_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_67
! tt = 195
_Ticc_68_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_68
! tt = 196
_Ticc_69_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_69
! tt = 197
_Ticc_70_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_70
! tt = 198
_Ticc_71_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_71
! tt = 199
_Ticc_72_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_72
! tt = 200
_Ticc_73_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_73
! tt = 201
_Ticc_74_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_74
! tt = 202
_Ticc_75_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_75
! tt = 203
_Ticc_76_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_76
! tt = 204
_Ticc_77_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_77
! tt = 205
_Ticc_78_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_78
! tt = 206
_Ticc_79_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_79
! tt = 207
_Ticc_80_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_80
! tt = 208
_Ticc_81_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_81
! tt = 209
_Ticc_82_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_82
! tt = 210
_Ticc_83_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_83
! tt = 211
_Ticc_84_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_84
! tt = 212
_Ticc_85_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_85
! tt = 213
_Ticc_86_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_86
! tt = 214
_Ticc_87_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_87
! tt = 215
_Ticc_88_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_88
! tt = 216
_Ticc_89_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_89
! tt = 217
_Ticc_90_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_90
! tt = 218
_Ticc_91_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_91
! tt = 219
_Ticc_92_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_92
! tt = 220
_Ticc_93_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_93
! tt = 221
_Ticc_94_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_94
! tt = 222
_Ticc_95_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_95
! tt = 223
_Ticc_96_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_96
! tt = 224
_Ticc_97_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_97
! tt = 225
_Ticc_98_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_98
! tt = 226
_Ticc_99_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_99
! tt = 227
_Ticc_100_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_100
! tt = 228
_Ticc_101_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_101
! tt = 229
_Ticc_102_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_102
! tt = 230
_Ticc_103_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_103
! tt = 231
_Ticc_104_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_104
! tt = 232
_Ticc_105_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_105
! tt = 233
_Ticc_106_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_106
! tt = 234
_Ticc_107_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_107
! tt = 235
_Ticc_108_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_108
! tt = 236
_Ticc_109_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_109
! tt = 237
_Ticc_110_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_110
! tt = 238
_Ticc_111_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_111
! tt = 239
_Ticc_112_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_112
! tt = 240
_Ticc_113_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_113
! tt = 241
_Ticc_114_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_114
! tt = 242
_Ticc_115_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_115
! tt = 243
_Ticc_116_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_116
! tt = 244
_Ticc_117_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_117
! tt = 245
_Ticc_118_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_118
! tt = 246
_Ticc_119_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_119
! tt = 247
_Ticc_120_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_120
! tt = 248
_Ticc_121_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_121
! tt = 249
_Ticc_122_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_122
! tt = 250
_Ticc_123_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_123
! tt = 251
_Ticc_124_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_124
! tt = 252
_Ticc_125_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_125
! tt = 253
_Ticc_126_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_126
! tt = 254
_Ticc_127_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_Ticc_127
! tt = 255
emulation_bp_trap:
	rd	%psr, %l0	! %l0=psr at trap time.
	rd	%tbr, %l3	! %l3=tbr at trap time.
	ba,a	_chk4ovflo	! check for reg window overflow
	ba,a	_emulation_bp
! alternate monitor jump location
!   this loc (0x1000) can be patched in with a jmp instruction if needed 
.global	_alt_monitor
_alt_monitor:
	.ascii	"monitor entry"
