
! FILE
!	utilsl.s

!	Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.          
!	All rights reserved.                                                  

!	This software (including any documentation) is untested, has not been 
!	fully tested for viruses and has been provided to you without charge. 
!	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR    
!	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,  
!	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all    
!	risk of nonperformance, loss of data and other problems and Fujitsu   
!	Microelectronics, Inc. and Fujitsu Limited will not be liable under   
!	any contract, negligence, strict liability or other theory for any    
!	damages including, without limitation, direct, consequential or       
!	incidental nor be required to provide substitute goods, services      
!	or technology.                                                        

! DESCRIPTION
!      This file contains utility routines used by other modules in the 
!	Evaluation Board Monitor PROM.

! HISTORY
!	August 1991	Roland Chu
!	April 1993	Clark Li
!	March 1995	CCF
! 

.include	"utilsl.h"
        .text
        .global _liteled
        .global _delay10
        .global _wait4RRDY
        .global _wait4TRDY
        .global _wait4irq
        .global _w2SDTR
	.global	_ramtest
	.global	_ramtest_end
	.global	_prom_cksum
	.global	_nicetest
	.global	_cache_on
	.global	_cache_off

        ! FUNCTION
        !       _liteled
        ! DESCRIPTION
        !       This function lights LEDs as specified by %i0.
        ! INPUT
        !       - %i0=LED data.
        ! INTERNAL DESCRIPTION
        !       - Set up LED address.
        !       - Write %i0 to LED address.
        ! RETURNS
        !       - None.
_liteled:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
        sethi   %hi(0x2000000), %l0
        or      %l0, 0x3, %l0	! LEDs are at address: 0x2000003.
        stb     %i0, [%l0]	! Turn on LEDs per the LSB of %i0, '0' = on.
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

        ! FUNCTION
        !       _delay10
        ! DESCRIPTION
        !       This function provides a delay of 10 CPU cycles.
        ! INPUT
        !       - None
        ! INTERNAL DESCRIPTION
        !       - delay
        ! RETURN
        !       - None
_delay10:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
        nop
        nop
        nop
        nop
        nop
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

        ! FUNCTION
        !       _wait4RRDY
        ! DESCRIPTION
        !       This function examines the status register and returns
        !        when the receive buffer is not empty.
        !       Internal status register format:
        !        Bit 7: -DSR pin level
        !            6: Break code detect
        !            5: Framing error
        !            4: Overrun error
        !            3: Parity error
        !            2: Transmit data buffer/transmission shift register present        !            1: Receive data buffer not empty
        !            0: Transmit data buffer empty
        ! INPUT
        !       - %i0=CSR
        ! INTERNAL DESCRIPTION
        !       -
        ! RETURN
        !       - None
_wait4RRDY:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
        ! %l1=RRDY mask
        sethi   %hi(0x20000), %l1
wait4rrdy:
	CC1_LDA_HI	[%i0], %l0
        andcc   %l1, %l0, %g0
        be      wait4rrdy
        nop
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

        ! FUNCTION
        !       _wait4irq
        ! DESCRIPTION
        !       This function examines the Interrupt Controller REQ Sense
	!	 register and returns when the set bits are the same as in
	!	 %i0.  Then the corresponding bits are cleared in the REQ-FF.
        ! INPUT
        !       - %i0=REQ-FF mask.  1s are bits to check.
        ! INTERNAL DESCRIPTION
        !       -
        ! RETURN
        !       - None
_wait4irq:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
        sethi   %hi(CC1_BASE_ADDR), %l1
	or	%l1, %lo(CC1_BASE_ADDR), %l1
        or      %l1, 0x2<<2, %l1
w4irq:
	CC1_LDA_HI	[%l1], %l0
	and	%i0, %l0, %l0
	xorcc	%i0, %l0, %g0		! Are the interrup bits set?
        bne      w4irq
        nop
        sethi   %hi(CC1_BASE_ADDR), %l1	! REQ Clear Register
	or	%l1, %lo(CC1_BASE_ADDR), %l1
	or	%l1, 0x3<<2, %l1
	sta	%i0, [%l1] CC1_ASI		! Clear the checked bits.
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

        ! FUNCTION
        !       _wait4TRDY
        ! DESCRIPTION
        !       This function examines the status register and returns
        !        when the transmit buffer is empty.
        ! INPUT
        !       - %i0=CSR
        ! INTERNAL DESCRIPTION
        !       - Set up some registers
        ! RETURN
        !       - None
_wait4TRDY:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
        ! %l1=TRDY mask
        sethi   %hi(0x40000), %l1
wait4trdy:
	CC1_LDA_HI	[%i0], %l0
        andcc   %l1, %l0, %g0
        be      wait4trdy
        nop
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

        ! FUNCTION
        !       _w2SDTR
        ! DESCRIPTION
        !       This function writes the contents of a register to the SDTR
	!	 specified by the caller.
        ! INPUT
        !       - %i0=CSR
	!	- %i1=DR
	!	- %i2=data
        ! INTERNAL DESCRIPTION
	!	- Write '*' to DR
	!	- Write data, one nibble at a time, to DR
	!	- Write '+' to DR
        ! RETURN
        !       - None
_w2SDTR:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.

	or	%g0, %i0, %o0	! Pass CSR to _wait4TRDY.

	! Write '*'
	call	_wait4TRDY
        sethi   %hi(0x2a0000), %l0
	CC1_STA_HI	%l0, [%i1]	
	call	_delay10
	nop
        ! Write Nibble 7
	call	_wait4TRDY
        srl     %i2, 28, %l0
        add     %l0, 0x30, %l0
	CC1_STA_LO	%l0, [%i1]	
	call	_delay10
	nop
        ! Write Nibble 6
	call	_wait4TRDY
        sll     %i2, 4, %l0
        srl     %l0, 28, %l0
        add     %l0, 0x30, %l0
	CC1_STA_LO	%l0, [%i1]	
	call	_delay10
	nop
        ! Write Nibble 5
	call	_wait4TRDY
        sll     %i2, 8, %l0
        srl     %l0, 28, %l0
        add     %l0, 0x30, %l0
	CC1_STA_LO	%l0, [%i1]	
	call	_delay10
	nop
        ! Write Nibble 4
	call	_wait4TRDY
        sll     %i2, 12, %l0
        srl     %l0, 28, %l0
        add     %l0, 0x30, %l0
	CC1_STA_LO	%l0, [%i1]	
	call	_delay10
	nop
        ! Write Nibble 3
	call	_wait4TRDY
        sll     %i2, 16, %l0
        srl     %l0, 28, %l0
        add     %l0, 0x30, %l0
	CC1_STA_LO	%l0, [%i1]	
	call	_delay10
	nop
        ! Write Nibble 2
	call	_wait4TRDY
        sll     %i2, 20, %l0
        srl     %l0, 28, %l0
        add     %l0, 0x30, %l0
	CC1_STA_LO	%l0, [%i1]	
	call	_delay10
	nop
        ! Write Nibble 1
	call	_wait4TRDY
        sll     %i2, 24, %l0
        srl     %l0, 28, %l0
        add     %l0, 0x30, %l0
	CC1_STA_LO	%l0, [%i1]	
	call	_delay10
	nop
        ! Write Nibble 0
	call	_wait4TRDY
        sll     %i2, 28, %l0
        srl     %l0, 28, %l0
        add     %l0, 0x30, %l0
	CC1_STA_LO	%l0, [%i1]	
	call	_delay10
	nop
	! Write '+'
	call	_wait4TRDY
        sethi   %hi(0x2b0000), %l0
	CC1_STA_HI	%l0, [%i1]	
	call	_delay10
	nop

        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

	! FUNCTION
        !       _ramtest
        ! DESCRIPTION
	!	This writes all of memory to AAAAAAAA.
	!       Then reads each location looking for the AAAAAAAA and writing
	!	  a 55555555.
	!       If while reading, it encounters an error, it can be for one of 2
	!         reasons:         1.  The memory is bad.
	!			   2.  We have the small sized memory installed
	!			       and have just pasted its last location.
	!			       This is ok.
	!	The program then goes back through all of memory reading the 
	!         55555555 and writing 00000000, again with error checking.
        ! INPUT
        !       - %i0=First invalid address
        !       - %i1=Lowest address of Upper ram
        !       - %i2=Lowest address of ram
        ! RETURN
	!	- 1=Only lower ram available
	!	- 2=Ram failed
	!	- 3=All ram available
_ramtest:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.

	! turn on icache for performance boost
	call	_cache_on
	nop

        or      %g0, %i0, %l0           ! First invalid address.
        or      %g0, %i1, %l1           ! Upper RAM start address.
        or      %g0, %i2, %l2           ! RAM start address.
        sethi   %hi(0xaaaaaaaa), %l3
        or      %l3, %lo(0xaaaaaaaa), %l3
writeAAAA:
        st      %l3, [%l2]              ! Write %l3 to lower RAM.
        add     %l2, 0x4, %l2           ! Advance to next word.
        subcc   %l2, %l0, %g0           ! Is it end address?
        bne     writeAAAA
        nop
        or      %g0, %i2, %l2           ! RAM start address.
	xnor	%l3, %g0, %l4		! second data to write
readAAAA:				!   = 55555555
        ld      [%l2], %l5              ! Read RAM.
	subcc	%l5, %l3, %g0		! compare loaded with written
        be      continueAAAA
	st	%l4, [%l2]		 ! write new data
	!comparision failed, so 2 cases
	!  1. bad memory
	!  2. we have small memory and are in upper part
	subcc	%l2, %l1, %g0		! compare to upper start addr
	bge	endAAAA			! if addr > upper start then ok
	set 	0x1, %i5		! store lower ram flag here
	st	%l2, [%g0]		! write addr to PROM space (debug) 
	st	%l5, [%g0]		! write value to PROM space (debug) 
	! must be bad memory
	ba	exit_ramtest
	set	0x2, %i5		! signal bad ram
continueAAAA:
        add     %l2, 0x4, %l2           ! Advance to next word.
        subcc   %l2, %l0, %g0           ! Is it end address?
        bne     readAAAA
        nop
endAAAA:
        or      %g0, %i2, %l2           ! RAM start address.
	or 	%l4, %g0, %l3		! new comparision data
read5555:				!   = 55555555
        ld      [%l2], %l5              ! Read RAM.
	subcc	%l5, %l3, %g0		! compare loaded with written
        be      continue5555
	st	%g0, [%l2]		! write new data
	!comparision failed, so 2 cases
	!  1. bad memory
	!  2. we have small memory and are in upper part
	subcc	%l2, %l1, %g0		! compare to upper start addr
	bge	exit_ramtest		! if addr > upper start then ok
	set 	0x1, %i5		! store lower ram flag here
	! must be bad memory
	ba exit_ramtest
	set	0x2, %i5		! signal bad ram
continue5555:
        add     %l2, 0x4, %l2           ! Advance to next word.
        subcc   %l2, %l0, %g0           ! Is it end address?
        bne     read5555
        nop
	set	0x3, %i5	! if we got here we have good hi-mem too.
	
	
exit_ramtest:
	call	_cache_off
	nop

	or	%i5, %g0, %i0		! put flag in return register
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

_ramtest_end:


        ! FUNCTION
        !       _prom_cksum
        ! DESCRIPTION
        !       This function calculates the prom checksum (2 byte)
        ! INPUT
        !       - %i0=end of data
        ! INTERNAL DESCRIPTION
        !       - cumulatively add two byte values upto end of data - 4
        !       - last value (ie. edata - 4) when added to cumulative
	!	  total of all previous half words should yield 0 (16 bits).
	!	- if this looks ugly it is because it was generated
	!	  directly from "C" code.
        ! RETURNS
        !       - return result of cumulative addition in %i0.
_prom_cksum:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
	! turn on icache for performance boost
.ifdef SL_CACHE
        or      %g0, SL_ICACHE_LINE, %l7
        or      %g0, %g0, %l0
        sethi   %hi(0x80000000), %l2
icache_loop1:
        sta     %g0, [%l0] 0xc          ! bank0, icache tag asi = 0xc
        sta     %g0, [%l2] 0xc          ! bank1, icache tag asi = 0xc
        add     %l0, SL_ICACHE_BYTENUM, %l0
        subcc   %l7, 1, %l7
        bne     icache_loop1
        add     %l2, SL_ICACHE_BYTENUM, %l2
        or      %g0, 0x01, %l7
        sta     %l7, [%g0] 1            ! turn on icache
        nop
        nop
        nop
.endif

	or	%g0,%g0,%o2	! zero the cumulative sum
	or	%g0,%g0,%o1	! zero the addr ptr.
	sub	%i0,4,%l1	! are we beyond last data item, ie. cksum?
	subcc	%l1,%o1,%g0
	bleu	L4
	nop

	! do checksum calclulation
L1:
	lduh	[%o1],%l2	! get next 16 bit value
	add	%o2,%l2,%o2	! increment cumulative sum
	sll	%o2,16,%o2
	srl	%o2,16,%o2	! truncate to 16 bits
	add	%o1,2,%o1	! increment addr.
	sub	%i0,4,%l4	! are we beyond last data item, ie. cksum?
	subcc	%l4,%o1,%g0
	bgu	L1
	nop
L4:
	!turn off icache
.ifdef SL_CACHE
        sta     %g0, [%g0] 1
        nop
        nop
        nop
.endif

	or	%g0,%o2,%i0	! if successful, should yield zero.
	jmpl	%i7+8,%g0
        restore %g0, %g0, %g0


        ! FUNCTION
        !       _nicetest
        ! DESCRIPTION
        !       This function validates the NICE interface
        ! INPUT
        !       - none
        ! INTERNAL DESCRIPTION
        ! RETURNS
        !       - return result %i0 -- 0 => success.
_nicetest:
        save    %sp, DEFAULT_STACK_FRAME, %sp	! Reserve stack, switch window.
        sethi   %hi(NICEADDR), %l2		! nice reg base address
	or	%l2, DLCR6, %l3
	or	%g0, 0x80, %l4		! disable DLC, 16 bit mode, 
	stba	%l4, [%l3] 4
	or	%l2, DLCR0, %l3
	or	%g0, 0xff, %l4		! clear
	stba	%l4, [%l3] 4
	or	%l2, DLCR1, %l3
	or	%g0, 0xff, %l4		! clear
	stba	%l4, [%l3] 4
	or	%l2, DLCR2, %l3
	or	%g0, 0x0, %l4		! disable tx interrupts
	stba	%l4, [%l3] 4
	or	%l2, DLCR3, %l3
	or	%g0, 0x80, %l4		! enable packet ready interrupt
	stba	%l4, [%l3] 4
	or	%l2, DLCR4, %l3
	or	%g0, 0x06, %l4		! no change
	stba	%l4, [%l3] 4
	or	%l2, DLCR5, %l3
	or	%g0, 0x12, %l4		! enable add_size, set addr match
	stba	%l4, [%l3] 4
	or	%l2, DLCR7, %l3
	or	%g0, 0x20, %l4		! no change
	stba	%l4, [%l3] 4
	or	%l2, IDR8, %l3
	or	%g0, 0x2, %l4		! ether addr
	stba	%l4, [%l3] 4
	or	%l2, IDR9, %l3
	or	%g0, 0x2, %l4		! ether addr
	stba	%l4, [%l3] 4
	or	%l2, IDR10, %l3
	or	%g0, 0x2, %l4		! ether addr
	stba	%l4, [%l3] 4
	or	%l2, IDR11, %l3
	or	%g0, 0x2, %l4		! ether addr
	stba	%l4, [%l3] 4
	or	%l2, IDR12, %l3
	or	%g0, 0x2, %l4		! ether addr
	stba	%l4, [%l3] 4
	or	%l2, IDR13, %l3
	or	%g0, 0x2, %l4		! ether addr
	stba	%l4, [%l3] 4

	! we have just written 0x2 to IDR8 as low-order byte of the Node ID.
	! first we will read that value back, to be sure it stuck, then we
	! will enable DLC DLCR6<7>=0, at which point access to same reg
	! (although IDR bank is still selected) should not be available
	! and we should not see the 0x2 there.
	! for the sake of expediency we, will perform this check on one
	! register of the IDR bank only.
	! The Hash Table regs have the same contstraint (DLCR6<7> must be
	! 1 for r/w access) and could be added if more power-on confidence
	! is required.

	or	%l2, DLCR6, %l3
	or	%g0, 0x45, %l4		! enable DLC, 2 2k tx, 16k sram
	stba	%l4, [%l3] 4

	or	%l2, IDR8, %l3
	lduba	[%l3] 4, %l5
	
	! the "0x2" should be gone.

	subcc	%l5, 0x2, %g0
	be	nice_error
	nop

	or	%l2, DLCR6, %l3
	or	%g0, 0x80, %l4		! disable DLC, 2 2k tx, 16k sram
	stba	%l4, [%l3] 4

	! the "0x2" should be back

	or	%l2, IDR8, %l3
	lduba	[%l3] 4, %l5
	subcc	%l5, 0x2, %g0
	bne	nice_error
	nop

	or	%l2, DLCR6, %l3
	or	%g0, 0x45, %l4		! enable DLC, 2 2k tx, 16k sram
	stba	%l4, [%l3] 4

	or	%l2, DLCR7, %l3
	or	%g0, 0x28, %l4		! select BMR regs
	stba	%l4, [%l3] 4
	or	%g0, %g0, %i0
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

nice_error:
	or	%g0, 0x1, %i0
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                       << 93X Cache Routines>>
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

! Ver 1.0 on Jun/01/95  by Akira  Typos are fixed. Generic version.
! Ver 1.1 on Jun/05/95  by Akira  933H : 0x35 -> 0x31 at 0x00000000 (ASI=1)
! Ver 1.2 on Jun/14/95  by Akira  Cache gets on/off when Burst Mode is off.
! Ver 1.3 on Jul/11/95  by Akira  Work around for 934 Burst Mode off problem.

! 93Xs Cache functions and configurations vary as follows;
!                                   
!               I cache  D cache  clear    prefetch/ burst
!        93X     size     size    flags    w buffer  mode
!     --------  -------  -------  -------  -------  -------
!        930       2K       2K       No      Yes       No
!        931       2K       2K       No      Yes       No
!        932       8K       2K      Yes      Yes      Yes
!        933       No       No       No       No       No
!        933H      1K       No       No      Yes       No
!        934       8K       2K      Yes      Yes      Yes
!        935       4K       2K      Yes      Yes      Yes
!        936       4K       2K      Yes      Yes      Yes

! There are four options.

! Option 1 : CACHE_ZERO    : 933       : No cache. (*1)
! Option 2 : CACHE_1K      : 933H      : 1K I cache with no clear, no burst.
! Option 3 : CACHE_2K_2K   : 930/1     : 2K I&D cache with no clear, no burst.
! Option 4 : CACHE_CLR_BST : 932/4/5/6 : I&D cache with clear, and burst.

!     (*1) Although 933 has no Cache, application program may call
!          cache_on/off routine. The best action to that call is
!          do nothing, instead of doing and ignored by 933.

!=========================================================================
!   << The 934 Burst Mode off problem >>   {934 A/A1/A2/B steps only.}
!=========================================================================
!  If the Burst mode is turned off during the Burst period, IU may get
!  garbage. Its work around is to force the address of "sta" instruction
!  to ...0 or ...8 by using ".align 8", so that the Burst mode is turned
!  off at ...C or ...4; not in the Burst period which address is ...0.
!=========================================================================

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!=========================================================================
! Grouping for Options
!=========================================================================

!-------------------------------------------------------------------------
.ifdef  CHIP_930
.def       CACHE_2K_2K,  1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_931
.def       CACHE_2K_2K,  1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_932
.def       CACHE_CLR_BST, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_933
.def       CACHE_ZERO, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_933H
.def       CACHE_1K, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_934
.def       CACHE_CLR_BST, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_935
.def       CACHE_CLR_BST, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_936
.def       CACHE_CLR_BST, 1
.endif
!-------------------------------------------------------------------------

!=========================================================================
! cache_on() : flush cache, then turn cache on.         <<Leaf Function>>
!=========================================================================
	.global	_cache_on

!-------------------------------------------------------------------------
.ifdef CACHE_ZERO                       ! Do nothing.
_cache_on:
	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_1K
_cache_on:
	sta	%g0, [%g0] 0x1          ! Turn I Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	set	0x80000000, %o0         ! Flush I Cache.
	set	64, %o1                 !  > 64 lines in a bank.
LA1:
	sta	%g0, [%o0] 0xc          !  > I Cache - Bank 2.
	subcc	%o1, 1, %o1
	bne	LA1
	add	%o0, 16, %o0            !  > 16 bytes in each line.

	set 	0x31, %o0               ! Turn I Cache, P&W Buffer on.
	sta	%o0, [%g0] 0x1
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_2K_2K
_cache_on:
	sta	%g0, [%g0] 0x1          ! Turn I&D Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	set	0x00000000, %o0         ! Flush I&D Cache.
	set	0x80000000, %o1
	set	64, %o2                 !  > 64 lines in each bank.
LB1:
	sta	%g0, [%o0]     0xc      !  > I Cache - Bank 1.
	sta	%g0, [%o0]     0xe      !  > D Cache - Bank 1.
	sta	%g0, [%o0+%o1] 0xc      !  > I Cache - Bank 2.
	sta	%g0, [%o0+%o1] 0xe      !  > D Cache - Bank 2.
	subcc	%o2, 1, %o2
	bne	LB1
	add	%o0, 16, %o0            !  > 16 bytes in each line.

	set 	0x35, %o0               ! Turn I&D Cache, P&W Buffer on.
	sta	%o0, [%g0] 0x1
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_CLR_BST
.align	8    ! [ Work around for the 934 Burst Mode off problem. ]
_cache_on:
	nop  ! [ Work around: by .align 8, this ADDR = ...0 or ...8. ]
	set	0x00000020, %o0         ! Turn Burst Mode off.
	sta	%g0, [%o0] 0x1
	nop
	nop
	nop  ! [ Work around: Burst Mode is off at ADDR = ...4 or ...C. ]
	nop

	sta	%g0, [%g0] 0x1          ! Turn I&D Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	set	0x00001000, %o0         ! Flush I&D Cache.
	set	0x80000000, %o1
	set	0x3, %o2
	sta	%o2, [%o0]     0xc      !  > I Cache - Bank 1.
	sta	%o2, [%o0]     0xe      !  > D Cache - Bank 1.
	sta	%o2, [%o0+%o1] 0xc      !  > I Cache - Bank 2.
	sta	%o2, [%o0+%o1] 0xe      !  > D Cache - Bank 2.

	set 	0x35, %o0               ! Turn I&D Cache, P&W Buffer on.
	sta	%o0, [%g0] 0x1
	nop
	nop
	nop
	nop

	set	0x00000020, %o0         ! Turn Burst Mode on.
	set	0x3, %o1
	sta	%o1, [%o0] 0x1
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif


!=========================================================================
! cache_off() : turn cache off.                         <<Leaf Function>>
!=========================================================================
	.global	_cache_off

!-------------------------------------------------------------------------
.ifdef CACHE_ZERO                       ! Do nothing.
_cache_off:
	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_1K
_cache_off:
	sta	%g0, [%g0] 0x1          ! Turn I Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_2K_2K
_cache_off:
	sta	%g0, [%g0] 0x1          ! Turn I&D Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_CLR_BST
.align	8    ! [ Work around for the 934 Burst Mode off problem. ]
_cache_off:
	nop  ! [ Work around: by .align 8, this ADDR = ...0 or ...8. ]
	set	0x00000020, %o0         ! Turn Burst Mode off.
	sta	%g0, [%o0] 0x1
	nop
	nop
	nop  ! [ Work around: Burst Mode is off at ADDR = ...4 or ...C. ]  
	nop

	sta	%g0, [%g0] 0x1          ! Turn I&D Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                        << 93X FPU Routines>>
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! Ver 1.0 on Jul/17/95  by Akira  First one.
!
! 93X's FPU functions are as follows;
!                                   
!        93X      FPU      FIFO
!      -------  -------  -------
!        930       No       No
!        931       No       No
!        932       No       No
!        933       No       No
!        933H      No       No
!        934      Yes      Yes
!        935       No       No
!        936      Yes       No
!
! There are three options.
!
! Option 1 : NO_FPU    : 930/1/2/3/3H/5 : No FPU. (*1)
! Option 2 : FPU_ONLY  : 936            : FPU; no FIFO.
! Option 3 : FPU_FIFO  : 934            : FPU and FIFO.
!
!   (*1) Although some 93x chips have no FPU, application program may call
!        FPUEN/FPUDIS routine. The best action to that call is
!        do nothing, instead of doing and ignored by the chips.
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!=========================================================================
! Grouping for Options
!=========================================================================

!-------------------------------------------------------------------------
.ifdef  CHIP_930
.def   	NO_FPU,		1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_931
.def   	NO_FPU,		1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_932
.def   	NO_FPU,		1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_933
.def   	NO_FPU,		1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_933H
.def   	NO_FPU,		1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_934
.def   	FPU_FIFO,	1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_935
.def   	NO_FPU,		1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_936
.def   	FPU_ONLY,	1
.endif
!-------------------------------------------------------------------------

!=========================================================================
! FPUEN() : enable FPU.                                 <<Leaf Function>> 
!=========================================================================
	.global _FPUEN

!-------------------------------------------------------------------------
.ifdef NO_FPU                           ! Do nothing. 
_FPUEN:
	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef FPU_ONLY
_FPUEN:
	rd	%psr, %o0
	set	(1<<12), %o1            ! PSR[12] EF = 1 
	or	%o0, %o1, %o0
	wr	%o0, %g0, %psr
	nop
	nop
	nop
	nop

	set	0x00400000,%o0
	set	L1A,%o1
	st	%o0, [%o1]
	ld	[%o1], %fsr
	nop	
	nop	! FSR[31:30] RD  = 00    {Rounding Toward Nearest} 
	nop	! FSR[27:23] TEM = 00000 {Disable all IEEE Traps}  
	nop	! FSR[22]    NS  = 1     {Nonstandard FP Mode}     

	jmpl	%o7+8, %g0
	nop

L1A:	.word	0x00400000              ! Work Area 

.endif

!------------------------------------------------------------------------- 
.ifdef FPU_FIFO
_FPUEN:
	rd	%psr, %o0
	set	(1<<12), %o1            ! PSR[12] EF = 1 
	or	%o0, %o1, %o0
	set	(1<<13), %o1            ! PSR[13] EC = 0 
	andn	%o0, %o1, %o0
	wr	%o0, %g0, %psr
	nop
	nop
	nop
	nop

	set	0x00400000,%o0
	set	L1B,%o1
	st	%o0, [%o1]
	ld	[%o1], %fsr
	nop	
	nop	! FSR[31:30] RD  = 00    {Rounding Toward Nearest} 
	nop	! FSR[27:23] TEM = 00000 {Disable all IEEE Traps}  
	nop	! FSR[22]    NS  = 1     {Nonstandard FP Mode}     

	! rd	%asr17, %o0 
	.word	0x91444000
	set	(1<<3), %o1             ! ASR17[3] EFIFO = 1 
	or	%o0, %o1, %o0
	! wr	%o0, %g0, %asr17 
	.word	0xa3820000
	nop
	nop
	nop
	nop

	jmpl	%o7+8, %g0
	nop

L1B:	.word	0x00400000              ! Work Area 

.endif


!=========================================================================
! FPUDIS() : disable FPU.                               <<Leaf Function>> 
!=========================================================================
	.global _FPUDIS

!-------------------------------------------------------------------------
.ifdef NO_FPU                           ! Do nothing.
_FPUDIS:
	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef FPU_ONLY
_FPUDIS:
	rd	%psr, %o0
	set	(1<<12), %o1            ! PSR[12] EF = 0
	andn	%o0, %o1, %o0
	wr	%o0, %g0, %psr
	nop
	nop
	nop
	nop

	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef FPU_FIFO
_FPUDIS:
	rd	%psr, %o0
	set	(1<<12), %o1            ! PSR[12] EF = 0
	andn	%o0, %o1, %o0
	set	(1<<13), %o1            ! PSR[13] EC = 0
	andn	%o0, %o1, %o0
	wr	%o0, %g0, %psr
	nop
	nop
	nop
	nop

	! rd	%asr17, %o0 
	.word	0x91444000
	set	(1<<3), %o1             ! ASR17[3] EFIFO = 0
	andn	%o0, %o1, %o0
	! wr	%o0, %g0, %asr17 
	.word	0xa3820000
	nop
	nop
	nop
	nop

	jmpl	%o7+8, %g0
	nop
.endif


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

