/* 
 *      id: @(#)mb86940.h 1.2 96/07/18
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/


/*
 MB86940 (MB8693X Companion Chip) Register definition
 Note:
  1. SPARClite 930 DATA<31:16> are used as CC1 DATA<15:0>, ie. 16-bit data.
  2. SPARClite 931 DATA<15:0> are used as CC1 DATA<15:0>, ie. 16-bit data.
  3. SPARClite ADDR<2:6> are used as CC1 RS<0:4>
  4. On the 930, CC1 is located at ASI 4, 0x1XXXXXXX, ie. -CS1
  5. On the 931, CC1 is located at ASI 1, 0x2XX

 Timer0 
  Prescale Register is at 0x10
  Timer Control Register is at 0x11
  Reload Value Register is at 0x12
  Count Value Register is at 0x13
 Timer1 
  Prescale Register is at 0x14
  Timer Control Register is at 0x15
  Reload Value Register is at 0x16
  Count Value Register is at 0x17
 Timer2 
  Timer Control Register is at 0x19
  Reload Value Register is at 0x1a
  Count Value Register is at 0x1b
 Timer3 
  Timer Control Register is at 0x1d
  Reload Value Register is at 0x1e
  Count Value Register is at 0x1f

 SDTR0
  Data Register 0, DR0, is at 0x8
  Command/Status Register 0, CSR0, is at 0x9
 SDTR1
  Data Register 1, DR1, is at 0xc
  Command/Status Register 1, CSR1, is at 0xd
 Note: Only the lower byte of each SDTR register is used,
       the upper byte should be set to 0.

 IRC
  Trigger Mode Register 0, TMR0 is at 0x00.  It controls ch 15:8.
  Trigger Mode Register 1, TMR1 is at 0x01.  It controls ch 7:1.
  REQ Sense Register, RSR, is at 0x02.
  REQ Clear Register, RCR, is at 0x03.
  Mask Register, MR, is at 0x04
  IRL Clear Register, ICR, is at 0x05.
*/

#define	CC1_IRC_TMR0   (CC1_BASE_ADDR + 0x00)
#define	CC1_IRC_TMR1   (CC1_BASE_ADDR + 0x04)
#define	CC1_IRC_RSR    (CC1_BASE_ADDR + 0x08)
#define	CC1_IRC_RCR    (CC1_BASE_ADDR + 0x0c)
#define	CC1_IRC_MR     (CC1_BASE_ADDR + 0x10)
#define	CC1_IRC_ICR    (CC1_BASE_ADDR + 0x14)

#define	SDTR_BASE      (CC1_BASE_ADDR + 0x20)
#define	CC1_SDTR_DR0   (CC1_BASE_ADDR + 0x20)
#define	CC1_SDTR_CSR0  (CC1_BASE_ADDR + 0x24)
#define	CC1_SDTR_DR1   (CC1_BASE_ADDR + 0x30)
#define	CC1_SDTR_CSR1  (CC1_BASE_ADDR + 0x34)

#define	CC1_Timer_PR0  (CC1_BASE_ADDR + 0x40)
#define	CC1_Timer_TCR0 (CC1_BASE_ADDR + 0x44)
#define	CC1_Timer_RVR0 (CC1_BASE_ADDR + 0x48)
#define	CC1_Timer_CVR0 (CC1_BASE_ADDR + 0x4c)
#define	CC1_Timer_PR1  (CC1_BASE_ADDR + 0x50)
#define	CC1_Timer_TCR1 (CC1_BASE_ADDR + 0x54)
#define	CC1_Timer_RVR1 (CC1_BASE_ADDR + 0x58)
#define	CC1_Timer_CVR1 (CC1_BASE_ADDR + 0x5c)
#define	CC1_Timer_TCR2 (CC1_BASE_ADDR + 0x64)
#define	CC1_Timer_RVR2 (CC1_BASE_ADDR + 0x68)
#define	CC1_Timer_CVR2 (CC1_BASE_ADDR + 0x6c)
#define	CC1_Timer_TCR3 (CC1_BASE_ADDR + 0x74)
#define	CC1_Timer_RVR3 (CC1_BASE_ADDR + 0x78)
#define	CC1_Timer_CVR3 (CC1_BASE_ADDR + 0x7c)

#define RRDY 2
#define TRDY 1
#define TEMPTY 4

#define CC1_put(ADDR,DATA) \
  write_asi (CC1_ASI, ADDR, DATA << CC1_SHIFT)

#define CC1_get(ADDR) \
  ({unsigned long c; \
    read_asi (CC1_ASI, ADDR, c); \
    c >> CC1_SHIFT; \
   })



