/* 
 *      id: @(#)startup.c 1.2 96/08/02
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/



#include <stdio.h>
#include "board.h"

/* Defined in the linker command script */
extern long datac;
extern long data;
extern long edata;
extern long bss_start;
extern long end;

do_main() {

    /* Call actual application */
    main();

    /* Cleanup and return startup loop */
    exit(0);
}
    

/* This routine saves the program's initialized variables so they
   can be reinitialized. This enables running the program multiple times.
*/
void
save_data() {
  long *src, *dst;
#if 0
	unsigned long *tmp;
#endif

  src = &data;
  dst = &datac;
#if 1
  while (src < &edata) 
     *dst++ = *src++;
#else
	tmp = (unsigned long *)(0x08e00000);
	*tmp = *src;
	src++;
	*dst = *tmp;
	dst++;
# if 0
	while(src < &edata){
		asm volatile("ld [%0], %%g4" : "r="(src) );
		asm volatile("nop; nop; nop; nop; nop");
		asm volatile("ld [%0], %%g1; nop; st %%g1, [%0]" :: "r" (0x08e00000));
		asm volatile("nop; nop; nop; nop; nop");
		asm volatile("st %%g4, [%0]" : "r=" (dst) );
		asm volatile("nop; nop; nop; nop; nop");
		src++;
		dst++;
	}
# endif
#endif
}

/* Initialize the program's initialized variables */
void
init_data() { 
  long *src, *dst;

  src = &datac;
  dst = &data;
  while (dst < &edata) 
     *dst++ = *src++;
}

/* Zero the program's uninitialized variables */
void
init_bss() {
  long *src, *dst;

  for (dst=&bss_start; dst<&end; dst++)
    *dst = 0;
}

/* startup is where we do
    - System level initiailzation not already in crt0.s
    - Provide support for GDB; "debug" is a switch which enables the GDB debugger stub
      to load its trap handlers and issue a breakpoint before running the program.
    - Loop forever so user can rerun program without reload for programs without
      a built in loop.
*/
void
startup(debug) 
int debug;   
{
  /* For the debug case we are running under control of GDB.  
     Each loop " breaks" into the GDB stub. For the non-debug
     case we are probably executing under control of the ROM
     loader/monitor so we don't loop here.  The ROM monitor has
     the capability to re-execute the program.*/

  /* initialize sdtr 1 again in case it failed */
	/* 0 0 0 40 4e 35(37)? */	
#if 0
asm("

	sethi %hi(0xffff6000), %l0
	or	%g0, 0x34,%l2
!	call	_delay_l
	sta	%g0, [%l0 + %l2] 0x4
	nop
!	call	_delay_l
	sta	%g0, [%l0 + %l2] 0x4
	nop

!	call	_delay_l
	sta	%g0, [%l0 + %l2] 0x4
	nop

	or	%g0, 0x40, %l1
!	call	_delay_l
	sta	%l1, [%l0 + %l2] 0x4
	nop

	or	%g0, 0x4e, %l1
!	call	_delay_l
	sta	%l1, [%l0 + %l2] 0x4
	nop

	or 	%g0, 0x37, %l1
!	call	_delay_l
	sta	%l1, [%l0 + %l2] 0x4
	nop

");
#endif
	
	
  /*********************************************/
#if 1
	while(1){
		putCharPort1('w');
		putCharPort1('r');
		putCharPort1('i');
		putCharPort1('t');
		putCharPort1('e');
		putCharPort1('!');
		putCharPort1('\n');
		putCharPort1('\r');
	}
#endif
  /**********************************************/

#if 1
	cache_off();
#endif
#if 1
  save_data();
#endif

  if (debug) {
     while (1) {
#if 0
       cache_on();
#endif
       FPU_ON;
#if 0
       init_data();
#endif
       init_bss();
       set_debug_traps();
       breakpoint();   
       do_main();
       cache_off(); 
     }
  }
  else {
#if 0
     cache_on();
#endif
     FPU_ON;
     init_data();
     init_bss();
     do_main();
     cache_off(); 
  }
}

