#include <stdio.h>
#include <string.h>

usage(char *prog ){
	printf("Usage: READ:  r address size\n");
	printf("       WRITE: w address data0 data1 ...\n");
/*	printf("       QUIT:  q \n"); */
}

edit( char *src )
{
	char *p, *q;

	for( p = src, q = src; *p; p++ ) {
		if( *p == '\010' ) {
			if( q != src )
				--q;
		}
		else {
			*q++ = *p;
		}
	}
	*q = '\0';
}

main() {
	int type;
	unsigned addr;
	int size;
	volatile unsigned int *ptr;
	int i, j;
	char buf[BUFSIZ];
	char *token;

	while( 1 ) {
		printf( "MON>" );
		if( !fgets( buf, BUFSIZ, stdin ) )
			break;
		edit( buf );
		if( !(token = strtok( buf, " \t\n" )) ) {
			usage( "mon" );
			continue;
		}
		type = *token;
		if( !(token = strtok( NULL, " \t\n" )) ) {
			usage( "mon" );
			continue;
		}
		ptr = (volatile unsigned int *)strtoul( token, NULL, 0 );

		if( type == 'r' ) {
			if( !(token = strtok( NULL, " \t\n" )) ) {
				usage( "mon" );
				continue;
			}
			size = strtoul( token, NULL, 0 );
			for( i = 0; i < size; i += 4 ) {
				printf( "%08x| ", (unsigned)(ptr+i) );
				for( j = 0; j < 4 && (i+j) < size; j ++ ) {
					printf( "%08x ", ptr[i+j] );
				}
				printf( "\n" );
			}
		}
		else if( type == 'w' ) {
			i = 0;
			while( token = strtok( NULL, " \t\n" ) ) {
				ptr[i] = strtoul( token, NULL, 0 );
				i++;
			}
		}
		else
			usage( "mon" );
	}
}
