/* 
 *      id: @(#)crt0.s 1.3 96/07/18
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/


! C startup code for the Fujitsu SPARClite demo board

#include "board.h"

	.text
	.align 8

	.globl start

start:
        save %sp, -0x80, %sp
	
	! First, copy prom & trap vectors to ram

	set ROM_COPY_BASE, %l0
	set ROM_COPY_SIZE-8, %l1

copyloop:
	ldd [%l1], %l2
	std %l2, [%l0 + %l1]
	subcc %l1, 8, %l1
	bge copyloop
	nop

	mov %l0, %tbr			! Install the new tbr
	nop
	nop
	nop

#if 0
	set win_ovf_trap, %l1		! Setup window overflow trap
	ldd [%l1], %l2
	std %l2, [%l0 + 5 * 16]
	ld [%l1 + 8], %l2
	st %l2, [%l0 + 5 * 16 + 8]

	set win_unf_trap, %l1		! Setup window underflow trap
	ldd [%l1], %l2
	std %l2, [%l0 + 6 * 16]
	ld [%l1 + 8], %l2
	st %l2, [%l0 + 6 * 16 + 8]
#endif

#ifdef DEBUG
	set 0x1, %o0
#else
	set 0x0, %o0
#endif	
	set _startup, %g1
	jmpl %g1, %o7
	nop

	/* Return to PROM */
	ret
	restore


