/* 
 *      id: @(#)ser86940.c 1.1 96/07/18
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/


/* Input/Output using the Serial Data Transmitter/Receiver MB86940 */

/* The MB86940 has two uarts and the evaluation board has two corresponding
   serial connections. The debug port is port 0.  This is used by the GDB
   debugger Port 1 is used by is used by C library standard I/O.
*/

#include "sparclit.h"
#include "board.h"
#include "mb86940.h"

#define PORTA 0
#define PORTB 1
#define get_uart_status(PORT) CC1_get(SDTR_BASE + 0x4 + PORT*0x10)
#define xmt_char(PORT, C)     CC1_put(SDTR_BASE + PORT*0x10, C)
#define rcv_char(PORT)        CC1_get(SDTR_BASE + PORT*0x10)

#define update_leds()


/* The MB86940 needs a 20 cycles to be updated once written 
   This loop is code for 40 cycles to account for clock doubling
   internal to some processors.
*/
extern void uart_delay();
asm ("
_uart_delay: 
         addcc %g0, 40, %o0
         bg .       
         deccc %o0       /* SPARC delay slot */
         retl
");


 /* 1/5th of a second? */
#define LEDTIME (20000000 / 500)

int
getDebugChar()
{
  unsigned long countdown = LEDTIME;

  update_leds();
  while (1)
    {
      if ((get_uart_status(PORTA) & RRDY) != 0) break;

      if (countdown-- == 0)
	{
	  countdown = LEDTIME;
	  update_leds();
	}
    }
  return rcv_char(PORTA);
}

void
putDebugChar(c)
     int c;
{
  update_leds();
  while ((get_uart_status(PORTA) & TRDY) == 0) ;
  xmt_char(PORTA, c);
  uart_delay();
}

int
getCharPort1()
{
  while (1)
    {
      if ((get_uart_status(PORTB) & RRDY) != 0) break;
    }
  return rcv_char(PORTB);
}

/* Output one character to the serial port */

void
putCharPort1(c)
     int c;
{
	update_leds();
#if 0
  while ((get_uart_status(PORTB) & TEMPTY) == 0) ;
#else
  while ((get_uart_status(PORTB) & TRDY) == 0) ;
#endif
  xmt_char(PORTB, c);
  uart_delay();
}

/* We do the CR/NEWLINE stuff in write() and read() here.  It should
   really be done a serial "driver" which has a raw and cooked mode.
   But for now this S/W has no real notion of various devices
   with drivers (it always uses the serial port). And for now
   we always assume a terminal is attached so we use cooked. 
*/

int
write(fd, data, length)
     int fd;
     unsigned char *data;
     int length;
{
  int count;
  unsigned char ch;

  count = length ;
  while (length--) {
     char ch;
     ch=*data++;
     if ((ch == '\n' || ch == '\r')) {
       putCharPort1('\n'); /* do both a line feed and return. */
       putCharPort1('\r');
      } else {
       putCharPort1(ch);
     }
   }
  return count;
}

int
read(fd, data, length)
     int fd;
     unsigned char *data;
     int length;
{
  int end_char=0;
  int count = 0;
  char ch;

  do {
    ch = getCharPort1();

    switch (ch) {

    case '\n':
    case '\r':
      *data++ = ch;
      putCharPort1(ch);
      putCharPort1('\r');
      count++;
      end_char = 1;
      break;  

    default:
      *data++ = ch;
      putCharPort1(ch);
      count++;

   } 
  } while (count<length && end_char==0);
  return count;
}

/* Set the baud rate for the serial port, returns 0 for success,
   -1 otherwise */

#if 0
int
set_baud_rate(baudrate)
     int baudrate;
{
  /* Convert baud rate to uart clock divider */
  switch (baudrate)
    {
    case 38400:
      baudrate = 16;
      break;
    case 19200:
      baudrate = 33;
      break;
    case 9600:
      baudrate = 65;
      break;
    default:
      return -1;
    }

  set_timer_3(baudrate);	/* Set it */
}
#endif

