#
#   id: @(#)common.mak 1.7 96/08/01
#
#   Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
#   All rights reserved.
#
#   This software (including any documentation) is untested, has not been
#   fully tested for viruses and has been provided to you without charge.
#   ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
#   IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
#   FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
#   risk of nonperformance, loss of data and other problems and Fujitsu
#   Microelectronics, Inc. and Fujitsu Limited will not be liable under any
#   contract, negligence, strict liability or other theory for any damages
#   including, without limitation, direct, consequential or incidental nor
#   be required to provide substitute goods, services or technology.
#
#



# This the common make file for building the SPARClite evaluation
# board system library  It is included by the make file for each
# SPARClite chip.  

# Definition of host (Unix v. DOS) specifics
include $(SLITELIB)/host.mak

CHIPLIB         = $(SLITELIB)/chips/$(CHIP)

# Compiler etc. switches. We use O2; sparcl-stub.c has a problem with O3

INCLUDES        = -I . -I $(CHIPLIB) -I $(SLITELIB) -I $(C_INCLUDES)
CCFLAGS         = -g -O2 -c $(INCLUDES)
CPPFLAGS        = $(INCLUDES)
ASFLAGS         = 
LDFLAGS         = 

SYSHEADERS = \
board.h \
$(CHIPLIB)/chip.h \
$(SLITELIB)/sparclit.h \
$(SLITELIB)/mb86940.h \
$(SLITELIB)/amd85c30.h

SLITEOBJS = \
startup.o \
fpu.o \
led.o \
cache.o \
traps.o \
winhdlr.o \
sparcl-s.o \
syscalls.o \
$(BOARDOBJS)

# Chip specific stuff
include $(CHIPLIB)/chip.mak

# make rules for "system" object modules

all: crt0.o crt0debug.o asi.o libslite.a

crt0.o: $(SLITELIB)/crt0.s  ${SYSHEADERS}
	$(CPP) $(CPPFLAGS) $(SLITELIB)/crt0.s crt0.i
	$(AS) $(ASFLAGS) -o $@ crt0.i

crt0debug.o: $(SLITELIB)/crt0.s  ${SYSHEADERS}
	$(CPP) $(CPPFLAGS) -DDEBUG $(SLITELIB)/crt0.s crt0debug.i
	$(AS) $(ASFLAGS) -o $@ crt0debug.i

libslite.a: $(SLITEOBJS)
	$(DEL) libslite.a
	$(AR) r $@ $(SLITEOBJS)

fpu.o: $(SLITELIB)/fpu.s 
	$(CPP) $(CPPFLAGS) $(SLITELIB)/fpu.s fpu.i
	$(AS) $(ASFLAGS) -o $@ fpu.i

ser86940.o: $(SLITELIB)/ser86940.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(SLITELIB)/ser86940.c

ser85c30.o: $(SLITELIB)/ser85c30.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(SLITELIB)/ser85c30.c

asi.o: $(SLITELIB)/asi.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(SLITELIB)/asi.c

startup.o: $(SLITELIB)/startup.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(SLITELIB)/startup.c

led.o: $(SLITELIB)/led.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(SLITELIB)/led.c

cache.o: $(CHIPLIB)/cache.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(CHIPLIB)/cache.c

traps.o: $(SLITELIB)/traps.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(SLITELIB)/traps.c

winhdlr.o: $(SLITELIB)/winhdlr.s ${SYSHEADERS}
	$(CPP) $(CPPFLAGS) $(SLITELIB)/winhdlr.s winhdlr.i
	$(AS) $(ASFLAGS) -o $@ winhdlr.i

sparcl-s.o: $(SLITELIB)/sparcl-s.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(FPUFLAGS) $(SLITELIB)/sparcl-s.c

syscalls.o: $(SLITELIB)/syscalls.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(SLITELIB)/syscalls.c

tim86940.o: $(SLITELIB)/tim86940.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(SLITELIB)/tim86940.c

tim86936.o: $(SLITELIB)/tim86936.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(SLITELIB)/tim86936.c

tim82c54.o: $(SLITELIB)/tim82c54.c ${SYSHEADERS}
	$(CC) $(CCFLAGS) $(SLITELIB)/tim82c54.c

clean: 
	${DEL} *.i
	${DEL} *.o
	${DEL} *.a
