/* 
 *      id: @(#)tim86936.c 1.1 96/07/18
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/

#include "sparclit.h"
#include "board.h"

/* GET_TIME returns the BootROM maintained time in usecs. It assumes that the BootROM:
   1) Maintains a memory location (SECONDS_ADDR) which is incremented every 1 sec
   2) Timer 1's counter is programmed to decrement every 50 usec and timeout every 1 sec.
*/

#define	TIMER1_PR  0x250
#define	TIMER1_TCR 0x254
#define	TIMER1_RVR 0x258
#define	TIMER1_CVR 0x25c
#define TIMER1_TICK_USECS 50
#define TIMER1_RELOAD 1000000/TIMER1_TICK_USECS

volatile unsigned int *seconds = (unsigned int *)SECONDS_ADDR;

/* GET_TIME and RESET_TIME are capitalized for compatibility
   with previous versions of the evaluation board s/w 
*/

unsigned int
GET_TIME() {
  return( *seconds*1000000 + ((TIMER1_RELOAD - MB93X_GET(TIMER1_CVR)&0xffff) * TIMER1_TICK_USECS) );
}

void
RESET_TIMER() {
	*seconds = 0 ;
}
