#include "mb86941.h"
typedef	unsigned int	u_int;

u_int sysintr_enable(sysintr_t mask)
{
	*(volatile u_int *)CC1_IRC_MR &= ~(u_int)mask;

	return *(volatile u_int *)CC1_IRC_MR;
}

u_int sysintr_disable(sysintr_t mask)
{
	*(volatile u_int *)CC1_IRC_MR |= (u_int)mask;

	return *(volatile u_int *)CC1_IRC_MR;
}

u_int sysintr_getpend(void)
{
	return (*(volatile u_int *)CC1_IRC_RSR & 0x0000FFFF);
}

void sysintr_clear(sysintr_t mask)
{
	*(volatile u_int *)CC1_IRC_RCR = (u_int)mask;
	*(volatile u_int *)CC1_IRC_ICR = IRL_CLEAR;
}

u_int sysintr_maskall(void)
{
	*(volatile u_int *)CC1_IRC_MR = INTR_DISABLE;
	*(volatile u_int *)CC1_IRC_TMR0 = 0x00002000;
	*(volatile u_int *)CC1_IRC_TMR1 = 0x00008080;
	*(volatile u_int *)CC1_IRC_RCR = REQ_ALL_CLEAR;
	*(volatile u_int *)CC1_IRC_ICR = IRL_CLEAR;
	*(volatile u_int *)CC1_IRC_MR = INTR_MASKALL;
	return 0;
}

/*
 * for Cascade0 IRC 
 */
u_int cas0intr_enable(cas0intr_t mask)
{
	*(volatile u_int *)CAS0_IRC_MR &= ~(u_int)mask;

	return *(volatile u_int *)CAS0_IRC_MR;
}

u_int cas0intr_disable(cas0intr_t mask)
{
	*(volatile u_int *)CAS0_IRC_MR |= (u_int)mask;

	return *(volatile u_int *)CAS0_IRC_MR;
}

u_int cas0intr_getpend(void)
{
	return (*(volatile u_int *)CAS0_IRC_RSR & 0x0000FFFF);
}

void cas0intr_clear(cas0intr_t mask)
{
	*(volatile u_int *)CAS0_IRC_RCR = (u_int)mask;
	*(volatile u_int *)CAS0_IRC_ICR = IRL_CLEAR;
}

u_int cas0intr_maskall(void)
{
	*(volatile u_int *)CAS0_IRC_MR = INTR_DISABLE;
	*(volatile u_int *)CAS0_IRC_TMR0 = 0x00008000;
	*(volatile u_int *)CAS0_IRC_TMR1 = 0x00000008;
	*(volatile u_int *)CAS0_IRC_RCR = REQ_ALL_CLEAR;
	*(volatile u_int *)CAS0_IRC_ICR = IRL_CLEAR;
//	*(volatile u_int *)CAS0_IRC_MR = INTR_MASKALL;

	return 0;
}
