/* 
 *      id: @(#)cache.c 1.1 95/09/28
 *
 *      Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *      All rights reserved.
 *
 *      This software (including any documentation) is untested, has not been
 *      fully tested for viruses and has been provided to you without charge.
 *      ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *      IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *      FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *      risk of nonperformance, loss of data and other problems and Fujitsu
 *      Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *      contract, negligence, strict liability or other theory for any damages
 *      including, without limitation, direct, consequential or incidental nor
 *      be required to provide substitute goods, services or technology.
 *
*/


/* SPARClite MB86831 Cache Routines */

#include "sparclit.h"

# define CACHE_DELAY \
    asm ("nop"); \
    asm ("nop"); \
    asm ("nop"); \
    asm ("nop"); 

void
cache_off ()
{
  write_asi (0x1, 0x20, 0);       /* Turn Burst Mode off */
  CACHE_DELAY
  write_asi (0x1, 0, 0);
  CACHE_DELAY
}

void
cache_on ()
{
  cache_off ();

  write_asi (0xc, 0x00001000, 3); /* Clear bank 1, icache */
  write_asi (0xc, 0x80001000, 3); /* Clear bank 2, icache */
  write_asi (0xe, 0x00001000, 3); /* Clear bank 1, dcache */
  write_asi (0xe, 0x80001000, 3); /* Clear bank 2, dcache */

  write_asi (1, 0, 0x35);       /* Write buf, prefetch buf, D/I caches enable */
  CACHE_DELAY

  write_asi (0x1, 0x20, 3);     /* Turn Burst Mode on */
  CACHE_DELAY
}

void
i_cache_on ()
{
  cache_off ();

  write_asi (0xc, 0x00001000, 3); /* Clear bank 1, icache */
  write_asi (0xc, 0x80001000, 3); /* Clear bank 2, icache */
  write_asi (0xe, 0x00001000, 3); /* Clear bank 1, dcache */
  write_asi (0xe, 0x80001000, 3); /* Clear bank 2, dcache */

  write_asi (1, 0, 0x31);       /* Write buf, prefetch buf, D/I caches enable */
  CACHE_DELAY
}


/* flush_i_cache needd by GDB */

void
flush_i_cache ()
{
  int cache_reg;
  unsigned long addr;

  read_asi (1, 0, cache_reg);   /* Read cache/bus interface reg */

  if (!(cache_reg & 1))
    return;                     /* Just return if cache is already off */

  write_asi (0xc, 0x00001000, 3); /* Clear bank 1, icache */
  write_asi (0xc, 0x80001000, 3); /* Clear bank 2, icache */

}

