/* 
 *      id: @(#)sparclit.h 1.4 96/07/18
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/


/* SPARClite defs */

/* Macros for reading and writing to arbitrary address spaces.  Note that ASI
   must be a constant (sorry, but the SPARC can only specify ASIs as part of an
   instruction.  */

#define read_asi(ASI, LOC, VAL) \
  __asm__ volatile ("lda [%r1]%2,%0" : "=r" (VAL) : "rJ" (LOC), "I" (ASI))

#define write_asi(ASI, LOC, VAL) \
  __asm__ volatile ("sta %0,[%r1]%2" : : "r" (VAL), "rJ" (LOC), "I" (ASI));

#define read_asi_b(ASI, LOC, VAL) \
  __asm__ volatile ("lduba [%r1]%2,%0" : "=r" (VAL) : "rJ" (LOC), "I" (ASI))

#define write_asi_b(ASI, LOC, VAL) \
  __asm__ volatile ("stba %0,[%r1]%2" : : "r" (VAL), "rJ" (LOC), "I" (ASI));

/* Use this when modifying registers that cause memory to be modified.  This
   will cause GCC to reload all values after this point.  */

#define write_asi_volatile(ASI, LOC, VAL) \
  __asm__ volatile ("sta %0,[%r1]%2" : : "r" (VAL), "rJ" (LOC), "I" (ASI) \
		    : "memory");

/* Access Processor State Register (PSR) */
#define read_psr()							\
  ({									\
    unsigned int psr;							\
    __asm__ ("mov %%psr, %0" : "=r" (psr));				\
    psr;								\
  })
#define write_psr(VAL)							\
  __asm__ ("mov %0, %%psr \n nop \n nop \n nop" : : "r" (VAL));

#define MB93X_GET(ADDR) \
  ({unsigned long c; \
    read_asi(0x1, ADDR, c); \
    c; \
   })

extern void Write_Asi();
extern int Read_Asi();
