/*

	monitor program

	based on yamasaki-san's mon.c
	enhanced for USB development
*/

#include <stdio.h>
#include <string.h>

#define	DELIM	" \t\n"
#define	ADDR	0x020a0000

void ASI4put(unsigned long data, unsigned long address);
unsigned long ASI4get(unsigned long address);

void usage(char *prog ){
	printf("Usage: READ:              r address size\n");
	printf("       WRITE:             w address data0 data1 ...\n");
	printf("       READ  (ASI=0x4):   R address size\n");
	printf("       WRITE (ASI=0x4):   W address data0 data1 ...\n");
	printf("       USB STATUS:        s\n");
	printf("       USB write COMMAND: C data\n");
	printf("       USB write STATUS:  S data\n");
	printf("       USB DMA STATS:     a\n");
	printf("       USB DMA read:      d\n");
	printf("       USB DMA read (buf):D\n");
/*	printf("       QUIT:  q \n"); */
}

void edit( char *src )
{
	char *p, *q;

	for( p = src, q = src; *p; p++ ) {
		if( *p == '\010' ) {
			if( q != src )
				--q;
		} else {
			*q++ = *p;
		}
	}
	*q = '\0';
}

main()
{
	int type;
	unsigned long addr;
	int size;
	volatile unsigned long *ptr;
	int i, j;
	char buf[BUFSIZ];
	char *token;

	unsigned long	*l;

	while( 1 ) {
		printf( "MON>" );
		if( !fgets( buf, BUFSIZ, stdin ) )
			break;
		edit( buf );
		if( !(token = strtok( buf, DELIM )) ) {
			usage( "mon" );
			continue;
		}
		type = *token;

		switch( type ) {
			/*-----------------------------------------*/
			case 'r':
			if( !(token = strtok( NULL, DELIM )) ) {
				usage( "mon" );
				continue;
			}
			ptr = (volatile unsigned long *)
						strtoul( token, NULL, 0 );
			if( !(token = strtok( NULL, DELIM )) ) {
				usage( "mon" );
				continue;
			}
			size = strtoul( token, NULL, 0 );
			for( i = 0; i < size; i += 4 ) {
				printf( "%08x| ", (unsigned)(ptr+i) );
				for( j = 0; j < 4 && (i+j) < size; j ++ ) {
					printf( "%08x ", ptr[i+j] );
				}
				printf( "\n" );
			}
			break;
			/*-----------------------------------------*/
			case 'w':
			if( !(token = strtok( NULL, DELIM )) ) {
				usage( "mon" );
				continue;
			}
			ptr = (volatile unsigned long *)
						strtoul( token, NULL, 0 );
			i = 0;
			while( token = strtok( NULL, DELIM ) ) {
				ptr[i] = strtoul( token, NULL, 0 );
				i++;
			}
			break;
			/*-----------------------------------------*/
			case 'R':
			if( !(token = strtok( NULL, DELIM )) ) {
				usage( "mon" );
				continue;
			}
			ptr = (volatile unsigned long *)
						strtoul( token, NULL, 0 );
			if( !(token = strtok( NULL, DELIM )) ) {
				usage( "mon" );
				continue;
			}
			size = strtoul( token, NULL, 0 );
			for( i = 0; i < size; i += 4 ) {
				printf( "%08x| ", (unsigned)(ptr+i) );
				for( j = 0; j < 4 && (i+j) < size; j ++ ) {
/*
					printf( "%08x ", ASI4get(
					(unsigned long) &(ptr[i+j]) ) );
*/
					printf( "%08x ", ASI4get(
					(unsigned long) ptr + (i+j)*4 ) );
				}
				printf( "\n" );
			}
			break;
			/*-----------------------------------------*/
			case 'W':
			if( !(token = strtok( NULL, DELIM )) ) {
				usage( "mon" );
				continue;
			}
			ptr = (volatile unsigned long *)
						strtoul( token, NULL, 0 );
			i = 0;
			while( token = strtok( NULL, DELIM ) ) {
/*
				ASI4put( strtoul( token, NULL, 0 ),
					(unsigned long) &(ptr[i]) );
*/
				ASI4put( strtoul( token, NULL, 0 ),
					(unsigned long) ptr + i*4 );
				i++;
			}
			break;
			/*-----------------------------------------*/
			case 's':
			size = 8;
			ptr = (volatile unsigned long *)0xffff4000;
			for( i = 0; i < size; i += 4 ) {
				printf( "%08x| ", (unsigned)(ptr+i) );
				for( j = 0; j < 4 && (i+j) < size; j ++ ) {
/*
					printf( "%08x ", ASI4get(
					(unsigned long) &(ptr[i+j]) ) );
*/
					printf( "%08x ", ASI4get(
					(unsigned long) ptr + (i+j)*4 ) );
				}
				printf( "\n" );
			}
			break;
			/*-----------------------------------------*/
			case 'S':
			ptr = (volatile unsigned long *) 0xffff4000;
			if( !(token = strtok( NULL, DELIM )) ) {
				usage( "mon" );
				continue;
			}
			ASI4put( strtoul( token, NULL, 0 ),
					(unsigned long) ptr );
			break;
			/*-----------------------------------------*/
			case 'C':
			ptr = (volatile unsigned long *) 0xffff4004;
			if( !(token = strtok( NULL, DELIM )) ) {
				usage( "mon" );
				continue;
			}
			ASI4put( strtoul( token, NULL, 0 ),
					(unsigned long) ptr );
			break;
			/*-----------------------------------------*/
			case 'a':
			size = 40;
			ptr = (volatile unsigned long *)0xffff2000;
			for( i = 0; i < size; i += 4 ) {
				printf( "%08x| ", (unsigned)(ptr+i) );
				for( j = 0; j < 4 && (i+j) < size; j ++ ) {
/*
					printf( "%08x ", ASI4get(
					(unsigned long) &(ptr[i+j]) ) );
*/
					printf( "%08x ", ASI4get(
					(unsigned long) ptr + (i+j)*4 ) );
				}
				printf( "\n" );
			}
			break;
			/*-----------------------------------------*/
			case 'd':
*(volatile unsigned long *)0x020a0000 = 0x12345678;
*(volatile unsigned long *)0x020a0004 = 0x23456789;
*(volatile unsigned long *)0x020a0008 = 0x3456789a;
*(volatile unsigned long *)0x020a000c = 0x456789ab;
*(volatile unsigned long *)0x020a0010 = 0x23456789;
*(volatile unsigned long *)0x020a0014 = 0x3456789a;
*(volatile unsigned long *)0x020a0018 = 0x456789ab;
*(volatile unsigned long *)0x020a001c = 0x56789abc;
*(volatile unsigned long *)0x020a0020 = 0x3456789a;
*(volatile unsigned long *)0x020a0024 = 0x456789ab;
*(volatile unsigned long *)0x020a0028 = 0x56789abc;
*(volatile unsigned long *)0x020a002c = 0x6789abcd;
ASI4put( 0x0, 0xffff2000);
ASI4put( 0x020a0000, 0xffff2004);
ASI4put( 0x020b0000, 0xffff2008);
ASI4put( 0x16, 0xffff2018);
/*
ASI4put( 0x1, 0xffff2020);
ASI4put( 0x1, 0xffff2024);
ASI4put( 0x1, 0xffff2028);
ASI4put( 0x1, 0xffff202c);
ASI4put( 0x1, 0xffff2034);
ASI4put( 0x1, 0xffff2038);
ASI4put( 0x1, 0xffff203c);
ASI4put( 0x1, 0xffff2040);
ASI4put( 0x1, 0xffff2044);
ASI4put( 0x1, 0xffff2048);
ASI4put( 0x1, 0xffff204c);
ASI4put( 0x1, 0xffff2054);
ASI4put( 0x1, 0xffff2058);
ASI4put( 0x1, 0xffff205c);
ASI4put( 0x1, 0xffff2060);
ASI4put( 0x1, 0xffff2064);
ASI4put( 0x1, 0xffff2068);
ASI4put( 0x1, 0xffff206c);
ASI4put( 0x1, 0xffff2074);
ASI4put( 0x1, 0xffff2078);
ASI4put( 0x1, 0xffff207c);
*/
/*
			size = 8;
			ptr = (volatile unsigned long *)ADDR;
			for( i = 0; i < size; i += 4 ) {
				*((unsigned long *)
					((unsigned long) ptr + i*4)) = 0x0;
			}

			*(volatile unsigned long *)0xffff2004 = 0xffff4008;
			*(volatile unsigned long *)0xffff2008 = ADDR;
			*(volatile unsigned long *)0xffff2010 = 0x00000421;
			for( i = 0; i < 1000; i ++ ) {
				i++;
			}
			for( i = 0; i < size; i += 4 ) {
				printf( "%08x| ", (unsigned)(ptr+i) );
				for( j = 0; j < 4 && (i+j) < size; j ++ ) {
					printf( "%08x ", 
					*((unsigned long *)
					((unsigned long) ptr + (i+j)*4)) );
				}
				printf( "\n" );
			}
*/
			break;
			/*-----------------------------------------*/
			case 'D':
			size = 8;
			ptr = (volatile unsigned long *)ADDR;
			for( i = 0; i < size; i += 4 ) {
				printf( "%08x| ", (unsigned)(ptr+i) );
				for( j = 0; j < 4 && (i+j) < size; j ++ ) {
					printf( "%08x ", 
					*((unsigned long *)
					((unsigned long) ptr + (i+j)*4)) );
				}
				printf( "\n" );
			}
			break;
			/*-----------------------------------------*/
			default:
			usage( "mon" );
			break;
		}
	}
}
