/* 
 *      id: @(#)winhdlr.s 1.1 95/09/28
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/



/* This file contains the SPARC register window overflow and
   underflow trap handler routines.
*/	
#include "board.h"

	.text
	.align 8

	.globl win_ovf_trap

win_ovf_trap:
	sethi %hi(win_ovf), %l3
	jmpl %lo(win_ovf)+%l3, %g0
	mov %wim, %l0
	nop

	.globl win_unf_trap

win_unf_trap:
	sethi %hi(win_unf), %l3
	jmpl %lo(win_unf)+%l3, %g0
	mov %wim, %l0
	nop

! Register window overflow handler.  Come here when save would move us
! into the invalid window.  This routine runs with traps disabled, and
! must be careful not to touch the condition codes, as PSR is never
! resored.
!
! We are called with %l0 = wim, %l1 = pc, %l2 = npc
!

	.globl win_ovf
win_ovf:
	mov	%g1, %l3		!  Save g1, we use it to hold the wim 
	srl	%l0, 1, %g1		! Rotate wim right 
	sll	%l0, NWINDOWS-1, %l0
	or	%l0, %g1, %g1

	save	%g0, %g0, %g0		! Slip into next window 
	mov	%g1, %wim		! Install the new wim 

	std	%l0, [%sp + 0 * 4]	! save L & I registers 
	std	%l2, [%sp + 2 * 4]
	std	%l4, [%sp + 4 * 4]
	std	%l6, [%sp + 6 * 4]

	std	%i0, [%sp + 8 * 4]
	std	%i2, [%sp + 10 * 4]
	std	%i4, [%sp + 12 * 4]
	std	%i6, [%sp + 14 * 4]

	restore				! Go back to trap window. 
	mov	%l3, %g1		! Restore %g1 

	jmpl	%l1,  %g0
	rett	%l2

! Register window underflow handler.  Come here when restore would move us
! into the invalid window.  This routine runs with traps disabled, and
! must be careful not to touch the condition codes, as PSR is never
! restored.
!
! We are called with %l0 = wim, %l1 = pc, %l2 = npc


	.globl win_unf
win_unf:
	sll	%l0, 1, %l3		!  Rotate wim left 
	srl	%l0, NWINDOWS-1, %l0
	or	%l0, %l3, %l0

	mov	%l0, %wim		!  Install the new wim 

	restore				! Window of the user
	restore				! Window of his caller

	ldd	[%sp + 0 * 4], %l0	! restore L & I registers 
	ldd	[%sp + 2 * 4], %l2
	ldd	[%sp + 4 * 4], %l4
	ldd	[%sp + 6 * 4], %l6

	ldd	[%sp + 8 * 4], %i0
	ldd	[%sp + 10 * 4], %i2
	ldd	[%sp + 12 * 4], %i4
	ldd	[%sp + 14 * 4], %i6

	save	%g0, %g0, %g0		! Back to trap window 
	save	%g0, %g0, %g0

	jmpl	%l1,  %g0
	rett	%l2



