/*
 * Micro PULSER
 * Copyright (c) 1991, 1992, 1993, 1994, 1995 Anzai Laboratory, Keio University
 *
 *  FILE: mb86941.h
 *
 *  $Id: mb86941.h,v 1.2 1998/08/14 06:37:16 kouji Exp $
 */

/* 
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/

#ifndef _MP_ULSI_MB86941_H_
#define _MP_ULSI_MB86941_H_

/*
 MB86941 (MB8693X Companion Chip) Register definition
 Note:
  1. SPARClite 930 DATA<31:16> are used as CC1 DATA<15:0>, ie. 16-bit data.
  2. SPARClite 931 DATA<15:0> are used as CC1 DATA<15:0>, ie. 16-bit data.
  3. SPARClite ADDR<2:6> are used as CC1 RS<0:4>
  4. On the 930, CC1 is located at ASI 4, 0x1XXXXXXX, ie. -CS1
  5. On the 931, CC1 is located at ASI 1, 0x2XX

 Timer0 
  Prescale Register is at 0x10
  Timer Control Register is at 0x11
  Reload Value Register is at 0x12
  Count Value Register is at 0x13
 Timer1 
  Prescale Register is at 0x14
  Timer Control Register is at 0x15
  Reload Value Register is at 0x16
  Count Value Register is at 0x17
 Timer2 
  Timer Control Register is at 0x19
  Reload Value Register is at 0x1a
  Count Value Register is at 0x1b
 Timer3 
  Timer Control Register is at 0x1d
  Reload Value Register is at 0x1e
  Count Value Register is at 0x1f

 SDTR0
  Data Register 0, DR0, is at 0x8
  Command/Status Register 0, CSR0, is at 0x9
 SDTR1
  Data Register 1, DR1, is at 0xc
  Command/Status Register 1, CSR1, is at 0xd
 Note: Only the lower byte of each SDTR register is used,
       the upper byte should be set to 0.

 IRC
  Trigger Mode Register 0, TMR0 is at 0x00.  It controls ch 15:8.
  Trigger Mode Register 1, TMR1 is at 0x01.  It controls ch 7:1.
  REQ Sense Register, RSR, is at 0x02.
  REQ Clear Register, RCR, is at 0x03.
  Mask Register, MR, is at 0x04
  IRL Clear Register, ICR, is at 0x05.

 PIO
  Port Data Register, PDR is at 0x20.
  Port Direction Control Register, DCR is at 0x21.
*/

/* Specifics of MB86941 */
#define CC1_ASI       4
#define CC1_BASE_ADDR 0xffff6000
#define CC1_SHIFT     0

#define IRC_BASE		(CC1_BASE_ADDR + 0x00)
#define	CC1_IRC_TMR0	(CC1_BASE_ADDR + 0x00)	/* IRC Trigger Mode Reg 0 */
#define	CC1_IRC_TMR1	(CC1_BASE_ADDR + 0x04)	/* IRC Trigger Mode Reg 1 */
#define	CC1_IRC_RSR		(CC1_BASE_ADDR + 0x08)	/* IRC Rquest Sense Reg */
#define	CC1_IRC_RCR		(CC1_BASE_ADDR + 0x0c)	/* IRC Rquest Clear Reg */
#define	CC1_IRC_MR		(CC1_BASE_ADDR + 0x10)	/* IRC Mask Reg */
#define	CC1_IRC_ICR		(CC1_BASE_ADDR + 0x14)	/* IRC IRL latch/Clear Reg */

#define	SDTR_BASE		(CC1_BASE_ADDR + 0x20)
#define	CC1_SDTR_DR0	(CC1_BASE_ADDR + 0x20)	/* SDTR Data Reg 0 */
#define	CC1_SDTR_CSR0	(CC1_BASE_ADDR + 0x24)	/* SDTR Control Status Reg 0 */
#define	CC1_SDTR_DR1	(CC1_BASE_ADDR + 0x30)	/* SDTR Data Reg 0 */
#define	CC1_SDTR_CSR1	(CC1_BASE_ADDR + 0x34)	/* SDTR Control Status Reg 0 */

#define TIMER_BASE		(CC1_BASE_ADDR + 0x40)
#define	CC1_Timer_PR0	(CC1_BASE_ADDR + 0x40)	/* TIMER Prescale Reg 0 */
#define	CC1_Timer_TCR0	(CC1_BASE_ADDR + 0x44)	/* TIMER Timer Control Reg 0 */
#define	CC1_Timer_RVR0	(CC1_BASE_ADDR + 0x48)	/* TIMER Reload Value Reg 0 */
#define	CC1_Timer_CVR0	(CC1_BASE_ADDR + 0x4c)	/* TIMER Count Value Reg 0 */
#define	CC1_Timer_PR1	(CC1_BASE_ADDR + 0x50)
#define	CC1_Timer_TCR1	(CC1_BASE_ADDR + 0x54)
#define	CC1_Timer_RVR1	(CC1_BASE_ADDR + 0x58)
#define	CC1_Timer_CVR1	(CC1_BASE_ADDR + 0x5c)
#define	CC1_Timer_TCR2	(CC1_BASE_ADDR + 0x64)
#define	CC1_Timer_RVR2	(CC1_BASE_ADDR + 0x68)
#define	CC1_Timer_CVR2	(CC1_BASE_ADDR + 0x6c)
#define	CC1_Timer_TCR3	(CC1_BASE_ADDR + 0x74)
#define	CC1_Timer_RVR3	(CC1_BASE_ADDR + 0x78)
#define	CC1_Timer_CVR3	(CC1_BASE_ADDR + 0x7c)

#define	CC1_PIO_PDR		(CC1_BASE_ADDR + 0x80)
#define	CC1_PIO_DCR		(CC1_BASE_ADDR + 0x84)

/* Specifics of cascade IRC */
#define CAS0_IRC_BASE	0xffffd000
#define LINK_IRC_BASE	0xffffb800

#define	CAS0_IRC_TMR0	(CAS0_IRC_BASE + 0x00)
#define	CAS0_IRC_TMR1	(CAS0_IRC_BASE + 0x04)
#define	CAS0_IRC_RSR	(CAS0_IRC_BASE + 0x08)
#define	CAS0_IRC_RCR	(CAS0_IRC_BASE + 0x0c)
#define	CAS0_IRC_MR		(CAS0_IRC_BASE + 0x10)
#define	CAS0_IRC_ICR	(CAS0_IRC_BASE + 0x14)

#define	LINK_IRC_TMR0	(LINK_IRC_BASE + 0x00)
#define	LINK_IRC_TMR1	(LINK_IRC_BASE + 0x04)
#define	LINK_IRC_RSR	(LINK_IRC_BASE + 0x08)
#define	LINK_IRC_RCR	(LINK_IRC_BASE + 0x0c)
#define	LINK_IRC_MR		(LINK_IRC_BASE + 0x10)
#define	LINK_IRC_ICR	(LINK_IRC_BASE + 0x14)

/*
 *	for IRC
 */
#define	IRL_CLEAR			0x00000010
#define REQ_ALL_CLEAR		0xfffffffe

#define	INTR_DISABLE		0xffffffff
#define	INTR_MASKALL		0xfffffffe

#define SYSINT_MASKALL		0xffffffbe		/* Cascade0 enable */

#define	INTR_NMI			15
#define	INTR_TIMER3			14
#define	INTR_CPUTIMER		INTR_TIMER3
#define	INTR_CASCADE1		13
#define	INTR_LINK			INTR_CASCADE1
/*
#define	INTR_		12
*/
#define	INTR_DPM			11
#define	INTR_DMAC			10
#define	INTR_PCI			 9
#define	INTR_USB			 8
#define	INTR_TIMER2			 7
#define	INTR_SYSTIMER		INTR_TIMER2
#define	INTR_CASCADE0		 6
#define	INTR_ADC			 5
#define	INTR_SSIO			 4
#define	INTR_SIO			 3
#define	INTR_SERIAL			 INTR_SIO
#define	INTR_PIO			 2
#define	INTR_USER0			 1
#define	INTR_MAXNUM			INTR_NMI
#define	INTR_GETPENDING		(INTR_NMI+1)

#define	CAS0INT_TIMER1		15
#define	CAS0INT_USER3		14
#define	CAS0INT_RTC			13
#define	CAS0INT_SIO1		12
#define	CAS0INT_SIO0		11
#define	CAS0INT_PULSE8		10
#define	CAS0INT_PULSE7		 9
#define	CAS0INT_PULSE6		 8
#define	CAS0INT_PULSE5		 7
#define	CAS0INT_PULSE4		 6
#define	CAS0INT_PULSE3		 5
#define	CAS0INT_PULSE2		 4
#define	CAS0INT_PULSE1		 3
#define	CAS0INT_PULSE0		 2
#define	CAS0INT_TIMER0		 1


/*
#define	LINKINT_		15
#define	LINKINT_		14
#define	LINKINT_		13
#define	LINKINT_		12
#define	LINKINT_		11
*/
#define	LINKINT_IRQ_FATAL	10
#define	LINKINT_IRQ_TABLE	 9
#define	LINKINT_IRQ_WAIT	 8
#define	LINKINT_IRQ_CONT	 7
#define	LINKINT_EV_IN_PAC	 6
#define	LINKINT_DA_IN_PAC	 5
#define	LINKINT_EV_IN_EOP	 4
#define	LINKINT_DA_IN_EOP	 3
#define	LINKINT_EV_OUT_EOP	 2
#define	LINKINT_DA_OUT_EOP	 1


#ifndef ASSEMBLER
typedef enum {
	nothing		= 0,
	user0		= 1 << INTR_USER0,
	pio			= 1 << INTR_PIO,
	serial		= 1 << INTR_SERIAL,
	ssio    	= 1 << INTR_SSIO,
	adc			= 1 << INTR_ADC,
	cascade0	= 1 << INTR_CASCADE0,
	timer		= 1 << INTR_SYSTIMER,
	usb			= 1 << INTR_USB,
	pci			= 1 << INTR_PCI,
	dmac		= 1 << INTR_DMAC,
	dpm			= 1 << INTR_DPM,
	cascade1	= 1 << INTR_LINK,
	cputimer	= 1 << INTR_CPUTIMER,
	nmi			= 1 << INTR_NMI,
	maskall		= 0xfffffffe
} sysintr_t;

typedef enum {
	timer0		= 1 << CAS0INT_TIMER0,
	pulse0		= 1 << CAS0INT_PULSE0,
	pulse1		= 1 << CAS0INT_PULSE1,
	pulse2		= 1 << CAS0INT_PULSE2,
	pulse3		= 1 << CAS0INT_PULSE3,
	pulse4		= 1 << CAS0INT_PULSE4,
	pulse5		= 1 << CAS0INT_PULSE5,
	pulse6		= 1 << CAS0INT_PULSE6,
	pulse7		= 1 << CAS0INT_PULSE7,
	pulse8		= 1 << CAS0INT_PULSE8,
	serial0		= 1 << CAS0INT_SIO0,
	serial1		= 1 << CAS0INT_SIO1,
	timer1		= 1 << CAS0INT_TIMER1,
	user3		= 1 << CAS0INT_USER3,
} cas0intr_t;
#endif /* !ASSEMBLER */

/*
 *	for SDTR
 */

#define  SIO_MB89251A_COMPATIBLE
/*
 * Set internal mode register by writing to CSR
 * Internal mode register format for asynchronous mode:
 *  Bits 7, 6: Stop bit length
 *          5: Parity
 *          4: Availability of parity bit
 *       3, 2: Data bit length
 *       1, 0: Data baud rate (must be > 0)
 */

/*
 * Stop bit length=1, No parity, 8 bit data,
 *  Baud rate=Clock input x 1/16
 */
#define	SDTR_MODE_INIT	0x4e	/* stop bit 1, data bit 8, clock/16 */

/*
 * Set internal command register by writing to CSR after mode is set
 * Internal command register format:
 *  Bit 7: Not used in asynchronous mode
 *      6: Internal(Program) reset
 *      5: -RTS pin
 *      4: Reset internal status register error flags
 *      3: Break code transmit through TRNDT pin
 *      2: Receive enable
 *      1: -DTR pin
 *      0: Transmit enable
 */

/*
 *  No reset, RTS=0,
 *  Internal status register flags are reset,
 *  Break off-TRNDT normally L, Receive enabled,
 *  DTR=1, Transmit enabled.
 */
#define SDTR_COM_INIT		0x34
#define SDTR_TX_ENABLE		0x35
#define SDTR_TX_DISABLE		0x34
#define SDTR_RESET			SDTR_TX_ENABLE

#define SDTR_PROGRAM_RESET	0x40

/*
 * SDTR status register format
 * Bit	7: DSR ??
 *		6: Break
 *		5: Framing Error
 *		4: Over Run Error
 *		3: Parity Error
 *		2: Transmit Register and Transmit Shift Register Empty
 *		1: Rx Charcter Available
 *		0: Transmit Register Empty
 */
#define TEMPTY	0x00000004
#define RRDY	0x00000002
#define TRDY	0x00000001

#define SIO_PORT_NUM	2
#define SIOC(x)         ( SDTR_BASE + 0x10*(x) + 0x04 )
#define SIOD(x)         ( SDTR_BASE + 0x10*(x))

/*
 *	for Timer
 */

/*
 * Prescale Register
 *
 *	Bit	15:		External Clock ({1 = external, 0 = internal} clock use)
 *		14:		TEST ( =0 )
 *		13-11:	RESERVED ( =000 )
 *		10- 8:	SELECT (step of prescaler)
 *		 7- 0:	PRESCALE VALUE( >=1 ) 
 */

/* 
 * TCR(Timer Control Register)
 * Bit	15:		OUT (Value of OUT Signal)
 *		14:		IN	(Value of IN Signal)
 *		13:		RESERVED ( =0 ) 
 *		12:		TEST ( =0 )
 *		11:		Count Enable (1 = enable)
 *		10- 9:	Clock Select 		0 = internal,	1 = external,
 *									2 = prescaler,	3 = prohibition
 *
 *		 8- 7:	Out Sinal Control	0 = hold,		1 = set
 *									2 = reset,		3 = prohibition
 *		 6:		INVERT
 *		 5- 3:	Mode Select			0 = Periodic interrupt
 *									1 = Timeout interrupt
 *									2 = Square wave generator
 *									3 = Watch-Dog timer for cpu
 *									4 = Watch-Dog timer for external
 *								  5-7 = Reserved
 *
 *		 2- 0:	Event Select		0 = Gate "L",	1 = Gate "H"
 *									2 = Event Trigger "RISE-EDGE"
 *									3 = Event Trigger "FALL-EDGE"
 *									4 = Event Trigger "BOTH-EDGE"
 */

#define	PERIODIC_INT	0x00000980
#define	TIMEOUT_INT		0x00000988
#define TIMER_STOP		0x00000780

/*	
#define	TIMER_CLOCK		50000000
*/

/* eval board */
#define	TIMER_CLOCK		20000000

#define TIMER_PR(x)		( TIMER_BASE + 0x10*(x) )
#define TIMER_TCR(x)	( TIMER_BASE + 0x10*(x) + 0x04)
#define TIMER_RVR(x)	( TIMER_BASE + 0x10*(x) + 0x08)
#define TIMER_CVR(x)	( TIMER_BASE + 0x10*(x) + 0x0c)

#define	SYSTIMER	2

#if 0
#define read_asi(ASI, LOC, VAL) \
	__asm__ volatile ("lda [%r1]%2,%0" : "=r" (VAL) : "rJ" (LOC), "I" (ASI))

#define write_asi(ASI, LOC, VAL) \
	__asm__ volatile ("sta %0,[%r1]%2" :: "r" (VAL), "rJ" (LOC), "I" (ASI));
#endif

#define CC1_put(ADDR,DATA) \
  write_asi (CC1_ASI, ADDR, DATA << CC1_SHIFT)

#define CC1_get(ADDR) \
  ({unsigned long c; \
    read_asi (CC1_ASI, ADDR, c); \
    c >> CC1_SHIFT; \
   })

/*
 * The MB86940 needs a 20 cycles to be updated once written 
 *  This loop is code for 40 cycles to account for clock doubling
 *  internal to some processors.
 */
#define	 uart_delay() \
	asm("nop; nop; nop; nop; nop; nop; nop; nop; nop; nop;"); \
	asm("nop; nop; nop; nop; nop; nop; nop; nop; nop; nop;");

#endif _MP_ULSI_MB86941_H_
