#
#   id: @(#)slite.mak 1.7 96/07/24
#
#   Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
#   All rights reserved.
#
#   This software (including any documentation) is untested, has not been
#   fully tested for viruses and has been provided to you without charge.
#   ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
#   IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
#   FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
#   risk of nonperformance, loss of data and other problems and Fujitsu
#   Microelectronics, Inc. and Fujitsu Limited will not be liable under any
#   contract, negligence, strict liability or other theory for any damages
#   including, without limitation, direct, consequential or incidental nor
#   be required to provide substitute goods, services or technology.
#
#



# This is common make file for building the SPARClite evaluation
# board application programs.  It may be included by the make file
# for a given application program.  The follwing should be defined
# before this file is included : SLITELIB, CHIP, BOARD, PROGRAM, OBJS, DEBUG
# LOADADR, OPTIMIZATION and PROGFLAGS.

CHIPLIB         = $(SLITELIB)/chips/$(CHIP)
BOARDLIB        = $(SLITELIB)/boards/$(BOARD)





# Definition of host (Unix v. DOS) specifics
include $(SLITELIB)/host.mak





# This the startup module. When linked in first, the entry point
# is simply the first address of the executable.
#CRT0            = $(BOARDLIB)/crt0$(DEBUG).o
#CRT0            = crt0$(DEBUG).o
CRT0            = $(BOARDLIB)/crt0$(DEBUG).o




# SPARClite system and debug code which is to be linked with
# application programs.
SLITEOBJ        = $(BOARDLIB)/libslite.a
#DEBUG_SPRT      = $(BOARDLIB)/asi.o
DEBUG_SPRT      =





# Chip specific stuff
include $(CHIPLIB)/chip.mak






# Compiler etc. switches. 
INCLUDES        = -I . -I $(CHIPLIB) -I $(BOARDLIB) -I $(SLITELIB) -I $(C_INCLUDES) $(PROG_INCLUDES)

CFLAGS         = $(OPTIMIZATION) $(INCLUDES) -$(FPUFLAG)
#CFLAGS         = $(OPTIMIZATION) -$(FPUFLAG)
CFLAGS         += $(PROGFLAGS)

CPPFLAGS        = $(INCLUDES)
ASFLAGS         =

#C_LIB           = $(C_LIB_BASE)/$(FPUFLAG)
C_LIB           = $(C_LIB_BASE)

#CYGNUS_LIB      = $(CYGNUS_LIB_BASE)/$(FPUFLAG)
CYGNUS_LIB      = $(CYGNUS_LIB_BASE)

LDFLAGS         = -Ttext $(LOADADR) -T$(SLITELIB)/sparclit.ld -L$(BOARDLIB) -L$(CYGNUS_LIB) -L$(C_LIB)







# These are default make rules for making any C or assembly modules
# which do not have explicit rules. We include the application makefile 
# in the dependecy list since it defines some compiler flags.
%.o: %.s makefile
	$(CPP) $(CPPFLAGS) $*.s $*.i
	$(AS) $(ASFLAGS) -o $*.o $*.i

#%.o: %.c makefile
#	$(CC) $(CFLAGS) $*.c
.c.o: %.c Makefile
	$(CC) $(CFLAGS) -c $*.c


#%.o: %.s makefile
#	$(CPP) $(CPPFLAGS) $*.s $*.i
#	$(AS) $(ASFLAGS) -o $*.o $*.i
#
#%.o: %.c makefile
#	$(CC) $(CFLAGS) $*.c


all: $(PROGRAM).sr


# Executable program
#	other options for printing lots of info can be given:
#		-Map,-t,-cref
$(PROGRAM): $(CRT0) $(OBJS) $(DEBUG_SPRT) $(SLITEOBJ) 
	$(LD) $(LDFLAGS) -o $@  $(CRT0) $(OBJS) $(DEBUG_SPRT) -lc -lslite -lgcc -Map $(PROGRAM).map -cref
#	$(LD) $(LDFLAGS) -o $@  $(CRT0) $(OBJS) $(DEBUG_SPRT) -lm -lc -lslite -lgcc -Map $(PROGRAM).map




# Convert executable to S-records for download by Fujitsu downloaders (eg. uipc)
$(PROGRAM).sr: $(PROGRAM)
	$(OBJCOPY) -O srec $(PROGRAM) $(PROGRAM).sr
	/usr/local/resproc/bin/sparclite-resproc-coff-objdump -s $(PROGRAM) > $(PROGRAM).sec
	/usr/local/resproc/bin/sparclite-resproc-coff-objdump -d $(PROGRAM) > $(PROGRAM).dis





# This can be used to install program versions built for specific SPARClite
# chip into specific chip directories.
install:
	$(COPY) $(PROGRAM) $(SLITEBIN)/$(BOARD)
	$(COPY) $(PROGRAM).sr $(SLITEBIN)/$(BOARD)



# Delete all objects etc. to rebuild from scratch.
clean: 
	${DEL} *.i
	${DEL} *.o
	${DEL} $(PROGRAM)
	${DEL} *.sr
	${DEL} *.map
	${DEL} *.dis
	${DEL} *.sec
