/* 
 *      id: @(#)syscalls.c 1.1 95/09/28
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/


/* 
  These are routines which present a set of Unix-like system calls
  mainly for use by the C library.

  open, close, lseek, isatty and fstat are file access routines.
  The versions here are set up assuming that the only "files" used
  are the standard in and out devices which are the serial ports
  onthe SPARCLite evaluation board.

  sbrk is really used by the malloc() C library call.

  The others are never usd.
*/

#include <sys/stat.h>

int
fstat(int fd, struct stat* buf)
{
  buf->st_mode = S_IFCHR;       /* Always pretend to be a tty */
  buf->st_blksize = 0;
  return (0);
}

int
isatty(int _fd)
{
  return 1;                    /* Always pretend to be a tty */
}

int
close(int _fd)
{
  /* return value usually ignored anyhow */
  return 0;
}

int 
open(char *filename)
{
  /* always fail */
  return -1;
}

int
lseek(int _fd, off_t offset, int whence)
{
  /* nothing is ever seekable */
  return -1;
}

int 
getpid() {
  return 1;
}

int 
kill(int pid) {
  /* if we knew how to nuke the board, we would... */
  return 0;
}

void
_exit(int status) {

}


extern char end;
char*
sbrk(int incr)
{
  static char* base;
  char *b;
  if(!base) base = &end;
  b = base;
  base += incr;
  return b;
}
