/* 
 *      id: @(#)traps.c 1.1 95/09/28
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/


/* Utility routines for manipulating the SPARC trap table */

asm("
	.text
	.align 8

! Read the TBR.

	.globl _rdtbr
_rdtbr:
	retl
	mov	%tbr, %o0

");

extern unsigned long rdtbr();

/* Each entry in the trap vector occupies four words. */

struct trap_entry
{
  unsigned sethi_filler:10;
  unsigned sethi_imm22:22;
  unsigned jmpl_filler:19;
  unsigned jmpl_simm13:13;
  unsigned long filler[2];
};

extern struct trap_entry fltr_proto;
asm ("
	.data
	.globl _fltr_proto
	.align 4
_fltr_proto:			! First level trap routine prototype
	sethi 0, %l0
	jmpl 0+%l0, %g0
	nop
	nop

	.text
	.align 4
");


/* exceptionHandler assumes that the TBR points to writable memory */
void
exceptionHandler(tt, routine)
     int tt;
     unsigned long routine;
{
  struct trap_entry *tb;	/* Trap vector base address */

  tb = (struct trap_entry *)(rdtbr() & ~0xfff);

  tb[tt] = fltr_proto;

  tb[tt].sethi_imm22 = routine >> 10;
  tb[tt].jmpl_simm13 = routine & 0x3ff;
}

