#include <stdio.h>
#include <string.h>

extern void ASI4put(/* unsigned long data, unsigned long address */);
extern unsigned long ASI4get(/* unsigned long address */);
extern void ASI1put(/* unsigned long data, unsigned long address */);
extern unsigned long ASI1get(/* unsigned long address */);
extern void cache_on(/* void */);
extern void cache_off(/* void */);

#define RTBL_ADDR_BASE		0xfffe2000
#define RTBL_LINK_BASE		0xfffe3000
#define EVENT_DPM_IN_BASE	0x0c000000
#define EVENT_DPM_OUT_BASE	0x0c100000
#define DATA_DPM_IN_BASE	0x0c200000
#define DATA_DPM_OUT_BASE	0x0c300000
#define RL_REG_BASE			0xfffe0000
#define RL_SDRAM_MODE		0xfffe0000
#define RL_S_REG			0xfffe0004
#define RL_INIT_REG			0xfffe0008
#define RL_TBL_BREQ_REG		0xfffe0028
#define RL_TBL_BGRNT_REG	0xfffe002c
#define RL_SD_BREQ_REG		0xfffe0020
#define RL_SD_BGRNT_REG		0xfffe0024
#define	RL_SD_INIT_REG		0xffffe000
#define	SD_INIT_REG			0xfffff000
#define RL_SD_BASE			0x04000000
#define SD_BASE				0x08000000
#define EVENT_IN_CNTL_REG		(EVENT_DPM_IN_BASE + 0x80)
#define EVENT_IN_PACKET_NUM		(EVENT_DPM_IN_BASE + 0x88)
#define EVENT_IN_PACKET_VALID	(EVENT_DPM_IN_BASE + 0x8c)
#define EVENT_OUT_CNTL_REG		(EVENT_DPM_OUT_BASE + 0x80)
#define EVENT_OUT_COUNT_REG		(EVENT_DPM_OUT_BASE + 0x84)
#define DATA_IN_CNTL_REG		(DATA_DPM_IN_BASE + 0x800)
#define DATA_IN_PACKET_NUM		(DATA_DPM_IN_BASE + 0x808)
#define DATA_IN_PACKET_VALID	(DATA_DPM_IN_BASE + 0x80c)
#define DATA_OUT_CNTL_REG		(DATA_DPM_OUT_BASE + 0x800)
#define DATA_OUT_COUNT_REG		(DATA_DPM_OUT_BASE + 0x804)

#define EVENT_HV_IN_BASE	0xf0001000
#define EVENT_HV_OUT_BASE	0xf0002000
#define HV_OUT_ENABLE		0x00030200

#define	DMA_BASE	0xffff2000
#define	DMA_PSA(x)	(DMA_BASE + 0x40*(x) + 0x04)
#define	DMA_MDA(x)	(DMA_BASE + 0x40*(x) + 0x08)
#define	DMA_IDR(x)	(DMA_BASE + 0x40*(x) + 0x0c)
#define	DMA_TMR(x)	(DMA_BASE + 0x40*(x) + 0x10)
#define	DMA_SR(x)	(DMA_BASE + 0x40*(x) + 0x14)
#define	DMA_LR(x)	(DMA_BASE + 0x40*(x) + 0x18)
#define	DMA_SASI(x)	(DMA_BASE + 0x40*(x) + 0x1c)
#define	DMA_DASI(x)	(DMA_BASE + 0x40*(x) + 0x20)
/*
DMAC0: Event In-DPM
DMAC1: Data In-DPM
DMAC2: Event Out-DPM
DMAC3: Data Out-DPM
*/

/*
 *  for IRC
 */
#define	LINK_IRC_BASE	0xfffe1000
#define LINK_IRC_TMR0   (LINK_IRC_BASE + 0x00)
#define LINK_IRC_TMR1   (LINK_IRC_BASE + 0x04)
#define LINK_IRC_RSR    (LINK_IRC_BASE + 0x08)
#define LINK_IRC_RCR    (LINK_IRC_BASE + 0x0c)
#define LINK_IRC_MR     (LINK_IRC_BASE + 0x10)
#define LINK_IRC_ICR    (LINK_IRC_BASE + 0x14)
#define LINK_IRC_MOD    (LINK_IRC_BASE + 0x18)

#define IRL_CLEAR           0x00000010
#define REQ_ALL_CLEAR       0xfffffffe
#define INTR_DISABLE        0xffffffff
#define INTR_MASKALL        0xfffffffe

typedef unsigned long ulong;

typedef unsigned long event_packet_t[4];

event_packet_t event_packet[8] = { 
	{0x00010001, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x00010001, 0xfedcba98, 0x76543210, 0x410000e0},
	{0x00010001, 0x12345678, 0x9abcdef0, 0x410000e0},
	{0x00010001, 0xedcba987, 0x6543210f, 0x410000e0},
	{0x00010001, 0x23456789, 0xabcdef01, 0x410000e0},
	{0x00010001, 0xdcba9876, 0x543210fe, 0x410000e0},
	{0x00010001, 0x3456789a, 0xbcdef012, 0x410000e0},
	{0x00010001, 0xcba98765, 0x43210fed, 0x410000e0},
};

void wait( n )
int n;
{
	while ( n-- )
		;
}

link2()
{
	int i, j;
	ulong a, flag, d, *sp, *dp, *sd0p;

	/* Cache on */
	/* cache_on(); */

	ASI1put( 0x1, HV_OUT_ENABLE, 0x1 );

	/* SDRAM0 Mode Setting, SDRAM0 used */
	ASI4put( 0x2, RL_SDRAM_MODE );

	/* SDRAM0 Initialization */
	/* ASI4put(0x03020000, RL_SD_INIT_REG); */
	ASI4put( 0x02000000, RL_SD_INIT_REG );

	/* SDRAM1 Initialization */
	/* ASI4put(0x03020000, SD_INIT_REG); */
	ASI4put( 0x02000000, SD_INIT_REG );

	/* DPLL Mode Setting */
	ASI4put( 0x00000000, RL_S_REG );

	/* Link Initialization */
	ASI4put( 0x001e001e, RL_INIT_REG );
	ASI4put( 0x00000000, RL_INIT_REG );

	/* Table Bus Request */
	ASI4put(0x00000000, RL_TBL_BREQ_REG);

	/* Polling Table Bus Arbitor */
	do {
		flag = ASI4get( RL_TBL_BGRNT_REG );
		flag >>= 31;
	} while ( flag != 0x0 );

	/* Make Routing Table */
	sp = (ulong *) ( SD_BASE + 0x10000 );
	for ( i = 0; i < 4; i++ ) {
		*( sp + i ) = 0;
	}
	/* Null Clear */
	ASI4put( 0x00000000, DMA_TMR(0) );
	ASI4put( (ulong) sp, DMA_PSA(0) );
	ASI4put( RTBL_LINK_BASE, DMA_MDA(0) );
	ASI4put( 0x00000400, DMA_LR(0) );
	ASI4put( 0x00000008, DMA_SASI(0) );
	ASI4put( 0x00000004, DMA_DASI(0) );
	ASI4put( 0x00000081, DMA_TMR(0) );
	/* Null Clear */
	ASI4put( 0x00000000, DMA_TMR(1) );
	ASI4put( (ulong) sp, DMA_PSA(1) );
	ASI4put( RTBL_ADDR_BASE, DMA_MDA(1) );
	ASI4put( 0x00000400, DMA_LR(1) );
	ASI4put( 0x00000008, DMA_SASI(1) );
	ASI4put( 0x00000004, DMA_DASI(1) );
	ASI4put( 0x00000081, DMA_TMR(1) );

	/* Set Routing Table */
	ASI4put( 0x00010001, RTBL_ADDR_BASE + 0x000 );
	ASI4put( 0x000003e2, RTBL_LINK_BASE + 0x000 );

	ASI4put( 0x80018001, RTBL_ADDR_BASE + 0x084 );
	ASI4put( 0x00000301, RTBL_LINK_BASE + 0x084 );

	ASI4put( 0x80008000, RTBL_ADDR_BASE + 0x108 );
	ASI4put( 0x00000318, RTBL_LINK_BASE + 0x108 );

	ASI4put( 0x20212223, RTBL_ADDR_BASE + 0x18c );
	ASI4put( 0x00000318, RTBL_LINK_BASE + 0x18c );

	ASI4put( 0x80000000, RTBL_ADDR_BASE + 0x210 );
	ASI4put( 0x00000318, RTBL_LINK_BASE + 0x210 );

	ASI4put( 0x00008000, RTBL_ADDR_BASE + 0x294 );
	ASI4put( 0x00000318, RTBL_LINK_BASE + 0x294 );

	ASI4put( 0x12345678, RTBL_ADDR_BASE + 0x318 );
	ASI4put( 0x00000318, RTBL_LINK_BASE + 0x318 );

	ASI4put( 0x01234567, RTBL_ADDR_BASE + 0x39c );
	ASI4put( 0x00000318, RTBL_LINK_BASE + 0x39c );

	/* Table Bus Release */
	ASI4put( 0x00000001, RL_TBL_BREQ_REG );

#if 0
	/* SDRAM1 Test in case of cache on and 
		initializing SDRAM1 to make packets */
	dp = (ulong *) SD_BASE + 0x20000;
	for ( i = 0; i < 4 * 8; i++ ) {
		*( dp + i ) = i;
	}
	for ( i = 0; i < 8; i++, dp += 4 ) {
		*dp = 0x00010001;
	}

	/* Set Event In-DPM Control Register */
	*(ulong *) EVENT_IN_CNTL_REG = 0x40000010; /* mode0, dreq on, 8 packets, payload 0-3,4-7  */
	ASI4put( 0x00000000, DMA_TMR(0) );			/* TMR reset */
	ASI4put( EVENT_DPM_IN_BASE, DMA_PSA(0) );
	ASI4put( SD_BASE + 0x4000, DMA_MDA(0) );
	ASI4put( 0x00000040, DMA_LR(0) );			/* 64 bytes, 4 packets */
	ASI4put( 0x00000008, DMA_SASI(0) );
	ASI4put( 0x00000008, DMA_DASI(0) );
	ASI4put( 0x00002a00, DMA_TMR(0) );	/* sau, rl, mtm on, no start */

	/* Set Event Out-DPM Control Register */
	*(ulong *) EVENT_OUT_CNTL_REG = 0x40000003;	/* dreq on, 1 packet */
	*(ulong *) EVENT_OUT_COUNT_REG = 6;			/* 7 times loop */

	/* Set Data In-DPM Control Register */
	*(ulong *) DATA_IN_CNTL_REG = 0x40100020;	/* mode 0, dreq on, 2 packet, payload 0,1 */
	ASI4put( 0x00000000, DMA_TMR(1) );
	ASI4put( DATA_DPM_IN_BASE, DMA_PSA(1) );
	ASI4put( SD_BASE + 0x5000, DMA_MDA(1) );
	ASI4put( 0x00000040, DMA_LR(1) );		/* 64 bytes, 1 packet */
	ASI4put( 0x00000008, DMA_SASI(1) );
	ASI4put( 0x00000008, DMA_DASI(1) );
	ASI4put( 0x00002a00, DMA_TMR(1) );	/* sau, rl, mtm on, no start */

	/* Set Data Out-DPM Control Register */
	*(ulong *) DATA_OUT_CNTL_REG = 0x4000000f;	/* dreq on, 1 packet */
	*(ulong *) DATA_OUT_COUNT_REG = 1;			/* 2 times loop */
#endif

	/* Harvard Bus */
	ASI1put( event_packet[1][0], EVENT_HV_OUT_BASE );
	ASI1put( event_packet[1][1], EVENT_HV_OUT_BASE + 0x4 );
	ASI1put( event_packet[1][2], EVENT_HV_OUT_BASE + 0x8 );
	ASI1put( event_packet[1][3], EVENT_HV_OUT_BASE + 0xc );

	printf("sending packets:\n");
	printf("%08x ", ASI1get( EVENT_HV_OUT_BASE ) );
	printf("%08x ", ASI1get( EVENT_HV_OUT_BASE + 0x4 ) );
	printf("%08x ", ASI1get( EVENT_HV_OUT_BASE + 0x8 ) );
	printf("%08x\n", ASI1get( EVENT_HV_OUT_BASE + 0xc ) );

	do {
		flag = ASI4get(LINK_IRC_RSR);
	} while (flag == 0x0);
	ASI4put( 0xffffffff, 0xfffe000c );
	ASI4put( REQ_ALL_CLEAR,  LINK_IRC_RCR );

#if 0
	/* Data link output by DMAC */
	ASI4put( 0x00000000, DMA_TMR(3) );			/* TMR reset */
	ASI4put( SD_BASE + 0x20000, DMA_PSA(3) );
	ASI4put( DATA_DPM_OUT_BASE, DMA_MDA(3) );
	ASI4put( 0x00000040, DMA_LR(3) );		/* 64 bytes, 1 packet */
	ASI4put( 0x00000008, DMA_SASI(3) );
	ASI4put( 0x00000008, DMA_DASI(3) );
	ASI4put( 0x00002a01, DMA_TMR(3) );	/* sau, rl, mtm on, start */

	/* Event link output by DMAC */
	ASI4put( 0x00000000, DMA_TMR(2) );			/* TMR reset */
	ASI4put( SD_BASE + 0x20000, DMA_PSA(2) );
	ASI4put( EVENT_DPM_OUT_BASE, DMA_MDA(2) );
	ASI4put( 0x00000010, DMA_LR(2) );		/* 16 bytes, 1 packet */
	ASI4put( 0x00000008, DMA_SASI(2) );
	ASI4put( 0x00000008, DMA_DASI(2) );
	ASI4put( 0x00002a01, DMA_TMR(2) );	/* sau, rl, mtm on, start */
#endif

	/* Event link input by HV Bus */
	ASI1get( EVENT_HV_IN_BASE );
	ASI1get( EVENT_HV_IN_BASE + 0x4 );
	ASI1get( EVENT_HV_IN_BASE + 0x8 );
	ASI1get( EVENT_HV_IN_BASE + 0xc );

	printf("received packets:\n");
	printf("%08x ", ASI1get( EVENT_HV_IN_BASE ) );
	printf("%08x ", ASI1get( EVENT_HV_IN_BASE + 0x4 ) );
	printf("%08x ", ASI1get( EVENT_HV_IN_BASE + 0x8 ) );
	printf("%08x\n", ASI1get( EVENT_HV_IN_BASE + 0xc ) );

	wait(10000);
#if 1
	ASI1put( event_packet[3][0], EVENT_HV_OUT_BASE );
	ASI1put( event_packet[3][1], EVENT_HV_OUT_BASE + 0x4 );
	ASI1put( event_packet[3][2], EVENT_HV_OUT_BASE + 0x8 );
	ASI1put( event_packet[3][3], EVENT_HV_OUT_BASE + 0xc );

	printf("sending packets 2 :\n");
	printf("%08x ", ASI1get( EVENT_HV_OUT_BASE ) );
	printf("%08x ", ASI1get( EVENT_HV_OUT_BASE + 0x4 ) );
	printf("%08x ", ASI1get( EVENT_HV_OUT_BASE + 0x8 ) );
	printf("%08x\n", ASI1get( EVENT_HV_OUT_BASE + 0xc ) );

	do {
		flag = ASI4get(LINK_IRC_RSR);
	} while (flag == 0x0);
	ASI4put( 0xffffffff, 0xfffe000c );
	ASI4put( REQ_ALL_CLEAR,  LINK_IRC_RCR );

	/* Event link input by HV Bus */
	ASI1get( EVENT_HV_IN_BASE );
	ASI1get( EVENT_HV_IN_BASE + 0x4 );
	ASI1get( EVENT_HV_IN_BASE + 0x8 );
	ASI1get( EVENT_HV_IN_BASE + 0xc );

	printf("received packets 2 :\n");
	printf("%08x ", ASI1get( EVENT_HV_IN_BASE ) );
	printf("%08x ", ASI1get( EVENT_HV_IN_BASE + 0x4 ) );
	printf("%08x ", ASI1get( EVENT_HV_IN_BASE + 0x8 ) );
	printf("%08x\n", ASI1get( EVENT_HV_OUT_BASE + 0xc ) );
#endif

#if 0
	printf("DMA input --\n");
	printf("%08x\n", *(ulong *)( SD_BASE + 0x4000) );
	printf("%08x\n", *(ulong *)( SD_BASE + 0x5000) );
#endif
}
