/*
 * FILE
 *      net.h
 *
 *	Copyright(c) 1993, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
 * DESCRIPTION
 *      This is a header file for UDP/IP implementation on SPARClite
 *	evaluation board.
 *
 * HISTORY
 *      April 1993      Clark Li
 */

#define ETHFRAMELEN 	6
#define WINDOWSIZE 	4096
#define TSENDSIZE 	512
#define DEFWINDOW 	1024
#define DEFSEG		1024
#define TMAXSIZE 	1024
#define UMAXLEN 	1024
#define ICMPMAX 	300 

/*****************************
 *	Ethernet level
 */
#define  EXNS  	0x0600          
#define  EIP   	0x0800
#define  EARP  	0x0806
#define  ERARP	0x8035
#define  ECHAOS	0x0804

struct ether {
	uchar	dst[ETHFRAMELEN],	/* destination addr */
		src[ETHFRAMELEN];	/* source addr */
	ushort	type;			/* Ethernet packet type  */
};

typedef struct ether DLAYER;


/****************************
 *	ARP and RARP
 */
#define RARPR	0x0004          /*  RARP reply, from host, needs swap */
#define RARPQ	0x0003		/*  RARP request, needs swapping */
#define ARPREP  0x0002          /*  reply, byte swapped when used */
#define ARPREQ  0x0001          /*  request, byte-swapped when used */
#define ARPPRO	0x0800		/*  IP protocol */

#define HTYPE 	0x0001		/*  Ethernet hardware type, needs swapping */

struct arppkt {
	DLAYER	d; 		/* data link layer packet header */

	ushort	hrd,		/* hardware type, Ethernet = 1 */
		pro;		/* protocol type to resolve for */

	uchar	hln,		/* byte length of hardware addr = 6 for ETNET */
		pln;		/* byte length of protocol = 4 for IP */

	ushort	op;		/* opcode, request = 1, reply = 2, RARP = 3,4 */

	uchar	sha[6],		/* source hardware address */
		spa[4],		/* source ip address */
		tha[6],		/* target hardware address */
		tpa[4];		/* target ip address */

	uchar	pad[18];
};

typedef struct arppkt ARPPKT;


/**************************
 *	IP
 */
struct iph {

	uchar	versionandhdrlen;	/* I prefer to OR them myself */
					/* each half is four bits */
	uchar	service;		/* type of service for IP */

	ushort	tlen,			/* total length of IP packet */
		ident,			/* these are all BYTE-SWAPPED! */
		frags;			/* combination of flags and value */

	uchar	ttl,    		/* time to live */
		protocol;		/* higher level protocol type */

	ushort	check;			/* header checksum, byte-swapped */

	uchar 	ipsrc[4],		/* IP addresses */
		ipdst[4];

};

typedef struct iph IPLAYER;

struct ip {
	DLAYER d;
	IPLAYER i;

	union {
		uchar	data[536];/* largest recommended, may include options */
		uchar	options[40];
	} x;
};

typedef struct ip IPPKT;

#define PROTUDP		17
#define PROTTCP		6		/* standard protocol types for IP */
#define PROTICMP	1


/********************
 *	ICMP
 */
struct icmph {
	uchar	type,		/* ICMP type field */
		code;		/* ICMP code field */
	ushort	check,          /* checksum */
		part1,part2;	/* depends on type and code */
};

typedef struct icmph ICMPLAYER;

struct icmp {
	DLAYER		d;
	IPLAYER		i;
	ICMPLAYER	c;
	uchar		data[ICMPMAX];
};

typedef struct icmp ICMPPKT;


/********************
 *  UDP
 *
 *  UDP uses the identical checksum to TCP
 */

struct udph {
	ushort	source,dest;	/* port numbers, all byte-swapped */
	ushort	length,		/* length of packet, including hdr */
		check;		/* TCP checksum of whole packet */
};

typedef struct udph UDPLAYER;

struct udp {
	DLAYER 		d;
	IPLAYER 	i;
	UDPLAYER 	u;
	uchar 		data[UMAXLEN];   /* largest UDP data we will use */
};

typedef struct udp UDPPKT;

#ifdef notdef
struct uport {
	UDPKT udpout;
	struct	pseudotcp tcps;	/* pseudo-tcp for checksumming */
	ushort	listen,		/* what port should this one listen to? */
		length;		/* how much data arrived in last packet? */
	uchar	data[UMAXLEN],	/* incoming, last datagram of that type */
		who[4],		/* who sent it to me ? */
		stale;		/* have we read this packet yet? */
};
#endif

