/*      Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.          */
/*      All rights reserved.                                                  */

/*      This software (including any documentation) is untested, has not been */
/*      fully tested for viruses and has been provided to you without charge. */
/*      ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR    */
/*      IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,  */
/*      FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all    */
/*      risk of nonperformance, loss of data and other problems and Fujitsu   */
/*      Microelectronics, Inc. and Fujitsu Limited will not be liable under   */
/*      any contract, negligence, strict liability or other theory for any    */
/*      damages including, without limitation, direct, consequential or       */
/*      incidental nor be required to provide substitute goods, services      */
/*      or technology.                                                        */

/* DESCRIPTION*/
/*      This file contains the diagnostic startup code for the EVIL EPROM.*/
/*      Functions:*/
/*      1. Configure SPARClite eval board;*/
/*      2. Test SRAM, DRAM, EPROM checksum, NICE chip, AT interface, timer*/
/*         interrupt;*/
/*      3. If all tests pass and Ethernet is connected, jump to Ethernet */
/*         monitor;  otherwise, jump to serial line monitor.*/

/* HISTORY*/
/*      July 1991       Roland Chu*/
/*      April 1993      Clark Li*/
/*      March 1995      CCF*/
/*      September 1996  kob     */
/* */

#define IRQ_ON 0
#include "utilsl.h"

        .text
        .global _reset

/* Reset Initialization*/
_reset:                                 /* Initialize everything on reset*/
#ifdef BOARD_832D | BOARD_832DD
#include "deb.s"
#endif

/* SPARClite initialization*/
        wr      %g0, PSR_RESET, %psr    /* Initialize %psr by chip version*/
	nop
	nop
	nop
        wr      %g0, 0x0, %wim          /* Initialize %wim to window 0*/
	nop
	nop
	nop
        wr      %g0, 0x0, %tbr          /* Initialize %tbr to 0*/
	nop
	nop
	nop

        /* This should be redone after DRAM initialization so the stack can*/
        /*  be put at the top of the DRAM address range.*/
        sethi   %hi(0x08e00000), %fp /* Initialize frame pointer*/
        add     %fp, DEFAULT_STACK_FRAME, %sp   /* Allocate stack frame.*/

#if 0
        /* We are presumably in the window we have just designated as*/
        /* invalid, so a save should put things right*/
        save    %sp, DEFAULT_STACK_FRAME, %sp
#endif

#ifdef  SINGLE_VECTOR_TRAP
        .align  4                       /* Set Ancillary Register 17 bit 1*/
        .word   0xa3802001              /*  to enable single vector trapping*/
#endif

/* 991002 */
/* SDRAM0 Mode Setting, SDRAM0 used */
	set	0x2,		%l1
	set	0xfffe0000,	%l0
	sta	%l1,	[%l0]	4
/* SDRAM0 Initialization */
	set	0x02000000,	%l1
	set	0xffffe000,	%l0
	sta	%l1,	[%l0]	4	
/* SDRAM1 Initialization */
	set	0x02000000,	%l1
	set	0xfffff000,	%l0
	sta	%l1,	[%l0]	4
/* DPLL Mode Setting */
	set	0x0,		%l1
	set	0xfffe0004,	%l0
	sta	%l1,	[%l0]	4
/* Link Initialization */
	set	0x001e001e,	%l1
	set	0xfffe0008,	%l0
	sta	%l1,	[%l0]	4
	set	0x00000000,	%l1
	set	0xfffe0008,	%l0
	sta	%l1,	[%l0]	4
/**********/

#ifdef BOARD_832D
# if 0
#  if 0
        sethi   %hi(0xfcfe<<15), %l0  /* ASI0=x, 00000000-01FFFFFF */
        xnor    %g0, %l0, %l0   /*SI and SD ASI, addr=0x0XXXXXXX*/
        or      %g0, 0x140, %l1 /* Set address mask register for -CS0           */
        sta     %l0, [%l1] 1
        nop
#  else	/* -CS1 for ROM (using internal address decoder)*/
	sethi	%hi(0x9<<23), %l0  /* ASI = 9, addr from 0x00000000 */
	or	%g0, 0x124, %l1	   /* addr to 0x00ffffff */
	sta	$l0, [%l1] 1	   /* ASI = 8,9,a,b */
	sethi	%hi(0xfcff<<15),&l0
	xnor	%g0, %l0,%l0
	or	%g0, 0x140,%l1
	sta	%l0, [%l1] 1
	/* -CS2 for SDRAM (using internal address decoder) */
	sethi	%hi(0x908<<15), %l0  /* ASI = 9, addr from 0x08000000 */
	or	%g0, 0x124, %l1	   /* addr to 0x08ffffff */
	sta	$l0, [%l1] 1	   /* ASI = 8,9,a,b */
	sethi	%hi(0xfcff<<15),&l0
	xnor	%g0, %l0,%l0
	or	%g0, 0x140,%l1
	sta	%l0, [%l1] 1
#  endif
# endif
#endif /* BOARD_832D */
        /* set cache/bus-io control register*/
        sta     %g0, [%g0] 1            /* Write Cache/BIU Control Reg*/
                                        /* Write buffer, prefetch buffer,*/
                                        /* data cache and instruction cache*/
                                        /* are all disabled.  Neither cache is*/
                                        /* locked.*/

        /* Initialize the Timer Pre-Load Register which is used for Bus Timeout*/
        /* and DRAM refresh.*/
        /* The timer needs to pulse about every 15 us based on the Mhz*/
        /* of the clock so have the timer go off every REFRESH_PRELOAD cycles.*/
#ifdef BOARD_832D
        sethi   %hi((FIX_CLK<<8)|FIX_SW1), %g4
        or      %g4, %lo((FIX_CLK<<8)|FIX_SW1), %g4
#endif /* BOARD_832D */

#if 0
        call    _liteled
        or      %g0, 0xfe, %o0

        set     10000,%l1       /* This blips the LEDs on startup */
loopx1:
        subcc   %l1, 0x1, %l1
        bnz     loopx1
        nop

        call    _liteled
        or      %g0, 0x1, %o0

        set     10000,%l1
loopx2:
        subcc   %l1, 0x1, %l1
        bnz     loopx2
        nop

        call    _liteled
        or      %g0, 0xfe, %o0
#endif

        /* Initialize global registers*/
        /* %g7 = diagnostic test log*/
        /*      bit 0 = 1       sram  test failed*/
        /*      bit 1 = 1       dram  test failed*/
        /*      bit 2 = 1       cksum test failed*/
        /*      bit 3 = 1       nice  test failed*/
        /*      bit 4 = 1       at test failed*/
        /*      bit 5 = 1       timer test failed*/
        /* %g6 = SRAM start addr (0x30000000)*/
        /* %g5 = DRAM end addr */
        clr     %g7
        set     PROG_MEM_START, %g6
        set     SRAM_HI_START, %g5


#if YBOARD==0
/* SRAM Diagnostics*/
/* Note:*/
/*  1. SRAM is located at 0x3XXXXXXX, ie. -CS3.*/
/*  2. Only 32K or 128K word of address are valid depending on configuration.*/
        sethi   %hi(SRAM_END), %o0      /* First invalid address over 128K.*/
        sethi   %hi(SRAM_HI_START), %o1 /* Upper 96K SRAM start address.*/
        sethi   %hi(SRAM_START), %o2    /* SRAM start address.*/
        call    _ramtest
        nop
        or      %o0, %g0, %l5           /* save return value to %l5*/

        subcc   %o0, 0x3, %g0           /* does sparclite have hi sram?*/
        be,a    _cont_sram
        sethi   %hi(SRAM_END), %g5      /* set top to end of SRAM*/

        sethi   %hi(0xfcfffe<<7), %l0 /* if not, reset address mask register*/
                                /* to facilitate bus errors on bad addresses*/
        or      %l0, %lo(0xfcfffe<<7), %l0
        xnor    %g0, %l0, %l0   /* Set address mask register for -CS3*/
#ifdef BOARD_831
        or      %g0, 0x154, %l1 /*  addr<27:0>=0xXXXXXXX*/
#else
        or      %g0, 0x14c, %l1 /*  addr<27:0>=0xXXXXXXX*/
#endif
        sta     %l0, [%l1] 1    /*  SI, SD, UI and UD ASI, addr=0x3001XXXX*/
        nop
        nop
        nop
        nop

_cont_sram:
        set     0x1, %l7
        subcc   %l5, 0x2, %g0   /* if sram test failed, set %g7 bit 0 = 1*/
        bne     LA1
        nop
        or      %g7, 0x1, %g7
#ifdef SDRAM
        mov     %g0, %l7        /* put in led save register*/
#endif
        set     DRAM_HI_START, %g5      /* no sram available, set top to DRAM*/
LA1:
#ifndef SDRAM
        mov     %o0, %l7
#else
        mov     %l7, %o0
#endif
        call    _liteled        /* %o0 will have led pattern*/
        orn     %g0, %o0, %o0   /* invert the bits*/

        /* if SRAM is OK, copy program from EPROM to SRAM*/
        subcc   %l5, 0x2,%g0
        be      done_sram
        nop
        clr     %l0
        set     _edata, %l1
        sub     %l1, %g6, %l1           /* minus PROG_MEM_START*/
#ifdef BOARD_832D
        set     PROG_MEM_START, %l2
#else
# ifdef BOARD_832DD
        set     PROG_MEM_START, %l2
# else
        set     SRAM_START, %l2
# endif
#endif
LA2:
        ld      [%l0], %l3
        st      %l3, [%l2]
        add     %l0, 4, %l0
        add     %l2, 4, %l2
        subcc   %l1, %l0, %g0
        bne     LA2
        nop

done_sram:
#ifdef BOARD_832D
        restore %g0, %g0, %g0   /* get back to original window*/
        or      %g0, %g5, %fp   /* Top of stack is at end of DRAM or SRAM*/
        add     %fp, DEFAULT_STACK_FRAME, %sp   /* Allocate stack frame.*/
        save    %sp, DEFAULT_STACK_FRAME, %sp   /* save again*/
#endif
#ifdef _DEB_
        call        puthex
        mov         0x01, %o0
#endif

#endif	/* YBOARD==0 */


#ifdef SDRAM
/* SDRAM Diagnostics*/
/* Initialize SDRAM registers*/
/*  Do not initialize SDRAM if switch register position 6 (bit 5) is on*/
        set     0x1000003, %l2  /* switch register*/
        ldub    [%l2], %l3      
        andcc   %l3, 0x40, %l3
        be      done_sdram
        nop

        set     0x600, %l2      /* Set SDRAM mode register*/
        set     0x3a, %l3       /* cas latency of 3,*/
                                /*  interleaved burst,*/
                                /*  burst length of 4*/
        sta     %l3, [%l2] 1

        set     0x608, %l2      /* Set SDRAM refresh register for 16 us*/
        set     0x1e0, %l3      /* 25 MHz*/
        sta     %l3, [%l2] 1

        set     0x604, %l2      /* Set configuration register*/
        set     0x9, %l3        /* x8 sdram, 64-bit bus, enable sdiu*/
        sta     %l3, [%l2] 1

        set     (0x1e0*8), %l3  /* loop counter for at least 8 auto refreshes*/
LB1:    
        subcc   %l3, 0x1, %l3   /* decrement and loop if not zero*/
        bne     LB1
        nop

/* Note:*/
/*  SDRAM is located at 0x5XXXXXXX, ie. -CS5.*/
        sethi   %hi(SDRAM_END), %o0
        sethi   %hi(SDRAM_HI_START), %o1
        sethi   %hi(SDRAM_START), %o2   /* SDRAM start address.*/
        call    _ramtest
        nop
        or      %o0, %g0, %l5           /* save return value to %l5*/

        subcc   %o0, 0x3, %g0           /* does sparclite have hi sdram?*/
        be,a    _cont_sdram
        sethi   %hi(SDRAM_END), %g5     /* set top to end of SDRAM*/
        
_cont_sdram:
        subcc   %l5, 0x2, %g0   /* sdram test failed?*/
        be      done_sdram
        nop
        set     DRAM_HI_START, %g5      /* no sdram available, set top to DRAM*/
        or      %l7, 0x2, %l7
        call    _liteled        /* %o0 will have led pattern*/
        orn     %g0, %l7, %o0   /* invert the bits*/

done_sdram:
#endif

/* DRAM Diagnostics*/
/* Note:*/
/*  1. DRAM is located at 0x4XXXXXXX, ie. -CS4.*/
/*  2. Only 4MB or 16MB of address are valid depending on configuration.*/

/* Special note for 933:*/
/*  For chip 933, reset procedure takes about 34 seconds. To speed up reset,*/
/*  test DRAM from SRAM.  If SRAM test passed, the above code has moved program*/
/*  from EPROM to SRAM.*/

#ifdef DRAM_CONFIG_REGS
        set     0x033, %l1              /* 4mb bank*/
        set     0x7d0, %l0              /* DRAM Bank Configuration (bank 0)*/
        sta     %l1, [%l0] 1

        set     0x433, %l1              /* 4mb bank*/
        set     0x7d4, %l0              /* DRAM Bank Configuration (bank 1)*/
        sta     %l1, [%l0] 1

        set     0x833, %l1              /* 4mb bank*/
        set     0x7d8, %l0              /* DRAM Bank Configuration (bank 2)*/
        sta     %l1, [%l0] 1

        set     0xc33, %l1              /* 4mb bank*/
        set     0x7dc, %l0              /* DRAM Bank Configuration (bank 3)*/
        sta     %l1, [%l0] 1

                                        /* Set DRAM timing for 30 MHz*/
        set     0x4, %l1                /* RAS precharge = 1 (Henry)*/
#ifdef CLK_DOUBLED
        set     0x475c, %l1             /* 30 MHZ (Doubled) or slower*/
#endif
        set     0x7e0, %l0              /* DRAM Timing Register 1*/
        sta     %l1, [%l0] 1

        set     0x4100, %l1             /* CBR = 1, RAS pulse width = 1 (Henry)*/
#ifdef CLK_DOUBLED
        set     0xc700, %l1             /* 30 MHZ (Doubled) or slower*/
#endif
        set     0x7e4, %l0              /* DRAM Timing Register 2*/
        sta     %l1, [%l0] 1

        set     0x80, %l0               /* system control register*/
        lda     [%l0] 1, %l1            /* read it*/
        or      %l1, 0x40, %l1          /* enable DRAM controller (bit 6)*/
        sta     %l1, [%l0] 1
#endif

#ifdef BOARD_831
#ifdef NO_DRAM
        ba,a    test_cksum
#endif
        andcc   %g4, 0x10, %g0          /* Look Expand SIMM switch      */
                                        /* Bank size 0:4MB,1:16MB       */
        sethi   %hi(DRAM_END_BANK_4MB), %o0
        be,a   sethyperpage
          or      %g0, DRAM_BANK_4MB, %o1
        sethi   %hi(DRAM_END_BANK_16MB), %o0
        or      %g0, DRAM_BANK_16MB, %o1
sethyperpage:

#ifdef CS3_DRAMC
#define DRAM_BNKCFG_DAT ((DRAM_STADR<<9)|(DRAM_TP<<7))
#define DRAM_TMNG_DAT   ((DRAM_TRPS<<4)|(DRAM_RASCBR<<2)|(DRAM_TCAS<<1)|(DRAM_TRP))

        sll     %g4, 8-6, %l2
        andcc   %l2, (DRAM_HE<<8), %l2  /* Hyper mode enable            */
        be      skip_edo                /* it is SIMM                   */
          or      %g0, 0x40, %l4        /* enable DRAM controller (bit 6)*/
        or      %g0, 0xc0, %l4          /* enable burst mode            */
skip_edo:
        sethi   %hi(DRAMC_BASE), %l1    /* Base address of DRAMC        */
        or      %l1, %lo(DRAMC_BASE), %l1
        sethi   %hi(DRAM_BNKCFG_DAT), %l0
        or      %l0, %lo(DRAM_BNKCFG_DAT), %l0
        or      %l0, %o1, %l0
        or      %l0, %l2, %l0
        sta     %l0, [%l1] CS3_ASI      /* Bank config register         */

        add     %l1, 4, %l1             /* DRAM timing register         */
        sethi   %hi(DRAM_TMNG_DAT), %l0 /* Setting                      */
        or      %l0, %lo(DRAM_TMNG_DAT), %l0
        sta     %l0, [%l1] CS3_ASI      /* Write it                     */

        set     0x80, %l2               /* system control register      */
        lda     [%l2] 1, %l3            /* read it                      */
        or      %l3, %l4, %l3           /* modify DRAM enable & burst   */
        sta     %l3, [%l2] 1            /* write it                     */
#endif

#else
        sethi   %hi(DRAM_END), %o0      /* End of DRAM */
#endif
LD7:
        sethi   %hi(DRAM_HI_START), %o1 /* Minimum DRAM high address*/
        sethi   %hi(DRAM_START), %o2    /* DRAM start address.*/

        andcc   %g7, 0x1, %g0           /* SRAM test failed?*/
        bne     ramtest_EPROM           /*  If yes, test DRAM from EPROM*/
        nop

        /* run DRAM test from SRAM */

        /* constructs the beginning address of _ramtest in SRAM*/
        set     _ramtest, %l1
        set     PROG_MEM_START, %l2
        sub     %l1, %l2, %l1           /* minus PROG_MEM_START*/
        set     SRAM_START, %l2
        add     %l1, %l2, %l1           /* add SRAM_START*/

        jmpl    %l1, %o7                /* Jump to SRAM to test DRAM,*/
        nop                             /*  return addr is in %o7*/
        ba,a    ramtest_done
        nop

ramtest_EPROM:
        call    _ramtest
        nop

ramtest_done:
        mov     %o0, %l5        /* save test result*/
#ifdef BOARD_831
        mov     %o1, %l6        /* save size of dram */
#endif
        subcc   %o0, 0x2, %g0   /* does sparclite have no dram?*/
        be      _cont_dram      /*  if so, leave top at end of SRAM*/
        nop
        sethi   %hi(DRAM_HI_START), %g5 /* set top to minimum DRAM*/
        subcc   %o0, 0x3, %g0   /* does sparclite have hi dram?*/
        be      _hi_dram_fixup
        nop

#ifdef BOARD_831
        srl     %l6, 20, %l6                /* make n MB        */
        sll     %l6, 20, %g5

        subcc   %l6, 16, %g0                /* If over 16MB,    */
        bgeu,a  over16mb                    /* light led '11'   */
            or  %g0, 0x3, %l5
over16mb:

        subcc   %l6, 32, %g0                /* over 32MB        */
        bgu,a   chk_dram_cap_end
            sethi   %hi(0xfcfc<<15), %l0    /* mask 64MB        */
        subcc   %l6, 16, %g0                /* over 16MB        */
        bgu,a   chk_dram_cap_end
            sethi   %hi(0xfcfe<<15), %l0    /* mask 32MB        */
        subcc   %l6, 8 , %g0                /* over 8MB         */
        bgu,a   chk_dram_cap_end
            sethi   %hi(0xfcff<<15), %l0    /* mask 16MB        */
        subcc   %l6, 4 , %g0                /* over 4MB         */
        bgu,a   chk_dram_cap_end
            sethi   %hi(0xfcff8<<11), %l0   /* mask 8MB         */
        sethi   %hi(0xfcffc<<11), %l0       /* mask 4MB         */

chk_dram_cap_end:
        sethi   %hi(DRAM_START), %l1
        add     %l1, %g5, %g5
#endif
        xnor    %g0, %l0, %l0   /* Set address mask register for -CS4*/
        or      %g0, 0x150, %l1 /*  ASI<1,0>=xx, addr<27:0>=0xXXXXXXX*/
        sta     %l0, [%l1] 1    /*  SI, SD, UI and UD ASI, addr=0x403XXXXX*/
        nop
        nop
        nop
        nop
        ba      _cont_dram
        nop

_hi_dram_fixup:
        /* re-Initialize Same Page Mask Register*/
        sethi   %hi(0x7F800000), %l0 /* SAME PG MSK Reg set up for 1M drams*/
#ifdef BOARD_831
                                            /* If SW1:5(bit4) is OFF,     */
                                            /* DRAM is 4MB and 1024/page. */
                                            /* If SW1:5(bit4) is ON,      */
        andcc   %g4, 0x10, %g0              /* DRAM is 16MB and 2048/page.*/
        sethi   %hi(DRAM_END_BANK_16MB), %g5
        bne,a   set_samepage
           or   %g0, 0x0e, %l0
        or      %g0, 0x06, %l0
        sethi   %hi(DRAM_END_BANK_4MB), %g5
set_samepage:

#endif
        or      %g0, 0x120, %l1
        sta     %l0, [%l1] 1
        /* change end of DRAM to reflect full complement of memory*/

_cont_dram:
        /* reset stack to top of hi-dram*/
        restore %g0, %g0, %g0   /* get back to original window*/
        or      %g0, %g5, %fp   /* Top of stack is at end of DRAM or SRAM*/
        add     %fp, DEFAULT_STACK_FRAME, %sp   /* Allocate stack frame.*/
        save    %sp, DEFAULT_STACK_FRAME, %sp   /* save again*/

LF1:
        sll     %l5, 2, %l5
        or      %l7, %l5, %l7   /* keep current led bits around in %l7*/
        call    _liteled        /* %o0 will have led pattern*/
        orn     %g0, %l7, %o0   /* invert the bits*/

        subcc   %l5, 0x8, %g0   /* if dram test failed, set %g7 bit 1 = 1*/
        be,a    LF2
        or      %g7, 0x2, %g7

LF2:

        /* if DRAM is OK, copy program from EPROM to DRAM*/
        subcc   %l5, 0x2,%g0
        be      test_cksum
        nop
        clr     %l0
        set     _edata, %l1
        sub     %l1, %g6, %l1           /* minus PROG_MEM_START*/
        set     PROG_MEM_START, %l2
LF3:
        ld      [%l0], %l3
        st      %l3, [%l2]
        add     %l0, 4, %l0
        add     %l2, 4, %l2
        subcc   %l1, %l0, %g0
        bne     LF3
        nop


/*------ Eprom checksum, if ok, light fifth led*/
test_cksum:
#ifdef _DEB_
        call        puthex
        mov         0x02, %o0
#endif
        set     _edata, %o0     /* tell cksum where to stop*/
        call    _prom_cksum
        sub     %o0, %g6, %o0   /* minus PROG_MEM_START*/

        subcc   %o0, %g0, %g0
        bne     test_cksum_fail /* test cksum failed */
        nop
        or      %l7, 0x10, %l7  /* keep current led bits around in %l7*/
        call    _liteled        /* %o0 will have led pattern*/
        orn     %g0, %l7, %o0   /* invert the bits*/
        ba,a    test_nice
test_cksum_fail:
        or      %g7, 0x4, %g7   /* cksum test failed, set %g7 bit 2 = 1*/


/*------ Eprom nice diags; light sixth led if ok*/
test_nice:
#ifdef _DEB_
        call        puthex
        mov         0x03, %o0
#endif
#ifdef NO_NICE
        ba      test_at
        nop
#endif
        call    _nicetest
        nop
        subcc   %o0, %g0, %g0
        bne     test_nice_fail  /* test nice failed*/
        nop
        or      %l7, 0x20, %l7  /* keep current led bits around in %l7*/
        call    _liteled        /* %o0 will have led pattern*/
        orn     %g0, %l7, %o0   /* invert the bits*/
        ba,a    test_at
test_nice_fail:
        or      %g7, 0x8, %g7   /* cksum test failed, set %g7 bit 3 = 1*/
        

/* Check AT interface*/
/* Not much to do here except verify initial value in low two bits of*/
/* the AT status reg.*/

test_at:

#ifndef AT_INTERFACE
        ba,a    test_flashram
#endif
        sethi   %hi(0x24000000), %l0    /* AT interface base addr*/
        or      %l0, 0x3, %l0           /* offset of status byte*/
        lduba   [%l0] 4, %l6            /* get the reg*/
        and     %l6, 0x3, %l6           /* mask bottom bits*/
        subcc   %l6, 0x2, %g0           /* 0x2 is what we should see*/
        bne     test_at_fail
        nop
        or      %l7, 0x40, %l7
        call    _liteled        /* %o0 will have led pattern*/
        orn     %g0, %l7, %o0   /* invert the bits*/
        ba,a    test_timer
test_at_fail:
        or      %g7, 0x10, %g7  /* at test failed, set %g7 bit 4 = 1*/


test_flashram:
#ifndef FLASH
        ba,a    test_timer
#endif
        /* constructs the beginning address of _flash_test in SRAM*/
        set     _flash_test, %l1

        set     PROG_MEM_START, %l2     /* if not, run from SRAM*/
        sub     %l1, %l2, %l1           /* minus PROG_MEM_START*/

        andcc   %g7, 0x1, %g0           /* did we fail the SRAM test?*/
        bnz     LG1                     /* if so, run from EPROM*/
        nop

        set     SRAM_START, %l2         /* change to SRAM address*/
        add     %l1, %l2, %l1           /* add SRAM_START*/

LG1:
        mov     %g7, %l4                /* save diagnostic test log*/
        mov     %g6, %l6                /* save PROG_MEM_START*/
        mov     %g5, %l5                /* save DRAM_END (or SRAM end if no DRAM)*/
        jmpl    %l1, %o7                /* Jump to SRAM to test FLASHRAM,*/
        nop                             /*  return addr is in %o7*/
        mov     %l4, %g7                /* restore diagnostic test log*/
        mov     %l6, %g6                /* restore PROG_MEM_START*/
        mov     %l5, %g5                /* restore DRAM_END*/
        cmp     %o0, 0x0
        be      test_flashram_passed
        nop


/* FLASH not installed or not working should not generate errror*/
/*      or      %g7, 0x10, %g7  ! flashram test failed, set %g7 bit 3 = 1*/

        ba,a    test_flashram_end
        nop

test_flashram_passed:
        or      %l7, 0x40, %l7
        call    _liteled        /* %o0 will have led pattern*/
        orn     %g0, %l7, %o0   /* invert the bits*/

test_flashram_end:


/* MB86940 (CC1) Initialization*/
/* Note:*/
/*  1. SPARClite DATA<31:16> are used as CC1 DATA<15:0>, ie. 16-bit data.*/
/*  2. SPARClite ADDR<6:2> are used as CC1 RS<4:0>*/
/*  3. CC1 is located at ASI 4, 0x1XXXXXXX, ie. -CS1 for MB86930*/
/* For MB86931, CC1 is:*/
/*  1. SPARClite DATA<15:0> is CC1 DATA<15:0>*/
/*  2. SPARClite ADDR<6:2> are used as CC1 RS<4:0>*/
/*  3. CC1 is located at ASI 1, 0x000002XX*/

/* Timer0 (To OB)*/
/*  Prescale Register is at 0x10*/
/*  Timer Control Register is at 0x11*/
/*  Reload Value Register is at 0x12*/
/*  Count Value Register is at 0x13*/

/* Timer1 (To Int3/8)*/
/* NOTE: Timer1 was formerly initialized here but said initialization has*/
/*      been moved down to beyond the IRC initialization section in order*/
/*      to also accomodate the power-on interrupt test.*/

/* Timer2 (To Int1/13)*/
/*  Timer Control Register is at 0x19*/
/*  Reload Value Register is at 0x1a*/
/*  Count Value Register is at 0x1b*/

/* Timer3 (To TCLK and RCLK of both SDTR)*/
/*  Timer Control Register is at 0x1d*/
/*  Reload Value Register is at 0x1e*/
/*  Count Value Register is at 0x1f*/

test_timer:
#ifdef _DEB_
        call        puthex
        mov         0x04, %o0
#endif

#ifdef _DEB_
        call        puthex
        mov         0x05, %o0
#endif

/* SDTR Initialization*/
        /* SDTR0*/
        /* Data Register 0, DR0, is at 0x8*/
        /* Command/Status Register 0, CSR0, is at 0x9*/
        /* SDTR1*/
        /* Data Register 1, DR1, is at 0xc*/
        /* Command/Status Register 1, CSR1, is at 0xd*/
        /* Note: Only the lower byte of each register is used,*/
        /*       the upper byte should be set to 0.*/
        /*       A delay of 10 clock cylces is needed after each SDTR reg access.*/

        sethi   %hi(CC1_BASE_ADDR), %l1    /* %l1=TMR0 address.*/
        or      %l1, %lo(CC1_BASE_ADDR), %l1
        /* CSR0 address*/
        add     %l1, 0x9<<2, %l2
        /* CSR1 address*/
        add     %l1, 0xd<<2, %l3

        /* Initialization sequence to put the SDTR in a known reset state*/
        sethi   %hi(0x0), %l0
        sta     %l0, [%l2] CC1_ASI 
        call    _delay10
        nop
        sta     %l0, [%l3] CC1_ASI 
        call    _delay10
        nop
        sta     %l0, [%l2] CC1_ASI
        call    _delay10
        nop
        sta     %l0, [%l3] CC1_ASI
        call    _delay10
        nop
        sta     %l0, [%l2] CC1_ASI
        call    _delay10
        nop
        sta     %l0, [%l3] CC1_ASI
        call    _delay10
        nop
        sethi   %hi(0x400000), %l0
        CC1_STA_HI (%l0, [%l2])
        call    _delay10
        nop
        sta     %l0, [%l3] CC1_ASI
        call    _delay10
        nop

        /* Set internal mode register by writing to CSR*/
        /* Internal mode register format for asynchronous mode:*/
        /*  Bits 7, 6: Stop bit length*/
        /*          5: Parity*/
        /*          4: Availability of parity bit*/
        /*       3, 2: Data bit length*/
        /*       1, 0: Data baud rate (must be > 0)*/
        sethi   %hi(0x4e0000), %l0
        CC1_STA_HI (%l0, [%l2])
                                /* Stop bit length=1, No parity, 8 bit data,*/
                                /*  Baud rate=Clock input x 1/16*/
        call    _delay10
        nop
        sta     %l0, [%l3] CC1_ASI
        call    _delay10
        nop

        /* Set internal command register by writing to CSR after mode is set*/
        /* Internal command register format:*/
        /*  Bit 7: Not used in asynchronous mode*/
        /*      6: Internal reset*/
        /*      5: -RTS pin*/
        /*      4: Reset internal status register error flags*/
        /*      3: Break code transmit through TRNDT pin*/
        /*      2: Receive enable*/
        /*      1: -DTR pin*/
        /*      0: Transmit enable*/
        sethi   %hi(0x350000), %l0
        CC1_STA_HI (%l0, [%l2])
                                /* No reset, RTS=0,*/
                                /*  Internal status register flags are reset,*/
                                /*  Break off-TRNDT normally L, Receive enabled,*/
                                /*  DTR=1, Transmit enabled.*/
        call    _delay10
        nop
        sta     %l0, [%l3] CC1_ASI
        call    _delay10
        nop

#ifdef _DEB_
        call        puthex
        mov         0x06, %o0
#endif

#ifdef _DEB_
        call        puthex
        mov         0x07, %o0
#endif

/* Timer1 (To Int3/8)*/
/*  Prescale Register is at 0x14*/
/*  Timer Control Register is at 0x15*/
/*  Reload Value Register is at 0x16*/
/*  Count Value Register is at 0x17*/

        /* before we start this timer for real, let us perform some*/
        /* diag which will (at least partially) validate two things:*/
        
        /* 1) we are sucessfully communicating with the MB86940 and*/
        /* 2) we can sucessfully take an interrupt.*/
        
        /* to accomplish this, we will clear the global counter at 0x30003ff8*/
        /* we will then program the timer for mode 1*/
        /* (time-out) and a very small reload value, so we do not have*/
        /* to poll long for results.*/
        /* */
        /* After this test we will reprogram Timer1 as a 1 second timer.*/
        
        sethi   %hi(SRAM_START+0x3ff8), %l6
        or      %l6, %lo(SRAM_START+0x3ff8), %l6
        st      %g0, [%l6]
#ifdef BOARD_831
/* Save clock and SW1 setting into 0x30003ffc, 0x30003ffd.   */
/* When data cache is ON, must read these setting in 0x30003ffc. */
        sth %g4, [%l6+4]
#endif

#ifdef _DEB_
        call        puthex
        mov         0x08, %o0
#endif

#ifdef _DEB_
        call        puthex
        mov         0x09, %o0
#endif

/*--------------------------------------------------------------------*/
/* Diagnostic test finished.  Jump to monitor.*/
/*--------------------------------------------------------------------*/
        mov     %g7, %l7                /* save diagnostic test log*/
        mov     %g6, %l6                /* save PROG_MEM_START*/
        mov     %g5, %l5                /* save DRAM size*/

/*------ turn on cache for maximum performance */
#ifndef CACHE_OFF_DISABLE
        call    _cache_on
        nop
#endif
/*------ turn on FPU (if it is there) for convenience */
        call    _FPUEN
        nop

#ifdef _DEB_
        call        puthex
        mov         0x0A, %o0
#endif
/*------ if alternate monitor location has been modified, jump to that location*/
        sethi   %hi(_alt_monitor), %l0
        or      %l0, %lo(_alt_monitor), %l0
        ld      [%l0], %l1
        set     0x6d6f6e69, %l2         /* string "moni" of "monitor entry" */
        cmp     %l1, %l2
        be      no_alt_mon
        nop
#ifdef _DEB_
        call        puthex
        mov         0x0E, %o0
        call        puthexw
        mov         %l1, %o0
        set     PROG_MEM_START, %g6
        sub         %l0, %g6, %l0
        ld          [%l0], %o0
        call        puthexw
        nop
        lduh        [%l0], %o0
        call        puthexw
        nop
        lduh        [%l0+2], %o0
        call        puthexw
        nop
        add         %l0, 2, %l0
        ld          [%l0], %o0
        call        puthexw
        nop
#endif
        jmpl    %l0, %o7                /* jump to _alt_monitor */
        nop

/*------ if no test errors, go to C entry in RAM; otherwise, go to*/
/*       SDTR monitor in EPROM.*/
no_alt_mon:
#ifdef _DEB_
        call        puthex
        mov         0x0B, %o0
#endif
#ifndef NO_NICE
        subcc   %g7, %g0, %g0
        bne     to_sdtr_monitor
        nop

/*------ Jump to C entry point in RAM*/
to_c_ram:
        sethi   %hi(DRAM_START), %o0
        sub     %g5, %o0, %o0           /* Size of RAM */
        set     __main, %l0
        jmpl    %l0, %o7
        nop
#endif

to_sdtr_monitor:
        mov     %l7, %g7                /* restore diagnostic test log*/
        mov     %l6, %g6                /* restore PROG_MEM_START*/
        sethi   %hi(CC1_BASE_ADDR), %o0 /* set CSR0 and DR0 address*/
        or      %o0, %lo(CC1_BASE_ADDR), %o0
        add     %o0, 0x8<<2, %o1
        add     %o0, 0x9<<2, %o0

        call    _SDTR_monitor
        nop

#ifdef _DEB_
        call        puthex
        mov         0x0D, %o0
#endif


_error:
#ifdef _DEB_
        call        puthex
        mov         0x0E, %o0
#endif

        call    _liteled                /* Indicate error on LED.*/
        or      %g0, %g0, %o0
        ba      _err_flash_leds
        nop


/*------------------------------------------------------------------
 *              Division of unsigned integer.
 * [parameters]
 *      %o0     dividend
 *      %o1     divider
 * [return]
 *      %o1     result
 * [calling]
 *     mov  dividend, %o0
 *     orcc %g0,divider,  %o1
 *     be,a by0
 *         mov  %o1, %o0
 *     call _DIVU1
 *         nop
 *   by0:
 *     mov  %o0, quotient 
 *-------------------------------------------------------------------*/
#define out1    %oo  /*dividend/quotient*/
#define out2    %o1  /*divisor*/
#define yreg    %y

_DIVU1:
        mov     %g0, yreg
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1  8bit*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1  */
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1  16bit*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1  24bit*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        .word 0x90ea0009        /*divscc  out1,out2, out1*/
        retl
        .word 0x90ea0009        /*divscc  out1,out2, out1  32bit*/

#undef out1
#undef out2
#undef yreg

