#include <stdio.h>

#define file_open( fp, file, mode, err_num ) \
{ \
	if ( ( fp = fopen( file, mode ) ) == (FILE *) NULL ) { \
		fprintf( stderr, "Can't open file %s\n", file ); \
		error_message(); \
		exit( err_num ); \
	} \
}

void error_message( void )
{
	fprintf( stderr, "Usage: byteswap [infile [outfile]]\n" ); 
}

int main( int argc, char *argv[] )
{
	int c0, c1;
	FILE *in_fp, *out_fp;

	if ( argc == 1 ) {
		in_fp = stdin;
		out_fp = stdout;
	} else if ( argc == 2 ) {
		file_open( in_fp, argv[1], "rb", 1 );
		out_fp = stdout;
	} else if ( argc == 3 ) {
		file_open( in_fp, argv[1], "rb", 2 );
		file_open( out_fp, argv[2], "wb", 3 );
	} else {
		error_message();
		return 4;
	}

	while ( ( c0 = fgetc( in_fp ) ) != EOF ) {
		if ( ( c1 = fgetc( in_fp ) ) == EOF ) {
			fputc( c0, out_fp );
			break;
		}
		fputc( c1, out_fp );
		fputc( c0, out_fp );
	}

	fclose( in_fp );
	fclose( out_fp );

	return 0;
}
