/* 
 *      id: @(#)sparclit.ld 1.5 96/08/02
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
*/


OUTPUT_FORMAT("coff-sparc")
OUTPUT_ARCH(sparc)
SEARCH_DIR(.)
__DYNAMIC  =  0;

/* The following section layout effectively includes two data sections.
   .data is the section where the data is loaded at download time and where
   it is referenced at runtime.  .datac is section of the same size as .data
   but where the initial values of .data are saved away once early in the 
   initalization sequence.  The saved values in .datac are copied into .data
   to reinitialize the data after the program is executed so a downloaded program
   may be run multiple times. This could have done with the linker command file 
   AT clause but unfortunatetly there was a bug involving the AT clause, COFF files,
   and GDB in the Q396 version of the GNU tools.
*/

SECTIONS
{
  .text :
  {
    CREATE_OBJECT_SYMBOLS
    *(.text)
     etext  =  .;
     _etext  =  .;
    *(.lit)
    *(.shdata)
  }
  .data SIZEOF(.text) + ADDR(.text):	
  {
    _data = . ;
    *(.data)
    _edata  =  .;
  }
  .datac SIZEOF(.data) + ADDR(.data):	
  {
    _datac = . ;
  }
  .bss SIZEOF(.data) + ADDR(.datac):	
  {
   _bss_start = ALIGN(0x8);
   *(.bss)
   *(COMMON)
   end = ALIGN(0x8);
   _end = ALIGN(0x8);
  }
  .stab  . (NOLOAD) : 
  {
    [ .stab ]
  }
  .stabstr  . (NOLOAD) :
  {
    [ .stabstr ]
  }
}
