void ASI1put( /* unsigned long data, unsigned long address */ );
void ASICput( /* unsigned long data, unsigned long address */ );
void ASIEput( /* unsigned long data, unsigned long address */ );
unsigned long ASI1get( /* unsigned long address */ );
unsigned long ASICget( /* unsigned long address */ );
unsigned long ASIEget( /* unsigned long address */ );

#define CACHE_DELAY \
	asm("nop"); \
	asm("nop"); \
	asm("nop"); \
	asm("nop")

void cache_off()
{
	ASI1put( 0, 0x20 );       /* Turn Burst Mode off */
	CACHE_DELAY;
	ASI1put( 0, 0 );
	CACHE_DELAY;
}

void cache_on()
{
/*	cache_off(); */

	ASICput( 0x3, 0x00001000 );	/* Clear bank 1, icache */
	ASICput( 0x3, 0x80001000 );	/* Clear bank 2, icache */
	ASIEput( 0x3, 0x00001000 );	/* Clear bank 1, dcache */
	ASIEput( 0x3, 0x80001000 );	/* Clear bank 2, dcache */

	ASI1put( 0x35, 0x0 );	/* Write buf, prefetch buf, D/I caches enable */
	CACHE_DELAY;

	ASI1put( 0x3, 0x20 );		/* Turn Burst Mode on */
	CACHE_DELAY;
}

/* flush_i_cache needd by GDB */

void flush_i_cache()
{
	unsigned long cache_reg;
	unsigned long addr;

	cache_reg = ASI1get( 0x0 );	/* Read cache/bus interface reg */

	if ( !( cache_reg & 0x1 ) )
	  return;					/* Just return if cache is already off */

	ASICput( 0x3, 0x00001000 );	/* Clear bank 1, icache */
	ASICput( 0x3, 0x80001000 );	/* Clear bank 2, icache */
}
