#
# FILE
#	prom.mak
#
#	Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.
#	All rights reserved.
#	
#	This software (including any documentation) is untested, has not been
#	fully tested for viruses and has been provided to you without charge.
#	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
#	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
#	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
#	risk of nonperformance, loss of data and other problems and Fujitsu
#	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
#	contract, negligence, strict liability or other theory for any damages
#	including, without limitation, direct, consequential or incidental nor
#	be required to provide substitute goods, services or technology.
#
# DESCRIPTION
#	This is the PC version of the Fujitsu monitor makefile on the 
#	SPARClite Evaluation Board.
#
# HISTORY
#	April 1993	Clark Li
#	November 1995	CCF
# 

ENTRY		= _traptbl

OBJECTS		= crt0.o \
          asi1.o \
		  asi4.o \
		  asic.o \
		  asie.o \
          cache.o \
		  link_total.o

CSOURCES	= $(SRC)/link_total.c \
          $(SRC)/cache.c

SSOURCES	= $(SRC)/crt0.s \
          $(SRC)/asi1.s \
		  $(SRC)/asi4.s \
		  $(SRC)/asic.s \
		  $(SRC)/asie.s \
		  $(SRC)/dtrsl.s

SOURCES		= $(SSOURCES) \
		  $(CSOURCES)

#HEADERS		= $(SRC)/utilsl.h
#
#NESRCS          = $(SRC)/ne.c \
#		  $(SRC)/nes.s
#
#NEOBJS          = ne.o \
#		  nes.o
#
#NEHEADERS	= $(SRC)/splite.h \
#		  $(SRC)/net.h

#$(TARGET):	$(OBJECTS) $(HEADERS) $(NEOBJS) $(NEHEADERS)
$(TARGET):	$(OBJECTS) 

#
# create initial cksumsl.h file containing a temporary value of "0"
#
	echo .word 0 > $(SRC)/cksumsl.h
#
# always compile ttblsl.s
#
#	$(CPP) $(CPPFLAGS) $(SRC)/ttblsl.s ttblsl.i
#	$(AS) $(AFLAGS) -o ttblsl.o ttblsl.i
#	$(LN) $(LFLAGS) -o $(TARGETFILE) ttblsl.o $(OBJECTS) $(NEOBJS)
#	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/ttblsl.s ttblsl.i
#	$(AS) -o ttblsl.o ttblsl.i
#	$(LN) $(LFLAGS) -o $(TARGETFILE) ttblsl.o $(OBJECTS) $(NEOBJS)
	$(LN) $(LFLAGS) -o $(TARGETFILE) $(OBJECTS)
#
# the following inserts a 16-bit value into the prom binary file
# such that the 16-bit checksum for the complete prom image will be
# zero.
#
	$(CREATECKSUM)

#
# relink with checksum
#
#	$(CPP) $(CPPFLAGS) $(SRC)/ttblsl.s ttblsl.i
#	$(AS) $(AFLAGS) -o ttblsl.o ttblsl.i
#	$(LN) $(LFLAGS) -o $(TARGETFILE) ttblsl.o $(OBJECTS) $(NEOBJS)
#	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/ttblsl.s ttblsl.i
#	$(AS) -o ttblsl.o ttblsl.i
#	$(LN) $(LFLAGS) -o $(TARGETFILE) ttblsl.o $(OBJECTS) $(NEOBJS)
	$(LN) $(LFLAGS) -o $(TARGETFILE) $(OBJECTS) 
#
# the following creates a prom binary image without any header or
# other extraneous information
#
	$(MAKEIMAGE)
#
# print final checksum to verify it is zero, then remove temporary files
#
	$(PRINTCKSUM)

	$(REMOVE) *.o
	$(REMOVE) *.i
	
# Individual object dependencies

crt0.o:	$(SRC)/crt0.s
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/crt0.s crt0.i
	$(AS) -o crt0.o crt0.i

asi1.o:	$(SRC)/asi1.s
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/asi1.s asi1.i
	$(AS) -o asi1.o asi1.i

asi4.o:	$(SRC)/asi4.s
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/asi4.s asi4.i
	$(AS) -o asi4.o asi4.i

asic.o:	$(SRC)/asic.s
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/asic.s asic.i
	$(AS) -o asic.o asic.i

asie.o:	$(SRC)/asie.s
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/asie.s asie.i
	$(AS) -o asie.o asie.i

cache.o:		$(SRC)/cache.c 
	$(CC) $(CFLAGS) $(SRC)/cache.c

link_total.o:		$(SRC)/link_total.c 
	$(CC) $(CFLAGS) $(SRC)/link_total.c

clean:
	-$(REMOVE) *.i 
	-$(REMOVE) *.o

clobber: clean
	-$(REMOVE) $(TARGETFILE) 
	-$(REMOVE) $(BINFILE)
