#
# FILE
#	solaris1.mak
#
#	Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.
#	All rights reserved.
#	
#	This software (including any documentation) is untested, has not been
#	fully tested for viruses and has been provided to you without charge.
#	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
#	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
#	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
#	risk of nonperformance, loss of data and other problems and Fujitsu
#	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
#	contract, negligence, strict liability or other theory for any damages
#	including, without limitation, direct, consequential or incidental nor
#	be required to provide substitute goods, services or technology.
#
# DESCRIPTION
#	This is the SUN Solaris 1 version of the Fujitsu monitor makefile on
#	the SPARClite Evaluation Board.
#
# HISTORY
#	April 1993	Clark Li
#	November 1995	CCF
#   September 1996   kob
#

#.SCCS_GET:
CHIP 		= 831
BOARD           = 832D
MHZ 		= 10
CC 		= sparclite-resproc-coff-gcc 
CPP		= /usr/future-keio/resproc/lib/gcc-lib/sparclite-resproc-coff/egcs-2.91.66/cpp
AS 		= sparclite-resproc-coff-as
LN		= sparclite-resproc-coff-ld
STRIP		= sparclite-resproc-coff-strip
REMOVE		= rm -f
BYTESWAP	= ./byteswap
SWAPBIN		= swap.bin

FIRMSTART930	= 40008000
FIRMSTART931	= 40008000
FIRMSTART932	= 40008000
FIRMSTART933	= 40008000
FIRMSTART933H	= 40008000
FIRMSTART934	= 40008000
FIRMSTART935	= 40008000
FIRMSTART936	= 40008000
FIRMSTART831	= 04008000
FIRMSTART831C	= 40008000
FIRMSTART	= $(FIRMSTART$(CHIP))
#DEB = -D_DEB_=1
DEB =

#CFLAGS		= -nostdlib -O -c -DMASTER_CK_$(MHZ) -DBOARD_$(BOARD) -D_DEBUG=1 $(DEB) -DYBOARD=$(YBOARD)
CFLAGS		= -O -c -DMASTER_CK_$(MHZ) -DBOARD_$(BOARD) -D_DEBUG=1 $(DEB) -DYBOARD=$(YBOARD)
AFLAGS		= -Dedata=_edata
#LFLAGS		= -Ttext $(FIRMSTART) -Bstatic -N
LFLAGS		= -TSPARCLIT.LD -Ttext $(FIRMSTART) -Bstatic -N
CPPFLAGS	= -DMASTER_CK_$(MHZ) -DBOARD_$(BOARD) -D_DEBUG=1 $(DEB) -DYBOARD=$(YBOARD)
WORD		= .word

TARGET		= sl$(MHZ)$(CHIP)

TARGETFILE	= $(TARGET).out

BINFILE		= $(TARGET).bin

SRC		= .

PRINTCKSUM	= echo "2-byte checksum is " `od -dv $(BINFILE) \
		  | awk '{ s += $$2 + $$3 + $$4 + $$5 + $$6 + $$7 + $$8 + $$9 }\
		  	END { printf ( "%x" , s % 65536 ) } '`
	
CREATECKSUM	= cp $(TARGETFILE) $(TARGET).strip ; \
		  $(STRIP) $(TARGET).strip ; \
		  echo ".word 65536 -" `dd if=$(TARGET).strip bs=32 skip=1 \
		  | od -dv \
		  | awk '{ s += $$2 + $$3 + $$4 + $$5 + $$6 + $$7 + $$8 + $$9 }\
			END  { printf ( "%d" , s % 65536 ) } '` \
	  	  > $(SRC)/cksumsl.h

MAKEIMAGE	= /usr/future-keio/resproc/bin/sparclite-resproc-coff-objcopy --output-target binary \
			$(TARGETFILE) $(BINFILE) ;\
		  	echo "PROM image created ($(BINFILE))" ; \
		  	rm $(TARGET).strip

#MAKEIMAGE	= cp $(TARGETFILE) $(TARGET).strip ; \
#		  $(STRIP) $(TARGET).strip ; \
#		  dd if=$(TARGET).strip of=$(BINFILE) bs=32 skip=1 ; \
#		  echo "PROM image created ($(BINFILE))" ; \
#		  rm $(TARGET).strip

include $(SRC)/prom.mak
#include prom.mak
