/*
 * FILE
 *  cntlsp.c
 *
 *  Copyright(c) 1994, FMI, Fujitsu Microelectronics, Inc.
 *  All rights reserved.
 *
 *  This software (including any documentation) is untested, has not been
 *  fully tested for viruses and has been provided to you without charge.
 *  ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *  IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *  risk of nonperformance, loss of data and other problems and Fujitsu
 *  Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *  contract, negligence, strict liability or other theory for any damages
 *  including, without limitation, direct, consequential or incidental nor
 *  be required to provide substitute goods, services or technology.
 *
 */

#define TMR1_RELOAD 0x3a98
#define TMR1_CNTR   0x30003ff8

#include    "cntlsp.h"

#ifndef TMR1_PRESCALE
#define TMR1_PRESCALE   0x2bc
#endif

char    **environ;



printf(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
int a1; int a2; int a3; int a4; int a5; int a6; int a7; int a8; int a9; int a10;
{
    char buf[1024];
    int i, len;
    
    sprintf(buf, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
    len = strlen(buf);
    for (i=0; i<len; i++)
        CC1_sdtrput(buf[i], 1);
}

CC1_Timer_init(timer, prescale, control, reload)
unsigned timer, prescale, control, reload; {
  switch(timer) {
    case 0 : CC1put(prescale<<16, CC1_Timer_PR0);
             CC1put(control<<16, CC1_Timer_TCR0);
             CC1put(reload<<16, CC1_Timer_RVR0);
             break;
    case 1 : CC1put(prescale<<16, CC1_Timer_PR1);
             CC1put(control<<16, CC1_Timer_TCR1);
             CC1put(reload<<16, CC1_Timer_RVR1);
             break;
    case 2 : CC1put(control<<16, CC1_Timer_TCR2);
             CC1put(reload<<16, CC1_Timer_RVR2);
             break;
    case 3 : CC1put(control<<16, CC1_Timer_TCR3);
             CC1put(reload<<16, CC1_Timer_RVR3);
             break;
  } /* switch */
}

unsigned CC1_Timer_get(timer)
unsigned timer; {
  switch(timer) {
    case 0 : return ((TMR1_RELOAD-(((CC1get(CC1_Timer_CVR0))>>16)&0xffff))*0xffff/TMR1_RELOAD);
             break;
    case 1 : return ((TMR1_RELOAD-(((CC1get(CC1_Timer_CVR1))>>16)&0xffff))*0xffff/TMR1_RELOAD);
             break;
    case 2 : return ((TMR1_RELOAD-(((CC1get(CC1_Timer_CVR2))>>16)&0xffff))*0xffff/TMR1_RELOAD);
             break;
    case 3 : return ((TMR1_RELOAD-(((CC1get(CC1_Timer_CVR3))>>16)&0xffff))*0xffff/TMR1_RELOAD);
             break;
  } /* switch */
}

unsigned CC1_time1() {
  return (((*(unsigned*)TMR1_CNTR)<<16)+CC1_Timer_get(CC1_TIMER1));
}

unsigned CC1_sdtrget(port)
unsigned    port; {

  if (port==0) {
    wait4RRDY(CC1_SDTR_CSR0);
    return(CC1get(CC1_SDTR_DR0)>>16);
  } else {
    wait4RRDY(CC1_SDTR_CSR1);
    return(CC1get(CC1_SDTR_DR1)>>16);
  }
}

CC1_sdtrput(data, port)
unsigned    data, port; {

  if (port==0) {
    wait4TRDY(CC1_SDTR_CSR0);
    CC1put(data<<16, CC1_SDTR_DR0);
  } else {
    wait4TRDY(CC1_SDTR_CSR1);
    CC1put(data<<16, CC1_SDTR_DR1);
  }
}

CC1_IRC_maskinit(mask)
unsigned mask; {
  CC1put(mask<<16, CC1_IRC_MR);
}

void init_time()
{
  unsigned int    psr;

  *(unsigned*)TMR1_CNTR=0; 
  CC1_Timer_init(CC1_TIMER1, TMR1_PRESCALE, 0x0c00, TMR1_RELOAD);
  /* Now Timer1 interrupts every second */
  CC1_Timer_init(CC1_TIMER2, 0x0000, 0x0710, 0xffff);
  CC1_IRC_maskinit(0xdef4);
  psr=psrget();
  psr&=0xfffff0ff;
  psrput(psr);
  CC1_sdtrput(0xa, CC1_SDTR1);
  CC1_sdtrput(0xd, CC1_SDTR1);
}

void CC1_sdtrputw(port, data)
unsigned port, data;
{
  CC1_sdtrput((data>>24)&0xff, port);
  CC1_sdtrput((data>>16)&0xff, port);
  CC1_sdtrput((data>>8)&0xff, port);
  CC1_sdtrput(data&0xff, port);
}
void report_time(benchtime)
unsigned benchtime;
{
int i;
  for (i=5000;i;i--);
  CC1_sdtrput(0xa, CC1_SDTR1);
  for (i=5000;i;i--);
  CC1_sdtrput(0xd, CC1_SDTR1);

  for (i=5000;i;i--);
  if (((benchtime>>28)&0xf) <= 9)
     CC1_sdtrput(((benchtime>>28)&0xf)+0x30, CC1_SDTR1);
  else
     CC1_sdtrput(((benchtime>>28)&0xf)+0x37, CC1_SDTR1);
  for (i=5000;i;i--);
  if (((benchtime>>24)&0xf) <= 9)
     CC1_sdtrput(((benchtime>>24)&0xf)+0x30, CC1_SDTR1);
  else
     CC1_sdtrput(((benchtime>>24)&0xf)+0x37, CC1_SDTR1);
  for (i=5000;i;i--);
  if (((benchtime>>20)&0xf) <= 9)
     CC1_sdtrput(((benchtime>>20)&0xf)+0x30, CC1_SDTR1);
  else
     CC1_sdtrput(((benchtime>>20)&0xf)+0x37, CC1_SDTR1);
  for (i=5000;i;i--);
  if (((benchtime>>16)&0xf) <= 9)
     CC1_sdtrput(((benchtime>>16)&0xf)+0x30, CC1_SDTR1);
  else
     CC1_sdtrput(((benchtime>>16)&0xf)+0x37, CC1_SDTR1);
  for (i=5000;i;i--);
  if (((benchtime>>12)&0xf) <= 9)
     CC1_sdtrput(((benchtime>>12)&0xf)+0x30, CC1_SDTR1);
  else
     CC1_sdtrput(((benchtime>>12)&0xf)+0x37, CC1_SDTR1);
  for (i=5000;i;i--);
  if (((benchtime>>8)&0xf) <= 9)
     CC1_sdtrput(((benchtime>>8)&0xf)+0x30, CC1_SDTR1);
  else
     CC1_sdtrput(((benchtime>>8)&0xf)+0x37, CC1_SDTR1);
  for (i=5000;i;i--);
  if (((benchtime>>4)&0xf) <= 9)
     CC1_sdtrput(((benchtime>>4)&0xf)+0x30, CC1_SDTR1);
  else
     CC1_sdtrput(((benchtime>>4)&0xf)+0x37, CC1_SDTR1);
  for (i=5000;i;i--);
  if ((benchtime&0xf) <= 9)
     CC1_sdtrput((benchtime&0xf)+0x30, CC1_SDTR1);
  else
     CC1_sdtrput((benchtime&0xf)+0x37, CC1_SDTR1);
}

void end_test()
{
  unsigned int    psr;

  psr=psrget();
  psr|=0xf00;
  psrput(psr);
}

cont()
{
    char input;

    printf("Press <return> to continue, 'q' to quit\r\n");
    input = (char)CC1_sdtrget(1); 
    if (input == 'q')
    return(0);
    else
    return(1);
}


slinput()
{
    char input;

    printf("Enter choice, 'q' to quit ");
    do {
        input = (char)CC1_sdtrget(1); 
    } while ((input != 'q') && ((input <= 0x30) && (input >= 0x3a)));
    if (input == 'q')
    return(0);
    else
    return(input - 0x30);
}

showmem (start, len)
unsigned char *start;
unsigned int len;
{
    unsigned int i, j, k, lines;
    unsigned short *sp;
    unsigned char *lp, *cp;

    (unsigned int)start &= 0xFFFFFFFC;
    lines = (len + 15)/ 16;

    lp = start;
    for (i = 0; i < lines; i++) {
    sp = (unsigned short *)lp;
    cp = lp;
    if (i && (i % 20 == 0)) {
        if (!cont())
        return;
    }
    printf("%08x:  ", lp);
    for (j = 0; j < 8; j++) {
        printf("%04x ", sp[j]);
        if (j == 3)
        printf(" ");
    }
    printf("  ");
    for (j = 0; j < 16; j++) {
        if (isprint(cp[j]))
        printf("%c", cp[j]);
        else
        printf(".", cp[j]);
        if (j == 7)
        printf(" ");
    }
    printf("\r\n");
        
    lp += 16;
    }
}


/*
 * may have to play with this 40 vs. 20MHZ
 */
delay(ticks) 
unsigned int ticks;
{
    while (ticks--);
}

