/*
 * FILE
 *  example.c
 *
 *
 *  Copyright(c) 1993, FMI, Fujitsu Microelectronics, Inc.
 *  All rights reserved.
 *
 *  This software (including any documentation) is untested, has not been
 *  fully tested for viruses and has been provided to you without charge.
 *  ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *  IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *  risk of nonperformance, loss of data and other problems and Fujitsu
 *  Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *  contract, negligence, strict liability or other theory for any damages
 *  including, without limitation, direct, consequential or incidental nor
 *  be required to provide substitute goods, services or technology.
 *
 * DESCRIPTION
 *  This example program shows how to test benchmark and 
 *  print the results on SPARClite Eval Board.
 *
 * HISTORY
 *  Sep. 1991   Roland Chu
 *  Apr. 1993   Clark Li
 */

#include <stdio.h>
#include "cntlsp.h"

char    copyright[80]="Copyright (c) 1993, Fujitsu Microelectronics, Inc.  All rights reserved.";

main()
{
    unsigned long   i, arr[0x1000], starttime, endtime;
    unsigned long  *clock = (unsigned long *)0x30003ff8 ;
    int j ;

    printf("-----------------------------------\r\n");
    printf("CLK=%d MHz\r\n", *((unsigned char *)0x30003ffc)) ;
    printf("SW1=%08X\r\n", *((unsigned char *)0x30003ffd)) ;
    printf("SSCR=%08X, BCR=%08X\r\n", getSSCR(), getDRAMBCR()) ;
    printf("stack=%08X\r\n", (((unsigned long)&i)+0xFFFFF)&~0xFFFFF) ;
    printf("Clock test(10s) ") ; fflush(stdout) ;
    i = *clock ;
    for(j=0;j<10;j++){
        while(i==*clock) ;
        i = *clock ;
        printf("o") ;
	fflush(stdout) ;
    }
    printf("\r\nStart Test,  Cache On ..."); fflush(stdout) ;
    cache_on();             /* Turn on cache */
    RESET_TIMER();              /* Clear timer counter */
    starttime = GET_TIME();         /* Get start time */
    for (i = 0; i < 0x50000; i++)       /* Benchmark loop */
        arr[i % 0x1000] = i * 3;
    endtime = GET_TIME();           /* Get end time */
    printf(" %d uS / Cache off ...", endtime - starttime);
    fflush(stdout) ;
    RESET_TIMER();              /* Clear timer counter */
    cache_off();                /* Turn off cache */
    starttime = GET_TIME();         /* Get start time */
    for (i = 0; i < 0x50000; i++)       /* Benchmark loop */
        arr[i % 0x1000] = i * 3;
    endtime = GET_TIME();           /* Get end time */
    printf("%d uS\r\n", endtime - starttime);
    printf("-----------------------------------\r\n");
}


