/* 
 *      id: @(#)led.c 1.3 96/07/19
 *
 *      Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *      All rights reserved.
 *
 *      This software (including any documentation) is untested, has not been
 *      fully tested for viruses and has been provided to you without charge.
 *      ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *      IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *      FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *      risk of nonperformance, loss of data and other problems and Fujitsu
 *      Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *      contract, negligence, strict liability or other theory for any damages
 *      including, without limitation, direct, consequential or incidental nor
 *      be required to provide substitute goods, services or technology.
 *
*/


/* SPARClite board diagnostic LEDs */
/* Bit value of 0 equals on */

#include "board.h"
#include "sparclit.h"

void
liteled(val)
     int val;
{
   unsigned char ledval = (unsigned char) (val & 0xff);
#ifdef LED_ADDR
   write_asi_b(LED_ASI, LED_ADDR, ledval);
#endif
}

void
die(val)
     int val;
{
  unsigned char ledval = (unsigned char) (val & 0xff);
#ifdef LED_ADDR
  write_asi_b(LED_ASI, LED_ADDR, ledval);
#endif
  while (1) ;
}

void
update_leds()
{
#ifdef LED_ADDR
  static unsigned char curled = 1;
  static unsigned int dir = 0;
  write_asi_b(LED_ASI, LED_ADDR, ~curled);

  if (dir) {
    if (curled >= 1<<(LED_COUNT-1)) {
      curled = 1<<(LED_COUNT-1);
      dir = ~dir;
    }
    else {
      curled <<= 1;
    }
  }
  else {
    if (curled == 1) {
      curled = 1;
      dir = ~dir;
    }
    else {
      curled >>= 1;
    }
  }
#endif
}

