#include <stdio.h>
#include <string.h>
#include <mb86941.h>  

extern void ASI4put(/* unsigned long data, unsigned long address */);
extern unsigned long ASI4get(/* unsigned long address */);
extern void ASI1put(/* unsigned long data, unsigned long address */);
extern unsigned long ASI1get(/* unsigned long address */);
extern void cache_on(/* void */);
extern void cache_off(/* void */);


typedef unsigned long ulong;



void usage( prog )
char *prog;
{
	printf("Usage: READ:           r address size\n");
	printf("       WRITE:          w address data0 data1 ...\n");
	printf("       READ(ASI 0x4):  R address size\n");
	printf("       WRITE(ASI 0x4): W address data0 data1 ...\n");
	printf("       CACHE ON:       n\n");
	printf("       CACHE OFF:      f\n");
	printf("       REDO LINK():    l\n");
	printf("       Link Hard Reset:    h\n");
	printf("       Link Soft Reset:    s\n");
	printf("       DPLL Mode Set:  d hoge\n" );	
	printf("       RTable Set:     v hoge\n");
	printf("       READ HARVARD-IN; k hoge\n");
	printf("       DEMO SENDER     t\n");
/*	printf("       QUIT:  q \n"); */
}


void edit( src )
char *src;
{
	char *p, *q;

	for( p = src, q = src; *p; p++ ) {
		if( *p == '\010' ) {
			if( q != src )
				--q;
		} else {
			*q++ = *p;
		}
	}
	*q = '\0';
}


main()
{
	int type;
	ulong addr;
	int size;
	volatile ulong *ptr;
	int i, j;
	char buf[BUFSIZ];
	char *token;

	/*link2();*/

	while( 1 ) {
		printf( "MON>" );
		if( !fgets( buf, BUFSIZ, stdin ) )
			break;
		edit( buf );
		if( !(token = strtok( buf, " \t\n" )) ) {
			usage( "mon" );
			continue;
		}
		type = *token;
		if( !(token = strtok( NULL, " \t\n" )) ) {
			usage( "mon" );
			continue;
		}
		ptr = (volatile ulong *)strtoul( token, NULL, 0 );

		if( type == 'r' ) {
			if( !(token = strtok( NULL, " \t\n" )) ) {
				usage( "mon" );
				continue;
			}
			size = strtoul( token, NULL, 0 );
			for( i = 0; i < size; i += 4 ) {
				printf( "%08x| ", (ulong) (ptr+i) );
				for( j = 0; j < 4 && (i+j) < size; j ++ ) {
					printf( "%08x ", ptr[i+j] );
				}
				printf( "\n" );
			}
		} else if( type == 'w' ) {
			i = 0;
			while( token = strtok( NULL, " \t\n" ) ) {
				ptr[i] = strtoul( token, NULL, 0 );
				i++;
			}
		} else if( type == 'R' ) {
			if( !(token = strtok( NULL, " \t\n" )) ) {
				usage( "mon" );
				continue;
			}
			size = strtoul( token, NULL, 0 );
			for( i = 0; i < size; i += 4 ) {
				printf( "%08x| ", (ulong) (ptr+i) );
				for( j = 0; j < 4 && (i+j) < size; j ++ ) {
/*					printf( "%08x ", ASI4get( (ulong) &(ptr[i+j]) ) ); */
					printf( "%08x ", ASI4get( (ulong) ptr + (i+j)*4 ) );
				}
				printf( "\n" );
			}
		} else if( type == 'W' ) {
			i = 0;
			while( token = strtok( NULL, " \t\n" ) ) {
/*				ASI4put( strtoul( token, NULL, 0 ), (ulong) &(ptr[i]) ); */
				ASI4put( strtoul( token, NULL, 0 ), (ulong) ptr + i*4 );
				i++;
			}
		} else if(type == 'n' ) {
			cache_on();
		} else if(type == 'f' ) {
			cache_off();
		} else if(type == 'l' ) {
			link2();
		} else if(type == 'v' ) {
			receive_init();
		} else if(type == 'h' ) {	
		        all_init();
		} else if ( type == 'k' ) {
			read_harvard();
		} else if(type == 's' ) {
		        part_init();
		} else if(type == 'd' ) {
			set_dpll();
		} else if(type == 't' ) {
			send_data_flow();
/*		} else if(type == 'x' ) {
#if 0
			ASI4put( 0xffffffff, CC1_PIO_DCR );
			ASI4put( 0x0, CC1_PIO_PDR );
			ASI4put( 0x1, CC1_PIO_PDR );
#else
			{
				int hoge;
				hoge = *(volatile int *)0x0;
			}
#endif
*/
		} else {
			usage( "mon" );
		}
	}
}



