/*
 * resproc.h -- definitions for pci device driver module
 *			made from resproc.h
 *
 * $Id: resproc.h,v 1.1 2003/02/04 12:42:24 kobahide Exp $
 */

/*
 * Responsive Processor ids
 */
#define PCI_VENDOR_ID_RESPROC	0x10cf
#define PCI_DEVICE_ID_RESPROC	0x200d

/* the class of the Responsive Processor Evaluatin Board is no defined */
#define PCI_CLASS_RESPROC	PCI_CLASS_NOT_DEFINED

#define PCI_RESPROC_IO_RANGE	0x40

/* for tool.c */
#define DEV_NAME_R	"resproc"

/* ioctl */
#include "resproc-ioctl.h"

/* minimum size of fifo buffer on the board */
#define RESPROC_FIFO_SZ	0x10

/*
 * protocol primitive definitions between 
 *	resproc and Responsive Prcessor (PCI) Evaluation Board
 */
#define C_P2S   0x11111111
#define C_S2P   0x22222222
#define C_ACK   0xffffffff

/*
 * offsets for local registers
 * b:byte w:word l:dword
 */
#define OS_CMD1     0x03	/* b */
#define OS_CMD2     0x02	/* b */
#define OS_STAT     0x01	/* b */
#define OS_ASIR     0x00	/* b */

#define OS_MB_A     0x04    /* l */	/* Mailbox A */

#define OS_MB_B     0x08    /* l */	/* Mailbox B */

#define OS_L_AD     0x0c    /* l */	/* Local AD */

#define OS_LBAP     0x10    /* l */	/* Local Bus Access Port */

#define OS_PBAP     0x14    /* l */	/* PCI Bus Access Port */

#define OS_CAR      0x20	/* l */
#define OS_BAR      0x20	/* l */

#define OS_CDCR     0x24	/* l */
#define OS_BDCR     0x24	/* l */

#define OS_DMR      0x2b	/* b */
#define OS_DSMR     0x2a	/* b */
#define OS_DSR      0x28	/* b */

#define OS_DMSR     0x2f	/* b */
#define OS_DAMR     0x2f	/* b */
#define OS_DMCR     0x2e	/* b */
#define OS_DCR      0x2d	/* b */

#define OS_FDCR     0x32	/* w */
#define OS_FBSR     0x30	/* w */

#define OS_WQPR     0x36	/* w */
#define OS_RQPR     0x34	/* w */

#define OS_FMR      0x3b	/* b */
#define OS_MRBER    0x39	/* b */
#define OS_FSR      0x38	/* b */

#define OS_FMSR     0x3f	/* b */
#define OS_FAMR     0x3f	/* b */
#define OS_FMCR     0x3e	/* b */
#define OS_FCR      0x3d	/* b */

/* defined bits */
#define CMD1_PIE    0x80	/* 1000 0000 */
#define CMD1_PIC    0x40	/* 0100 0000 */
#define CMD1_PIS    0x40	/* 0100 0000 */
#define CMD1_LIE    0x20	/* 0010 0000 */
#define CMD1_LIC    0x10	/* 0001 0000 */
#define CMD1_LIS    0x10	/* 0001 0000 */
#define CMD1_ID1    0x08	/* 0000 1000 */
#define CMD1_ID0    0x04	/* 0000 0100 */
#define CMD2_TAIE   0x80	/* 1000 0000 */
#define CMD2_MAIE   0x40	/* 0100 0000 */
#define CMD2_EIE    0x20	/* 0010 0000 */

/*
 * Macros to help debugging
 */

#undef PDEBUG			/* undef it, just in case */
#ifdef RESPROC_DEBUG
#  ifdef __KERNEL__
     /* This one if debugging is on, and kernel space */
//#    define PDEBUG(fmt, args...) printk( KERN_DEBUG "resproc: " fmt, ## args)
#    define PDEBUG(fmt, args...) printk( KERN_INFO "resproc: " fmt, ## args)
#  else
     /* This one for user space */
#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
#  endif
#else
#  define PDEBUG(fmt, args...)	/* not debugging: nothing */
#endif

#undef PDEBUGG
#define PDEBUGG(fmt, args...)	/* nothing: it's a placeholder */

/*
 *	get the low nibble of minor
 */
#ifndef RESPROC_MAJOR
#define RESPROC_MAJOR 0		/* dynamic major by default */
#endif

#ifndef	RESPROC_INIT_NR_DEVS
#define RESPROC_INIT_NR_DEVS 0
#endif

/* definitions for device structure */
#define MAIL_NUM 0x1000
#define NAME_LEN 8

/* maximum number of Responsive Processor supported */
#define DEV_RESPROC_MAXNUM	10

/*
 *	Responsive Processor device structure
 */
typedef struct Resproc_Dev {
	struct pci_dev *pci_dev;
	char name[NAME_LEN];	/* resproc[0-9] */
	unsigned long Wdma_data;	/* (dma) buffer(one page) for write */
	unsigned long Rdma_data;	/* (dma) buffer(one page) for read */
	unsigned long mail[MAIL_NUM];	/* for storing data through mailbox */
	unsigned short mail_head;
	unsigned short mail_tail;
	unsigned long port;	/* ioaddr */
	unsigned long port_len;	/* iolength */
	unsigned char irq;
	unsigned int access_key;	/* used by resprocuid and resprocpriv */
	unsigned int usage;	/* usage(opened) count */
	struct semaphore sem;	/* Mutual exclusion semaphore     */
	struct wait_queue *wq;	/* wait queue */
} Resproc_Dev;

/*
 * file_operations: Regardless of minors
 */

extern struct file_operations resproc_fops;

/*
 * The configurable parameters
 */

extern int resproc_major;	/* main.c */

/*
 *	global variable
 */

extern int resproc_nr_devs;

/*
 * Prototypes for shared functions
 */

ssize_t resproc_read(struct file *filp, char *buf, size_t count,
		     loff_t * f_pos);
ssize_t resproc_write(struct file *filp, const char *buf, size_t count,
		      loff_t * f_pos);

/* timer count to wait for flags to be down */
#define TIMER_COUNT (1000000)
