	/* name to be registered in /proc/ioports */
#define	DEV_NAME_U	"usb"

#define	USB_MAJOR	0	/* dynamic */
#define	USB_IO_RANGE	0x13

#define	BUFFER_SHIFT	14	/* buffer size = 2^BUFFER_SHIFT (bytes) */
				/* must be smaller than FIFO buffer size */


		/* offsets of registers */
		/* b:1byte w:word,2bytes l:dword,4bytes */
#define	OS_USBCMD	0x00	/* w */ /* usb command reg */
#define	OS_USBSTS	0x02	/* w */ /* usb status reg */
#define	OS_USBINTR	0x04	/* w */ /* usb interrupt enable reg */
#define	OS_FRNUM	0x06	/* w */	/* frame number reg */
#define	OS_FLBASEADD	0x08	/* l */	/* frame list base addr reg */
#define	OS_SOFMOD	0x0c	/* b */ /* start of frame (sof) modify reg */
#define	OS_PORTSC0	0x10	/* w */ /* port stat & cntrol reg (port 1) */
#define	OS_PORTSC1	0x12	/* w */ /* port stat & cntrol reg (port 2) */

		/* defined bits, mask */
#define	USBCMD_MAXP	0x0080	/* Max Packet */
#define	USBCMD_CF	0x0040	/* Configure Flag */
#define	USBCMD_SWDBG	0x0020	/* Software Debug */
#define	USBCMD_FGR	0x0010	/* Force Global Resume */
#define	USBCMD_EGSM	0x0008	/* Enter Global Suspend Mode */
#define	USBCMD_GRESET	0x0004	/* Global Reset */
#define	USBCMD_HCRESET	0x0002	/* Host Controller Reset */
#define	USBCMD_RS	0x0001	/* Run/Stop */

#define	USBSTS_HCH	0x0020	/* Host Controller Halted */
#define	USBSTS_HCPE	0x0010	/* Host Controller Process Error */
#define	USBSTS_HSE	0x0008	/* Host System Error */
#define	USBSTS_RD	0x0004	/* Resume Detect */
#define	USBSTS_USBEINT	0x0002	/* USB Error Interrupt */
#define	USBSTS_USBINT	0x0001	/* USB Interrupt */

#define	USBINTR_SP	0x0008	/* Short Packet Interrupt Enable */
#define	USBINTR_IOC	0x0004	/* Interrupt On Complete (IOC) Enable */
#define	USBINTR_RIS	0x0002	/* Resume Interrupt Enable */
#define	USBINTR_TOCRC	0x0001	/* Time-out/CRC Interrupt Enable */

#define	PORTSC_SUS	0x1000	/* Suspend */
#define	PORTSC_OCIC	0x0800	/* Over-current Indicator Change */
#define	PORTSC_OCI	0x0400	/* Over-current Indicator */
#define	PORTSC_PR	0x0200	/* Port Reset */
#define	PORTSC_LSDA	0x0100	/* Low Speed Device Attached */
#define	PORTSC_RD	0x0040	/* Resume Detect */
#define	PORTSC_LS	0x0030	/* Line Status */
#define	PORTSC_PEDC	0x0008	/* Port Enabled/Disabled Change */
#define	PORTSC_PED	0x0004	/* Port Enabled/Disabled */
#define	PORTSC_CSC	0x0002	/* Connect Status Change */
#define	PORTSC_CCC	0x0001	/* Current Connect Status */
