/*
 * PROM console for RMT NY0002
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1995, 1996, 1997 by Ralf Baechle
 * Copyright (C) 2001 by Liam Davies (ldavies@agile.tv)
 *
 */

#include <linux/init.h>
#include <linux/console.h>
#include <linux/kdev_t.h>
//#include <linux/serial_reg.h>

#include <asm/delay.h>
#include <asm/serial.h>
#include <asm/ioctls.h>
#include <asm/io.h>
#include <asm/smp.h>
#include <asm/rmt.h>
#include <asm/dbgout.h>

static unsigned long port = RMT_UART_BASE;
#define UART_RX		0x3
#define UART_TX		0x3
#define	UART_LSR	0x17

#define UART_LSR_TEMT	0x40	/* Transmitter empty */
#define UART_LSR_THRE	0x20	/* Transmit-hold-register empty */
#define UART_LSR_BI	0x10	/* Break interrupt indicator */
#define UART_LSR_FE	0x08	/* Frame error indicator */
#define UART_LSR_PE	0x04	/* Parity error indicator */
#define UART_LSR_OE	0x02	/* Overrun error indicator */
#define UART_LSR_DR	0x01	/* Receiver data ready */

/*static*/ __inline__ void rmtsim_cons_put_char(char ch, unsigned long ioaddr)
{
#ifdef CONFIG_RMT_AXEIO
	AXE_PUTCHAR(ch);
#elif CONFIG_RMT_UARTIO
	char lsr;
	
	do {
		lsr = readb(ioaddr + UART_LSR);
	} while ((lsr & (UART_LSR_TEMT | UART_LSR_THRE)) != (UART_LSR_TEMT | UART_LSR_THRE));
	writeb(ch, ioaddr + UART_TX);
#endif
}

static __inline__ char rmtsim_cons_get_char(unsigned long ioaddr)
{
	while ((readb(ioaddr + UART_LSR) & UART_LSR_DR) == 0)
		udelay(1);
	return readb(ioaddr + UART_RX);
}

void rmtsim_console_write(struct console *co, const char *s, unsigned count)
{
	char lsr, ier;
	unsigned i;
	int flags;
	extern spinlock_t axeputchar_lock;

	spin_lock_irqsave(&axeputchar_lock, flags);
	for (i=0; i < count; i++, s++) {

		if(*s == '\n')
			rmtsim_cons_put_char('\r', port);
		rmtsim_cons_put_char(*s, port);
	}
	spin_unlock_irqrestore(&axeputchar_lock, flags);
}

#ifndef CONFIG_AXE_AVOID
char getDebugChar(void)
{
	return rmtsim_cons_get_char(port);
}
#endif

void putDebugChar(char kgdb_char)
{
	rmtsim_cons_put_char(kgdb_char, port);
}

struct tty_driver *rmtsim_console_device(struct console *c, int *index)
{
	return console_drivers;
}

static struct console rmtsim_console = {
    .name	= "rmtcon",
    .setup	= NULL,
    .write	= rmtsim_console_write,
    .flags	= CON_PRINTBUFFER,
    //.flags	= CON_ENABLED,
    .index	= -1,
};

int __init rmtsim_setup_console(void)
{
	rmt_str_printf("rmtsim_setup_console()\n");
	register_console(&rmtsim_console);
	
	return 0;
}

int __init rmtsim_disable_console(void)
{
	rmt_str_printf("rmtsim_disable_console()\n");
	unregister_console(&rmtsim_console);
	
	return 0;
}
