/*
 * Processor capabilities determination functions.
 *
 * Copyright (C) 1994 - 2003 Ralf Baechle
 * Copyright (C) 2001 MIPS Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/ptrace.h>
#include <linux/stddef.h>

#include <asm/bugs.h>
#include <asm/cpu.h>
#include <asm/fpu.h>
#include <asm/rmtregs.h>
#include <asm/system.h>

#include <asm/dbgout.h>

void (*cpu_wait)(void) = NULL;

void __init check_bugs32(void)
{
}

__init void cpu_probe(void)
{
	struct cpuinfo_mips *c = &current_cpu_data;

	c->processor_id	= PRID_IMP_RMT2004;

#if defined CONFIG_CPU_MRMTP2
	c->cputype = CPU_MRMTP2;
#elif defined CONFIG_CPU_MRMTP1
	c->cputype = CPU_MRMTP1;
#elif defined CONFIG_CPU_URMTP2
	c->cputype = CPU_URMTP2;
#elif defined CONFIG_CPU_URMTP1
	c->cputype = CPU_URMTP1;
#else
	c->cputype = CPU_UNKNOWN;
#endif

	c->isa_level = MIPS_CPU_ISA_I;
	c->options = MIPS_CPU_COUNTER | MIPS_CPU_TLB | MIPS_CPU_FPU | MIPS_CPU_LLSC;
	c->tlbsize = 64;	/* TLB Entry */
}

__init void cpu_report(void)
{
}
