/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1994 - 2000, 2001, 2003 Ralf Baechle
 * Copyright (C) 1999, 2000 Silicon Graphics, Inc.
 * Copyright (C) 2001 MIPS Technologies, Inc.
 * Copyright (C) 2002 Maciej W. Rozycki
 */
#include <linux/config.h>
#include <linux/init.h>

#include <asm/asm.h>
#include <asm/cacheops.h>
#include <asm/regdef.h>
#include <asm/fpregdef.h>
#include <asm/rmtregs.h>
#include <asm/stackframe.h>
#include <asm/war.h>
#include <asm/rmt.h>

	__INIT

NESTED(except_vec_temporary, 0, sp)
	.set noreorder
	lui	sp, 0x8000
	addiu	sp, sp, 0x0500		# Set Temporary StackPointer
	j	print_temporary_exception
	nop
	.set reorder
END(except_vec_temporary)

	__FINIT

	.macro	__build_clear_none
	.endm

	.macro	__build_clear_sti
	STI
	.endm

	.macro	__build_clear_cli
	CLI
	.endm

	.macro	__build_clear_time
	ori	k1, zero, CP0_OWN_CAUSE
	mfc0	k0, k1
	RMTBUG_MMUREAD_SYNC
	li	k1, CAUSE_PND_TI
	or	k0, k1
	xori	k0, CAUSE_PND_TI
	ori	k1, zero, CP0_OWN_CAUSE
	mtc0	k0, k1
	STI
	.endm
	
	.macro	__build_clear_fpe
	cfc1	a1, fcr31
	li	a2, ~(0x3f << 12)
	and	a2, a1
	ctc1	a2, fcr31
	STI
	.endm

	.macro	__build_clear_ade
	MFC0	t0, MMU_SPR_EXP_ADDR, t2
	PTR_S	t0, PT_BVADDR(sp)
	KMODE
	.endm

	.macro	__BUILD_silent exception
	.endm

	/* Gas tries to parse the PRINT argument as a string containing
	   string escapes and emits bogus warnings if it believes to
	   recognize an unknown escape code.  So make the arguments
	   start with an n and gas will believe \n is ok ...  */
	.macro	__BUILD_verbose	nexception
	LONG_L	a1, PT_EPC(sp)
	PRINT("Got \nexception at %08lx\012")
	.endm

	.macro	__BUILD_rtt_clear_cause_and_eret clear_cause
#if defined(CONFIG_RMT_RTTHREAD) 
	getotid	k0
	getcnum	k0, k0
	andi	k0, k0, 0x7	/* get ActiveThreadID */
	li	k1, NR_CPUS-CONFIG_NR_RTTHREADS
	sltu	k0, k0, k1
	bne	k0, zero, 1f
	/* clear TI,S0,S1 field  of CAUSE register */
	li	k1, CP0_OWN_CAUSE
	mfc0	k0, k1
	RMTBUG_MMUREAD_SYNC
	li	k1, \clear_cause
	or	k0, k1
	xori	k0, \clear_cause
	li	k1, CP0_OWN_CAUSE
	mtc0	k0, k1
#ifndef CONFIG_RMTBUG_EXCEPTION_ON_DELAYSLOT
	li	k1, CAUSEF_BD
	and	k0, k1, k0
	beq	k0, zero, 2f
	li	k1, CP0_OWN_EPC
	mfc0	k0, k1
	RMTBUG_MMUREAD_SYNC
	addiu   k0, k0, -4
	mtc0	k0, k1
2:
#endif
	eret
1:
#endif /* CONFIG_RMT_RTTHREAD */
	.endm

	.macro	__BUILD_rtt_other
	.endm

	.macro	__BUILD_rtt_TI
	__BUILD_rtt_clear_cause_and_eret CAUSE_PND_TI
	.endm

	.macro	__BUILD_rtt_S0
	__BUILD_rtt_clear_cause_and_eret CAUSE_PND_S0
	.endm

	.macro	__BUILD_rtt_S1
	__BUILD_rtt_clear_cause_and_eret CAUSE_PND_S1
	.endm

	.macro	__BUILD_count exception
	LONG_L	t0,exception_count_\exception
	LONG_ADDIU t0, 1
	LONG_S	t0,exception_count_\exception
	.comm	exception_count\exception, 8, 8
	.endm

	.macro	__BUILD_HANDLER exception handler clear verbose ext rtt
	.align	5
	NESTED(handle_\exception, PT_SIZE, sp)
	.set	noat
	__BUILD_rtt_\rtt
	SAVE_ALL
	FEXPORT(handle_\exception\ext)
	__BUILD_clear_\clear
	.set	at
	__BUILD_\verbose \exception
	move	a0, sp
	jal	do_\handler
	j	ret_from_exception
	END(handle_\exception)
	.endm

	.macro	BUILD_HANDLER exception handler clear verbose rtt
	__BUILD_HANDLER	\exception \handler \clear \verbose _int \rtt
	BUILD_EXCEPT_VECTOR \exception
	.endm

	.macro	BUILD_EXCEPT_VECTOR exception
	NESTED(except_vec_\exception, PT_SIZE, sp)
	.set noreorder
	lui	k0, %hi(handle_\exception)
	addiu	k0, k0, %lo(handle_\exception)
	jr	k0
	nop
	.set reorder
	END(except_vec_\exception)
	.endm

	BUILD_EXCEPT_VECTOR itlb_spraddr_miss
	BUILD_EXCEPT_VECTOR itlb_allentry_locked
	BUILD_EXCEPT_VECTOR itlb_noentry_matched
	BUILD_EXCEPT_VECTOR itlb_threadmode_err
	BUILD_EXCEPT_VECTOR itlb_protection_err
	BUILD_EXCEPT_VECTOR dtlb_spraddr_miss
	BUILD_EXCEPT_VECTOR dtlb_allentry_locked
	BUILD_EXCEPT_VECTOR dtlb_noentry_matched
	BUILD_EXCEPT_VECTOR dtlb_threadmode_err
	BUILD_EXCEPT_VECTOR dtlb_protection_err
	BUILD_HANDLER coproc_unusable coproc_unusable sti silent other
	BUILD_HANDLER invalid_instruction invalid_instruction sti silent other
	BUILD_EXCEPT_VECTOR system_call
	BUILD_HANDLER break_point break_point sti verbose other
	BUILD_HANDLER int_overflow int_overflow sti verbose other
	BUILD_HANDLER divide_byzero divide_byzero sti verbose other
	BUILD_HANDLER trap trap sti silent other
	BUILD_HANDLER load_dataaddr_missalign dataaddr_missalign sti silent other
	BUILD_HANDLER store_dataaddr_missalign dataaddr_missalign sti silent other
	BUILD_HANDLER float_overflow float_overflow sti verbose other
	BUILD_HANDLER float_underflow float_underflow sti verbose other
	BUILD_HANDLER float_divide_byzero float_divide_byzero sti verbose other
	BUILD_HANDLER float_inexact float_inexact sti silent other
	BUILD_HANDLER float_invalid_operation float_invalid_operation sti silent other
	BUILD_HANDLER reserved reserved sti verbose other
	BUILD_HANDLER vectorint_exp vectorint_exp sti silent other
	BUILD_HANDLER vectorfloat_exp vectorfloat_exp sti silent other
	BUILD_HANDLER timer_interruption timer_interruption time silent TI
	BUILD_HANDLER hardware_interruption hardware_interruption sti silent other
	BUILD_HANDLER software_interruption1 software_interruption1 cli silent S1
	BUILD_HANDLER software_interruption0 software_interruption0 cli silent S0
	
