/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Kernel debug stuff to use the Watch registers.
 * Useful to find stack overflows, dangling pointers etc.
 *
 * Copyright (C) 1995, 1996, 1999 by Ralf Baechle
 */
#include <asm/asm.h>
#include <asm/rmtregs.h>
#include <asm/regdef.h>
#include <asm/rmt.h>

		.set	noreorder
/*
 * Parameter: a0 - logic address to watch
 *                 Currently only KSEG0 addresses are allowed!
 *            a1 - set bit #1 to trap on load references
 *                     bit #0 to trap on store references
 * Results  : none
 */
		LEAF(__watch_set)
		li	t0, 0x80000000
		subu	a0, t0
		ori	a0, 7
		xori	a0, 7
		or	a0, a1
		rmt_mtc0	a0, CP0_WATCHLO, t2
		sw	a0, watch_savelo

		jr	ra
		 rmt_mtc0	zero, CP0_WATCHHI, t2
		END(__watch_set)

/*
 * Parameter: none
 * Results  : none
 */
		LEAF(__watch_clear)
		jr	ra
		 rmt_mtc0	zero, CP0_WATCHLO, t2
		END(__watch_clear)

/*
 * Parameter: none
 * Results  : none
 */
		LEAF(__watch_reenable)
		lw	t0, watch_savelo
		jr	ra
		 rmt_mtc0	t0, CP0_WATCHLO, t2
		END(__watch_reenable)

/*
 * Saved value of the c0_watchlo register for watch_reenable()
 */
		.data
watch_savelo:	.word	0
		.text
