/*
 * TLB exception handling code for R2000/R3000.
 *
 * Copyright (C) 1994, 1995, 1996 by Ralf Baechle and Andreas Busse
 *
 * Multi-CPU abstraction reworking:
 * Copyright (C) 1996 David S. Miller (dm@engr.sgi.com)
 *
 * Further modifications to make this work:
 * Copyright (c) 1998 Harald Koerfgen
 * Copyright (c) 1998, 1999 Gleb Raiko & Vladimir Roganov
 * Copyright (c) 2001 Ralf Baechle
 * Copyright (c) 2001 MIPS Technologies, Inc.
 */
#include <linux/init.h>
#include <asm/asm.h>
#include <asm/cachectl.h>
#include <asm/fpregdef.h>
#include <asm/rmtregs.h>
#include <asm/page.h>
#include <asm/pgtable.h>
#include <asm/pgtable-bits.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>
#include <asm/tlb.h>
#include <asm/thread_control.h>
	
#define USE_CTLBHANDER

	.macro	MFMM rt rd
		beql	s7, zero, 1f
		 mfdmm	\rt, \rd
		mfimm	\rt, \rd
1:		RMTBUG_MMUREAD_SYNC
	.endm

	.macro	MTMM rt rd
		beql	s7, zero, 1f
		 mtdmm	\rt, \rd
		mtimm	\rt, \rd
1:		sync
	.endm
	
	.macro	axe_trace num
#if defined(CONFIG_AXE_DEBUG) && defined(CONFIG_RMT_INSTSIM) && 0
	lui	t5, 0x300
	ori	t5, t5, \num
	ori	t6, zero, 0xff
	mtc0	t5, t6
#endif
	.endm

	.macro	axe_regdump
#if defined(CONFIG_AXE_DEBUG) && defined(CONFIG_RMT_INSTSIM) && 0
	lui	t5, 0x500
	ori	t6, zero, 0xff
	mtc0	t5, t6
#endif
	.endm
	
	.macro	axe_regdumpn num
#if defined(CONFIG_AXE_DEBUG) && defined(CONFIG_RMT_INSTSIM) && 0
	lui	v0, 0x500
	ori	v0, v0, \num
	ori	v1, zero, 0xff
	mtc0	v0, v1
#endif
	.endm
	
	.macro	axe_itlbdump
#if defined(CONFIG_AXE_DEBUG) && defined(CONFIG_RMT_INSTSIM) && 0
	lui	v0, 0x800
	ori	v1, zero, 0xff
	mtc0	v0, v1
#endif
	.endm

	.macro	axe_dtlbdump
#if defined(CONFIG_AXE_DEBUG) && defined(CONFIG_RMT_INSTSIM) && 0
	lui	v0, 0x900
	ori	v1, zero, 0xff
	mtc0	v0, v1
#endif
	.endm

	.macro	axe_memdump add
#if defined(CONFIG_AXE_DEBUG) && defined(CONFIG_RMT_INSTSIM) && 0
	ori	v1, zero, 0xff
	mtc0	\add, v1
#endif
	.endm

	.macro	axe_cp0dump
#if defined(CONFIG_AXE_DEBUG) && defined(CONFIG_RMT_INSTSIM) && 0
	lui	k0, 0xa00
	ori	k1, zero, 0xff
	mtc0	k0, k1
#endif
	.endm

	.macro rmt_str num
#if defined(CONFIG_AXE_DEBUG) && !defined(CONFIG_RMT_REALMACHINE) && 0
	nop
	lui	a0, %hi(\num)
	jal	axe_str_printf
	 addiu	a0, a0, %lo(\num)
	nop
#endif
	.endm
	
	.macro rmt_val reg
#if defined(CONFIG_AXE_DEBUG) && !defined(CONFIG_RMT_REALMACHINE) && 0
	nop
	jal	axe_hex_printf
	 or	a0, zero, \reg
	nop
#endif
	.endm

ITLB_NOENT:
	.ascii "ITLB-NOENT: \000"
	.align 2
ITLB_PROT:
	.ascii "ITLB-PROT: \000"
	.align
DTLB_NOENT:
	.ascii "DTLB-NOENT: \000"
	.align 2
DTLB_PROT:
	.ascii "DTLB-PROT: \000"
	.align
AXE_PTE:
	.ascii "pte=0x\000"
	.align 2
AXE_PTR:
	.ascii "ptr=0x\000"
	.align 2
AXE_VADD:
	.ascii "vadd=0x\000"
	.align 2
AXE_PADD:
	.ascii "padd=0x\000"
	.align 2
AXE_TLB1:
	.ascii "ENT1=0x\000"
	.align 2
AXE_TLB2:
	.ascii "ENT2=0x\000"
	.align 2
AXE_MMUEXPLOG:
	.ascii "MMUEXPLOG=0x\000"
	.align 2

	.text
	.set	mips1
	.set	noreorder

	__INIT
	__FINIT

#ifdef CONFIG_64BIT_PHYS_ADDR
#define PTE_L		ld
#define PTE_S		sd
#define PTE_SRL		dsrl
#define PTE_SIZE	8
#define PTEP_INDX_MSK	0xff0
#define PTE_INDX_MSK	0xff8
#define PTE_INDX_SHIFT	9
#else
#define PTE_L		lw
#define PTE_S		sw
#define PTE_SRL		srl
#define PTE_SIZE	4
#define PTEP_INDX_MSK	0xff8
#define PTE_INDX_MSK	0xffc
#define PTE_INDX_SHIFT	10
#endif

	/* ABUSE of CPP macros 101. */

	/* After this macro runs, the pte faulted on is
	 * in register PTE, a ptr into the table in which
	 * the pte belongs is in PTR.
	 */
#if 0
# define	LOCK_SHRREG(gpr)
# define	UNLOCK_SHRREG(gpr)
#else
#define	LOCK_SHRREG(gpr)						\
	GET_CNUM(gpr);							\
	gppr	$0, SHRREG_TLB, gpr;

	//rgpex	gpr, SHRREG_TLB;

#define	UNLOCK_SHRREG(gpr)						\
	GET_CNUM(gpr);							\
	gpco	gpr, SHRREG_TLB, gpr;
	
	//wgpex	zero, SHRREG_TLB;
#endif

#define GET_CNUM(cnum)							\
	getotid	cnum;							\
	getcnum	cnum, cnum;						\
	andi	cnum, cnum, GETCNUM_AMASK;
	
#ifdef CONFIG_SMP
#define GET_PGD(scratch, ptr)						\
	lui	scratch, %hi(pgd_current); 				\
	addiu	scratch, scratch, %lo(pgd_current);			\
	GET_CNUM(ptr);							\
	sll	ptr, ptr, 2;						\
	addu	ptr, ptr, scratch;					\
	lw	ptr, 0x0(ptr);
#else /* !CONFIG_SMP */
#define GET_PGD(scratch, ptr)    					\
	lw	ptr, pgd_current;
#endif

#define LOAD_PTE(pte, ptr, vadd)					\
	GET_PGD(pte, ptr); 						\
	GET_CNUM(vadd);							\
	ori	pte, zero, MMU_SPR_EXP_ADDR;				\
	MFMM	vadd, pte;	  		/* Virtual Address */ 	\
	srl	pte, vadd, _PGDIR_SHIFT; 				\
	sll	pte, pte, 2; 						\ 
	addu	ptr, ptr, pte;			/* PGD Address */ 	\
	lw	ptr, (ptr);			/* PGD */	 	\
	srl	pte, vadd, PTE_INDX_SHIFT;				\
	andi	pte, pte, PTE_INDX_MSK;					\
	addu	ptr, ptr, pte;			/* PTE Address */ 	\
	PTE_L	pte, (ptr);			/* PTE */

#define LOAD_PADD(ptr, padd) \
	/*ori	ptr, ptr, PTE_SIZE*/; \
	/*xori	ptr, ptr, PTE_SIZE*/; \
	lw	padd, (ptr); /* PFN */ \
	nop;

#define GET_SH(shr, tmp) 						\
	GET_CNUM(shr);							\
	ori	tmp, zero, 0x1; 					\
	sllv	shr, tmp, shr;

#define SET_TLB_ENTRY(vadd, padd, tmp1, tmp2, tmp3)			\
	andi	tmp1, padd, _PAGE_GLOBAL;				\
	ori	vadd, vadd, 0xfff; 					\
	xori	vadd, vadd, 0xfff; 		/* VPN */ 		\
	ori	padd, padd, 0xfff;			 		\
	xori	padd, padd, 0xfff; 		/* PPN */ 		\
	lui	tmp2, %hi(VMALLOC_START); 				\
	addiu	tmp2, tmp2, %lo(VMALLOC_START); 			\
	sltu	tmp2, vadd, tmp2; /* vadd < VMALLOC_START */ 		\
	beq	tmp2, zero, 3f; 					\
	 nop;								\
	beq	tmp1, zero, 2f;						\
	 nop;								\
1:; /* kernel */ 							\
	beql	tmp3, zero, 5f;						\
	 ori	tmp1, zero, TLB_ENT1_PRO_KERR;				\
	ori	tmp1, zero, TLB_ENT1_PRO_KERRW;				\
5:	j	4f; 							\
	 ori	tmp2, zero, TLB_GRP_KERNEL;				\
2:; /* user */								\
	beql	tmp3, zero, 6f;						\
	 ori	tmp1, zero, TLB_ENT1_PRO_USRR; 				\
	ori	tmp1, zero, TLB_ENT1_PRO_USRRW; 			\
6:	GET_CNUM(tmp2); 						\
	j	4f; 							\
	 addiu	tmp2, tmp2, TLB_GRP_USER;				\
3:; /* vmalloc */ 							\
	ori	tmp1, zero, TLB_ENT1_PRO_KERRW; 			\
	ori	tmp2, zero, TLB_GRP_VMALLOC; 				\
4:; 									\
	sll	tmp2, tmp2, TLB_ENT2_GRP_SHIFT;				\
	or	padd, padd, tmp2; 					\
	ori	padd, padd, TLB_ENT2_UNC | TLB_ENT2_BRT_32B; 		\
	or	vadd, vadd, tmp1; 		/* PRO */ 		\
	GET_SH(tmp1, tmp2); 						\
	sll	tmp1, tmp1, TLB_ENT1_SHR_SHIFT; 			\
	or	vadd, vadd, tmp1;

#define MAKE_TLB(vadd, padd, tmp) 					\
	ori	tmp, zero, MMU_SPR_ENTRY1; 				\
	MTMM	vadd, tmp;			/* set ENT1 */		\
	ori	tmp, zero, MMU_SPR_ENTRY2; 				\
	MTMM	padd, tmp;			/* set ENT2 */ 		\
	ori	tmp, zero, MMU_SPR_ENTRY_LRU;				\
	MTMM	zero, tmp;			/* set TLB */
	
#define LOAD_EXPLOG(exp, tmp) 						\
	ori	tmp, zero, MMU_SPR_EXP_LOG;				\
	MFMM	exp, tmp;						\
	andi	tmp, exp, 0x8;

#define SET_MODE(padd, mode) 						\
	andi	mode, padd, _PAGE_GLOBAL;				\
	bnel	mode, zero, 1f;						\
	 ori	mode, zero, TLB_GRP_KERNEL;				\
	GET_CNUM(mode);							\
	addiu	mode, mode, TLB_GRP_USER;				\
1:	nop;
	

#define FLUSH_TLB(padd, mode, tmp)		 			\
	SET_MODE(padd, mode);						\
	ori	tmp, zero, MMU_SPR_GRP_FLUSH;				\
	MTMM	mode, tmp;

#define	DO_FAULT(write) 						\
	.set	noat;							\
	.set	macro;							\
	GET_CNUM(a2);							\
	ori	a0, zero, MMU_SPR_EXP_ADDR;				\
	MFMM	a2, a0;							\
	.set	at; 							\
	or	a0, zero, sp;						\
	STI;								\
	UNLOCK_SHRREG(k0);						\
	jal	do_page_fault;						\
	 ori	a1, zero, write;					\
	j	ret_from_exception;					\
	 nop;								\
	.set	noat;							\
	.set	nomacro;

	/* Check is PTE is present, if not then jump to LABEL.
	 * PTR points to the page table where this PTE is located,
	 * when the macro is done executing PTE will be restored
	 * with it's original value.
	 */
#define PTE_PRESENT(pte, ptr, label) 					\
	andi	pte, pte, (_PAGE_PRESENT | _PAGE_READ); 		\
	xori	pte, pte, (_PAGE_PRESENT | _PAGE_READ); 		\
	bne	zero, pte, label; 					\
	.set	push;       						\
	.set	reorder;    						\
	 lw	pte, (ptr); 						\
	.set	pop;

	/* Make PTE valid, store result in PTR. */
#define PTE_MAKEVALID(pte, ptr) 					\
	ori	pte, pte, (_PAGE_VALID | _PAGE_ACCESSED); 		\
	sw	pte, (ptr);

	/* Check if PTE can be written to, if not branch to LABEL.
	 * Regardless restore PTE with value from PTR when done.
	 */
#define PTE_WRITABLE(pte, ptr, label) 					\
	andi	pte, pte, (_PAGE_PRESENT | _PAGE_WRITE); 		\
	xori	pte, pte, (_PAGE_PRESENT | _PAGE_WRITE); 		\
	bne	zero, pte, label; 					\
	.set    push;       						\
	.set    reorder;    						\
	lw      pte, (ptr); 						\
	.set    pop;
	
	/* Make PTE writable, update software status bits as well,
	 * then store at PTR.
	 */
#define PTE_MAKEWRITE(pte, ptr) 					\
	ori	pte, pte, (_PAGE_ACCESSED | _PAGE_MODIFIED | 		\
			   _PAGE_VALID | _PAGE_DIRTY); 			\
	sw	pte, (ptr); 						\


/*
 * I-TLB SPR Address Miss
 */
	.set	noreorder
	.align 5
NESTED(handle_itlb_spraddr_miss, PT_SIZE, sp)
	SAVE_ALL
	or	a0, zero, sp
	jal do_itlb_spraddr_miss
  	 nop
	DO_FAULT(0)
END(handle_itlb_spraddr_miss)

/*
 * D-TLB SPR Address Miss
 */
	.set	noreorder
	.align 5
NESTED(handle_dtlb_spraddr_miss, PT_SIZE, sp)
	SAVE_ALL
	or	a0, zero, sp
	jal do_dtlb_spraddr_miss
  	 nop
	DO_FAULT(0)
END(handle_dtlb_spraddr_miss)

/*
 * I-TLB All Entry Locked
 */
	.set	noreorder
	.align 5
NESTED(handle_itlb_allentry_locked, PT_SIZE, sp)
	SAVE_ALL
	or	a0, zero, sp
	jal do_itlb_allentry_locked
  	 nop
	eret
END(handle_itlb_allentry_locked)


/*
 * D-TLB All Entry Locked
 */
	.set	noreorder
	.align 5
NESTED(handle_dtlb_allentry_locked, PT_SIZE, sp)
	SAVE_ALL
	or	a0, zero, sp
	jal do_dtlb_allentry_locked
  	 nop
	eret
END(handle_dtlb_allentry_locked)

/*
 * I-TLB No Entry Matched
 */
	.set	noreorder
	.align 5
NESTED(handle_itlb_noentry_matched, PT_SIZE, sp)
#ifdef USE_CTLBHANDER
	.set	noat
	.set	macro
	.set	mips3
	SAVE_ALL
	CLI
	jal	do_itlb_noentry
	 or	a0, zero, sp
	j	ret_from_exception
	 nop
	.set	at
	.set	nomacro
	.set	mips0
#else	/* ! USE_CTLBHANDER */
	.set	noat
	.set	macro
	.set	mips3
	LOCK_SHRREG(k0)
	SAVE_ALL
	ori	s7, zero, 1		/* in INST tlb exception */
	
	LOAD_PTE(k0, k1, s0) /* s0=vadd */
	 	rmt_str ITLB_NOENT
	 	rmt_str AXE_PTE
	 	rmt_val k0
	 	rmt_str ITLB_NOENT
	 	rmt_str AXE_PTR
	 	rmt_val k1
	 	rmt_str ITLB_NOENT
	 	rmt_str AXE_VADD
	 	rmt_val s0
	PTE_PRESENT(k0, k1, itlb_noentry)
	PTE_MAKEVALID(k0, k1)
	LOAD_PADD(k1, s1) /* s1=padd */
	 	rmt_str ITLB_NOENT
	 	rmt_str AXE_PADD
	 	rmt_val s1
	or	s2, zero, zero
	SET_TLB_ENTRY(s0, s1, k0, k1, s2)
	MAKE_TLB(s0, s1, k0)
	 	rmt_str ITLB_NOENT
	 	rmt_str AXE_TLB1
	 	rmt_val  s0
	 	rmt_str ITLB_NOENT
	 	rmt_str AXE_TLB2
	 	rmt_val  s1
	UNLOCK_SHRREG(k0)
	j	ret_from_exception
	 nop
	.set	at
	.set	nomacro
	.set	mips0

itlb_noentry:
	DO_FAULT(0)
#endif	/* ! USE_CTLBHANDER */
END(handle_itlb_noentry_matched)

/*
 * D-TLB No Entry Matched ************************************************
 */
	.set	noreorder
	.align 	5
NESTED(handle_dtlb_noentry_matched, PT_SIZE, sp)
#ifdef USE_CTLBHANDER
	.set	noat
	.set	macro
	.set	mips3
	SAVE_ALL
	CLI
	jal	do_dtlb_noentry
	 or	a0, zero, sp
	j	ret_from_exception
	 nop
	.set	at
	.set	nomacro
	.set	mips0
#else	/* ! USE_CTLBHANDER */
	.set	noat
	.set	macro
	.set	mips3
	LOCK_SHRREG(k0)
	SAVE_ALL
	ori	s7, zero, 0		/* in DATA tlb exception */
	axe_regdump

	LOAD_PTE(k0, k1, s0)		/* s0=vadd */
		rmt_str DTLB_NOENT
		rmt_str AXE_PTE
		rmt_val k0
		rmt_str DTLB_NOENT
		rmt_str AXE_PTR
		rmt_val k1
		rmt_str DTLB_NOENT
		rmt_str AXE_VADD
		rmt_val s0
	PTE_PRESENT(k0, k1, dtlb_noentry)
	PTE_MAKEVALID(k0, k1)
	LOAD_PADD(k1, s1) 		/* s1=padd */
	 	rmt_str DTLB_NOENT
	 	rmt_str AXE_PADD
	 	rmt_val s1
	or	s2, zero, zero
	SET_TLB_ENTRY(s0, s1, k0, k1, s2)
		rmt_str DTLB_NOENT
		rmt_str AXE_TLB1
		rmt_val s0
		rmt_str DTLB_NOENT
		rmt_str AXE_TLB2
		rmt_val s1
	MAKE_TLB(s0, s1, k0)
	axe_regdump
	axe_itlbdump
	axe_dtlbdump
	UNLOCK_SHRREG(k0)
	j	ret_from_exception
	 nop
	.set	at
	.set	nomacro
	.set	mips0

dtlb_noentry:
	DO_FAULT(0)
#endif	/* ! USE_CTLBHANDER */
END(handle_dtlb_noentry_matched)

/*
 * I-TLB Thread Mode Error ***************************************************
 */
	.set	noreorder
	.align 5
NESTED(handle_itlb_threadmode_err, PT_SIZE, sp)
	SAVE_ALL
	axe_cp0dump
	//STI
	or	a0, zero, sp
	jal do_itlb_threadmode_err
  	 nop
	DO_FAULT(0)
END(handle_itlb_threadmode_err)

/*
 * D-TLB Thread Mode Error ***************************************************
 */
	.set	noreorder
	.align 5
NESTED(handle_dtlb_threadmode_err, PT_SIZE, sp)
	SAVE_ALL
	axe_cp0dump
	//STI
	or	a0, zero, sp
	jal do_dtlb_threadmode_err
  	 nop
	DO_FAULT(0)
END(handle_dtlb_threadmode_err)

/*
 * I-TLB Protection Error ****************************************************
 */
	.set	noreorder
	.align 5
NESTED(handle_itlb_protection_err, PT_SIZE, sp)
	SAVE_ALL
	axe_cp0dump
	//STI
	or	a0, zero, sp
	jal do_itlb_protection_err
  	 nop
	DO_FAULT(0)
END(handle_itlb_protection_err)

/*
 * D-TLB Protection Error ***************************************************
 */
	.set	noreorder
	.align 5
NESTED(handle_dtlb_protection_err, PT_SIZE, sp)
#ifdef USE_CTLBHANDER
	.set	noat
	.set	macro
	.set	mips3
	SAVE_ALL
	CLI
	jal	do_dtlb_protection_err
	 or	a0, zero, sp
	j	ret_from_exception
	 nop
	.set	at
	.set	nomacro
	.set	mips0
#else	/* ! USE_CTLBHANDER */
	.set	noat
	.set	macro
	.set	mips3
	LOCK_SHRREG(k0)
	SAVE_ALL
	ori	s7, zero, 0		/* in Ds7A tlb exception */

	GET_CNUM(s1)
	ori	k0, zero, MMU_SPR_EXP_LOG
	mfdmm	s1, k0
	RMTBUG_MMUREAD_SYNC
	mtdmm	zero, k0 /* clear MMU_SPR_EXP_LOG */
	sync
	 	rmt_str DTLB_PROT
	 	rmt_str AXE_MMUEXPLOG
	 	rmt_val s1
	andi	k0, s1, 0x1
	beq	k0, zero, dtlb_proterr_r
	 nop
	LOAD_PTE(k0, k1, s0) /* s0=vadd */
	 	rmt_str DTLB_PROT
	 	rmt_str AXE_PTE
	 	rmt_val k0
	 	rmt_str DTLB_PROT
		rmt_str AXE_PTR
	 	rmt_val k1
	 	rmt_str DTLB_PROT
	 	rmt_str AXE_VADD
	 	rmt_val s0
	PTE_WRITABLE(k0, k1, dtlb_proterr_rw)
	PTE_MAKEWRITE(k0, k1)
	LOAD_PADD(k1, s1) /* s1=padd */
	 	rmt_str DTLB_PROT
	 	rmt_str AXE_PADD
	 	rmt_val  s1
	FLUSH_TLB(s1, k0, k1)
	ori	s2, zero, 0x1
	SET_TLB_ENTRY(s0, s1, k0, k1, s2)
	MAKE_TLB(s0, s1, k0)
	 	rmt_str DTLB_PROT
	 	rmt_str AXE_TLB1
	 	rmt_val s0
	 	rmt_str DTLB_PROT
	 	rmt_str AXE_TLB2
	 	rmt_val s1
1:
	UNLOCK_SHRREG(k0)
	j	ret_from_exception
	 nop
	.set	at
	.set	nomacro
	.set	mips0

dtlb_proterr_r:
	DO_FAULT(0)
dtlb_proterr_rw:
	DO_FAULT(1)
#endif	/* ! USE_CTLBHANDER */
END(handle_dtlb_protection_err)
