/*
 * rldata.h -- definitions for the char module
 *
 * $Id: rldata.h 529 2007-02-26 10:55:54Z morita $
 */

#ifndef _RLDATA_H_
#define _RLDATA_H_

#include <linux/ioctl.h> /* needed for the _IOW etc stuff used later */


#ifndef RLDATA_MAJOR
#define RLDATA_MAJOR 0  
#endif

#ifndef RLDATA_NR_DEVS
#define RLDATA_NR_DEVS 1
#endif

//#define RLDATA_DATA_SIZE			64

#define RLDATA_FIFO_SIZE 8192
#define RLDATA_FIFO_SZPOW 13 // 2 ^ 13 = 8192
#define RLDATA_FIFO_SZMIN 7  // 2 ^ 7 = 8192
#define RLDATA_FIFO_SZMAX 31 

struct dpm_fifo { 
        unsigned char *buffer;  /* the buffer holding the data */
        unsigned int size;      /* the size of the allocated buffer */
        unsigned int in;        /* data is added at offset (in % size) */
        unsigned int out;       /* data is extracted from off. (out % size) */
        spinlock_t lock;       /* protects concurrent modifications */
};

struct rldata_dev {
        int unsigned sz_fifoout; 
        int unsigned sz_fifoin;  
        struct dpm_fifo *fifo_dpmout;
        struct dpm_fifo *fifo_dpmin;
        unsigned long size;      
        struct semaphore sem_out;
        struct semaphore sem_in; 
        struct cdev cdev;	   
        wait_queue_head_t write_waitq; 
        wait_queue_head_t read_waitq;  
};

/*
 * Split minors in two parts
 */
#define TYPE(minor)	(((minor) >> 4) & 0xf)	/* high nibble */
#define NUM(minor)	((minor) & 0xf)		/* low  nibble */

/* Use 'k' as magic number */
#define RLDATA_IOC_MAGIC  'k'
/* Please use a different 8-bit number in your code */

#define RLDATA_PUTOSIZE    _IOW(RLDATA_IOC_MAGIC, 1, int)       //FIFO size(DPM_OUT) control
#define RLDATA_PUTISIZE    _IOW(RLDATA_IOC_MAGIC, 2, int)       //FIFO size(DPM_IN) control
#define RLDATA_GETOSIZE    _IOR(RLDATA_IOC_MAGIC, 3, int)       //Get FIFO size(DPM_OUT)
#define RLDATA_GETISIZE    _IOR(RLDATA_IOC_MAGIC, 4, int)       //Get FIFO size(DPM_IN)

#define RLDATA_IOC_MAXNR 4

#endif /* _RLDATA_H_ */
