/*
 * rlmx.h -- definitions for the char module
 *
 * $Id: rlmx.h 627 2007-05-09 09:12:42Z morita $
 */

#ifndef _RLMX_H_
#define _RLMX_H_

#include <linux/ioctl.h> /* needed for the _IOW etc stuff used later */


#ifndef RLDATA_MAJOR
#define RLDATA_MAJOR 0  
#endif


/*
 *  for IRC
 */
#define IRQ_DMAC2	26
#define IRQ_LINK	28
#define	MAIN_IRC_BASE	0xffff9000	
#define	RL_IRC_BASE	0xfffe1000	
#define IRC_TMR0(base)  (base + 0x00)
#define IRC_TMR1(base)  (base + 0x04)
#define IRC_MR(base)    (base + 0x10)
#define IRC_MOD(base)   (base + 0x18)
#define RLIRQ_DA_OUTEOP	1
#define RLIRQ_EV_OUTEOP	2
#define RLIRQ_DA_INEOP	3
#define RLIRQ_EV_INEOP	4
#define RLIRQ_DAP_IN	5
#define RLIRQ_EVP_IN	6
#define RLIRQ_CONT	7
#define RLIRQ_WAIT	8
#define RLIRQ_TABLE	9
#define RLIRQ_FATAL	10
#define RLIRQ_WAKEUP	11
#define RLIRQ_DOWN	12

/*Control & Status */
#define RL_CSBIT_FULL           30
#define RL_CSBIT_DATALEN        24
#define RL_CSBIT_DIRTY           8
#define RL_CSBIT_START           7
#define RL_CSBIT_END             6
#define RL_CSBIT_INT             5
#define RL_CSBIT_FATAL           4
#define RL_CSBIT_CORRECT         3
#define RL_CSBIT_SERIAL          0
#define RL_CSBIT_SERBIT     (RL_CSBIT_CORRECT - RL_CSBIT_SERIAL)
#define RL_CSBIT_SERMASK    ((1 << RL_CSBIT_SERBIT) - 1)
#define RL_CSBIT_LENBIT     (RL_CSBIT_FULL - RL_CSBIT_DATALEN)
#define RL_CSBIT_LENMASK    ((1 << RL_CSBIT_LENBIT) - 1)

#define DATA_PACKET_SIZE	64
#define DATA_PACKET_WSIZE	16
#define EVENT_PACKET_SIZE	16
#define EVENT_PACKET_WSIZE	 4
/*#define RLDATA_DATA_SIZE			64*/
#define RLDATA_FIFO_SIZE      8192
#define RLDATA_FIFO_SZPOW       13  /* 2 ^ 13 = 8192*/
#define RLDATA_FIFO_SZMIN        7  /* 2 ^ 7 = 8192 */
#define RLDATA_FIFO_SZMAX       31 
#define RLDATA_ADRBIT           16
#define RLDATA_ADRSIGBIT        12
#define RLDATA_ADRMASK      ((1 << RLDATA_ADRBIT) - 1)
#define RLDATA_ADRSIGMASK   ((1 << RLDATA_ADRSIGBIT) - 1)
#define RLDATA_PRIOMASK     (~(RLDATA_ADRSIGMASK | (RLDATA_ADRSIGMASK << RLDATA_ADRBIT)))
#define RLDATA_PRIOBIT           8
#define RLDATA_PRIOHLFBIT   (RLDATA_PRIOBIT / 2)
#define RLDATA_PRIOHLFMASK  ((1 << RLDATA_PRIOHLFBIT) - 1)


#define RLMX_PORT_MAX           16
#ifndef RLDATA_NR_DEVS
#define RLDATA_NR_DEVS      (RLMX_PORT_MAX + 1)
#endif

#define RLMX_MTU            (64 - 8 - RLMX_SZCTRL_IN_PLOAD)
#define RLMX_TYPDAT             0
#define RLMX_TYPACK             1
#define RLMX_TYPCTL             2
#define RLMX_TYPCNT             3
#define RLMX_TYPBIT             2
#define RLMX_SEQBIT         (32 - RLMX_TYPBIT)
#define RLMX_SEQMASK        ((1 << RLMX_SEQBIT) - 1)
#define RLMX_TYPMASK        (((1 << RLMX_TYPBIT) - 1) << RLMX_SEQBIT)
#define RLMX_SZCTRL_IN_PLOAD    8

#define RLMX_PKTIX_ADDR         0
#define RLMX_PKTIX_PORT         1
#define RLMX_PKTIX_TYPSEQ       2
#define RLMX_PKTIX_CONSEQ       3
#define RLMX_PKTIX_PAYLOAD      3
#define RLMX_PKTIX_CTLSTAT     15

#define RLMX_CONDISABLE         0
#define RLMX_CONACTIVE          1
#define RLMX_PORTBIT           16
#define RLMX_PORTMASK       ((1 << RLMX_PORTBIT) - 1)
#define RLMX_PORTSIGBIT         4
#define RLMX_PORTSIGMASK    ((1 << RLMX_PORTSIGBIT) - 1)
#define RLMX_WINSIZEBIT        16
#define RLMX_WINSIZEMASK    ((1 << RLMX_WINSIZEBIT) - 1)
#define RLMX_SBUFSIZEBIT       16
#define RLMX_SBUFSIZEMASK   ((1 << RLMX_SBUFSIZEBIT) - 1)
#define RLMX_RBUFSIZEBIT       16
#define RLMX_RBUFSIZEMASK   ((1 << RLMX_RBUFSIZEBIT) - 1)

#define RLMX_DEF_PRIO           0
#define RLMX_DEF_ANY            1
#define RLMX_DFL_WINSIZE        4
#define RLMX_DEF_SBUFSIZE      32
#define RLMX_DEF_RBUFSIZE      32


struct dpm_fifo { 
        unsigned char *buffer;  /* the buffer holding the data */
        unsigned int size;      /* the size of the allocated buffer */
        unsigned int in;        /* data is added at offset (in % size) */
        unsigned int out;       /* data is extracted from off. (out % size) */
        spinlock_t lock;       /* protects concurrent modifications */
};

struct rldata_errcnt {
        unsigned int port_num;
        unsigned int invlpkt_cnt;
};        

struct rldata_dev {
        u_short  myhostid;
        unsigned int sz_fifoout; 
        unsigned int sz_fifoin;  
        struct dpm_fifo *fifo_dpmout;
        struct dpm_fifo *fifo_dpmin;
        unsigned long size;      
        struct semaphore sem_out;
        struct semaphore sem_in; 
        struct cdev cdev;	   
        wait_queue_head_t write_waitq; 
        wait_queue_head_t read_waitq;
        unsigned int dupbuf_dpmin[512];
        /*unsigned char backack[32]; */
        struct rldata_errcnt err_cnt;
};


struct rlmx_packet {
        u_short      pkt_src, pkt_dst; /*4*/
        u_short      pkt_srcport; 
        u_short      pkt_dstport;      /*8*/
        unsigned      pkt_type:2; 
        unsigned      pkt_seq:30;      /*12*/ 
        char         pkt_data[RLMX_MTU];
        unsigned int pkt_status;
};


struct rlmx_ioctlport {
        int hostid;
        int port;
};

struct rlmx_errcnt {
        unsigned int unexpect;
        unsigned int buf_full;
        unsigned int pkt_ord;
        unsigned int ack_ord;
        unsigned int pkt_type;
};        
        
typedef char    rl_pkt_t[64];
struct rlmx_dev_info {
        struct cdev cdev;
        struct semaphore sem_snd;
        struct semaphore sem_rcv; 

        atomic_t available;
        atomic_t active;
        u_short any_port;

        /*u_short rl_status;*/
        u_short rl_peerhost;
        u_short rl_myport;
        u_short rl_peerport;
        u_short rl_priority;
        spinlock_t rl_lock_conseq; 
        unsigned int rl_conseq;
        unsigned int rl_peerseq;
        struct {
                atomic_t winsize;
                u_short max_winsize;                
                u_short nxt;    /* next packet number to be sent */
#if 0
                u_short una;    /* oldest unacknowledged packet number */
                u_short ack;    /* acknowldgement from the destination */
#endif
                unsigned int nxt_ack;
                unsigned int seq;
                unsigned int pnum;
                unsigned int pos;
                unsigned int buf_size;
                wait_queue_head_t enqwait;
        } rl_snd;
        struct {
                unsigned int  nxt;    /* next packet number expected */
                u_short spos;   /* position where the data is copied to the user */
                u_short tpos;   /* position to receive data from peer */
                atomic_t cnt;    /* count */
                unsigned int pnum;
                unsigned int buf_size;
                wait_queue_head_t rwait;
                spinlock_t lock; /* for resize ioctl*/       
        } rl_rcv;
        rl_pkt_t *rl_sbuf;
        rl_pkt_t *rl_rbuf;
        rl_pkt_t ack_work;
        struct rldata_dev *root_device; 
        struct rlmx_errcnt err_cnt;
};


/*
 * Split minors in two parts
 */
#define TYPE(minor)	(((minor) >> 4) & 0xf)	/* high nibble */
#define NUM(minor)	((minor) & 0xf)		/* low  nibble */

/* Use 'k' as magic number */
#define RLDATA_IOC_MAGIC  'k'
/* Please use a different 8-bit number in your code */

#define RLDATA_PUTOSIZE    _IOW(RLDATA_IOC_MAGIC, 1, int)       /*FIFO size(DPM_OUT) control*/
#define RLDATA_PUTISIZE    _IOW(RLDATA_IOC_MAGIC, 2, int)       /*FIFO size(DPM_IN) control*/
#define RLDATA_GETOSIZE    _IOR(RLDATA_IOC_MAGIC, 3, int)       /*Get FIFO size(DPM_OUT)*/
#define RLDATA_GETISIZE    _IOR(RLDATA_IOC_MAGIC, 4, int)       /*Get FIFO size(DPM_IN)*/

#define RLDATA_IOC_MAXNR 4

#define RLMX_IOC_MAGIC  'l'
#define RLMX_IOCTL_SETDST     _IOW(RLMX_IOC_MAGIC,  1, struct rlmx_ioctlport)       
#define RLMX_IOCTL_GETDST     _IOW(RLMX_IOC_MAGIC,  2, struct rlmx_ioctlport)       
#define RLMX_IOCTL_GETMYPORT  _IOR(RLMX_IOC_MAGIC,  3, int)       
#define RLMX_IOCTL_SETMYHOST  _IOW(RLMX_IOC_MAGIC,  4, int)       
#define RLMX_IOCTL_GETMYHOST  _IOR(RLMX_IOC_MAGIC,  5, int)       
#define RLMX_IOCTL_SETWINSIZE _IOW(RLMX_IOC_MAGIC,  6, int)       
#define RLMX_IOCTL_GETWINSIZE _IOR(RLMX_IOC_MAGIC,  7, int)       
#define RLMX_IOCTL_SETSNDSIZE _IOW(RLMX_IOC_MAGIC,  8, int)       
#define RLMX_IOCTL_GETSNDSIZE _IOR(RLMX_IOC_MAGIC,  9, int)       
#define RLMX_IOCTL_SETRCVSIZE _IOW(RLMX_IOC_MAGIC, 10, int)       
#define RLMX_IOCTL_GETRCVSIZE _IOR(RLMX_IOC_MAGIC, 11, int)       
#define RLMX_IOCTL_SETANYFLAG _IOW(RLMX_IOC_MAGIC, 12, int)       
#define RLMX_IOCTL_GETANYFLAG _IOR(RLMX_IOC_MAGIC, 13, int)       
#define RLMX_IOCTL_SETROOTBUFSIZE _IOW(RLMX_IOC_MAGIC, 14, int)       
#define RLMX_IOCTL_GETROOTBUFSIZE _IOR(RLMX_IOC_MAGIC, 15, int)       
#define RLMX_IOCTL_SETPRIO _IOW(RLMX_IOC_MAGIC, 16, int)       
#define RLMX_IOCTL_GETPRIO _IOR(RLMX_IOC_MAGIC, 17, int)       
#define RLMX_IOCTL_GETCONSEQ _IOR(RLMX_IOC_MAGIC, 18, int)       
#define RLMX_IOCTL_SETDSTSEQ _IOW(RLMX_IOC_MAGIC, 19, int)       
#define RLMX_IOCTL_GETDSTSEQ _IOR(RLMX_IOC_MAGIC, 20, int)       

#define RLMX_IOC_MAXNR 20

#endif /* _RLMX_H_ */
