#ifndef __ASM_TLB_H
#define __ASM_TLB_H

#define TLB_ENT1_VPN_SHIFT	12
#define TLB_ENT1_LCK_SHIFT	11
#define TLB_ENT1_PRO_SHIFT	8
#define TLB_ENT1_SHR_SHIFT	0

#define TLB_ENT2_PPN_SHIFT	12
#define TLB_ENT2_PSZ_SHIFT	10
#define TLB_ENT2_GRP_SHIFT	4
#define TLB_ENT2_GRP_BITS	(TLB_ENT2_PSZ_SHIFT - TLB_ENT2_GRP_SHIFT)
#define TLB_ENT2_CLC_SHIFT	3
#define TLB_ENT2_UNC_SHIFT	2
#define TLB_ENT2_BRT_SHIFT	0

#define TLB_ENT1_LCK		0x00000800
#define TLB_ENT1_PRO_ALLRW	0x00000700
#define TLB_ENT1_PRO_ALLR	0x00000600
#define TLB_ENT1_PRO_USRRW	0x00000500
#define TLB_ENT1_PRO_USRR	0x00000400
#define TLB_ENT1_PRO_SVRW	0x00000300
#define TLB_ENT1_PRO_SVR	0x00000200
#define TLB_ENT1_PRO_KERRW	0x00000100
#define TLB_ENT1_PRO_KERR	0x00000000

#define TLB_ENT2_PSZ_4K		0x00000000
#define TLB_ENT2_PSZ_64K	0x00000400
#define TLB_ENT2_PSZ_1M		0x00000800
#define TLB_ENT2_PSZ_16M	0x00000c00
#define TLB_ENT2_CLC		0x00000008
#define TLB_ENT2_UNC		0x00000004
#define TLB_ENT2_BRT_32B	0x00000003
#define TLB_ENT2_BRT_64B	0x00000002
#define TLB_ENT2_BRT_128B	0x00000001
#define TLB_ENT2_BRT_256B	0x00000000

#define	TLB_GRP_VMALLOC		0
#define	TLB_GRP_KERNEL		1
#define	TLB_GRP_USER		2

#ifndef __ASSEMBLY__
typedef struct tlb_grpid {
	unsigned int		grpid;
	struct tlb_grpid	*prev;
	struct tlb_grpid	*next;
} tlb_grpid_t;
extern tlb_grpid_t	*tlb_grpid_unused;
extern tlb_grpid_t	*tlb_grpid_unused_tail;
extern tlb_grpid_t	tlb_grpid[];
extern void tlb_grpid_init(void);

#define get_tlb_grpid_unused()					\
({							\
	unsigned int	_id;				\
	if(tlb_grpid_unused == NULL)			\
		_id = 0;				\
	else {						\
	  _id = tlb_grpid_unused->grpid;		\
	  tlb_grpid_unused = tlb_grpid_unused->next;	\
	  tlb_grpid[_id].prev = NULL;			\
	  tlb_grpid[_id].next = NULL;			\
	}						\
	_id;						\
})

#define set_tlb_grpid_unused(x)				\
do {							\
	unsigned int _id = (x);				\
	tlb_grpid[_id].prev = tlb_grpid_unused_tail;	\
	tlb_grpid[_id].next = NULL;			\
	tlb_grpid_unused_tail->next = &tlb_grpid[_id];	\
	tlb_grpid_unused_tail = &tlb_grpid[_id];	\
} while(0)

#define valid_tlb_grpid(x)				\
do {							\
	unsigned int _id = (x);				\
	write_mmu_register(MMU_SPR_GROUP,		\
		_id<<MMU_SPR_GROUP_SHIFT | 0x3<<(rmt_mycnum()*2));\
} while (0)

#define invalid_tlb_grpid(x)				\
do {							\
	unsigned int _id = (x);				\
	write_mmu_register(MMU_SPR_GROUP,		\
		_id<<MMU_SPR_GROUP_SHIFT | 0x2<<(rmt_mycnum()*2));\
} while (0)

/*
 * MIPS doesn't need any special per-pte or per-vma handling, except
 * we need to flush cache for area to be unmapped.
 */
#define tlb_start_vma(tlb, vma) 				\
	do {							\
		if (!tlb->fullmm)				\
			flush_cache_range(vma, vma->vm_start, vma->vm_end); \
	}  while (0)
#define tlb_end_vma(tlb, vma) do { } while (0)
#define __tlb_remove_tlb_entry(tlb, ptep, address) do { } while (0)

/*
 * .. because we flush the whole mm when it fills up.
 */
#define tlb_flush(tlb) flush_tlb_mm((tlb)->mm)

#include <asm-generic/tlb.h>
#endif

#endif /* __ASM_TLB_H */
