/*
 * io.h
 *
 * Access routines to memory space or IO space.
 *
 * Editors:
 *		Shinpei Kato <shinpei@ny.ics.keio.ac.jp>
 */

#define IOMEM(x) ((void*)(x))
#define MEM_RD_B(addr) (*(volatile unsigned char *) IOMEM(addr))
#define MEM_RD_H(addr) (*(volatile unsigned short *) IOMEM(addr))
#define MEM_RD_W(addr) (*(volatile unsigned long *) IOMEM(addr))
#define MEM_RD_L(addr) (*(volatile unsigned long long *) IOMEM(addr))
#define MEM_WR_B(x, addr) (*(volatile unsigned char *) IOMEM(addr) = (x))
#define MEM_WR_H(x, addr) (*(volatile unsigned short *) IOMEM(addr) = (x))
#define MEM_WR_W(x, addr) (*(volatile unsigned long *) IOMEM(addr) = (x))
#define MEM_WR_L(x, addr) (*(volatile unsigned long long *) IOMEM(addr) = (x))
