/*
 *
 *  $Id:$
 *
 *   Memory Module Header File
 *
 */

#ifndef __MEMORY_H__
#define __MEMORY_H__

/* ROM Space */
#define ROM_BASE                0x00000000

#ifdef LARGE_ROM
#define ROM_SIZE                0x00002000
#else
#define ROM_SIZE                0x00010000
#endif


/* SDRAM Space */
#define SD_BASE                 0x80000000

#ifdef MEMORY_MICRON_X8_128_MODEL
#define SDRAM_BUS_WIDTH_128
#define SD_SIZE                 0x10000000
#define RAS_CAS_VALUE           0x00020c0a
#define REFRESH_INTERVAL        15600
#endif

#ifdef MEMORY_MICRON_X16_128_MODEL
#define SDRAM_BUS_WIDTH_128
#define SD_SIZE                 0x10000000
#define RAS_CAS_VALUE           0x00020d09
#define REFRESH_INTERVAL        15600
#endif

#ifdef MEMORY_MICRON_X16_32_MODEL
#define SD_SIZE                 0x04000000
#define RAS_CAS_VALUE           0x00020d09
#define REFRESH_INTERVAL        15600
#endif

#ifdef MEMORY_HYNIX_X16_128_MODEL
#define SDRAM_BUS_WIDTH_128
#define SD_SIZE                 0x20000000
#define RAS_CAS_VALUE           0x00020d09
#define REFRESH_INTERVAL        15600
#endif

#ifdef MEMORY_HYNIX_X16_32_MODEL
#define SD_SIZE                 0x04000000
#define RAS_CAS_VALUE           0x00020d09
#define REFRESH_INTERVAL        15600
#endif

#ifdef MEMORY_HYNIX_X16_32_SINGLE
#define SD_SIZE                 0x08000000
#define RAS_CAS_VALUE           0x00010d0a
#define REFRESH_INTERVAL        7800
#endif

#ifdef MEMORY_HYNIX_X16_32_DOUBLE
#define SD_SIZE                 0x08000000
#define RAS_CAS_VALUE           0x00020d09
#define REFRESH_INTERVAL        7800
#endif

#ifdef MEMORY_QIMONDA_X16_32_MODEL
#define WAIT_SDRAM
#define SD_SIZE                 0x04000000
#define RAS_CAS_VALUE           0x00020d09
#define REFRESH_INTERVAL        7800
#endif

#ifdef MEMORY_SAMSUNG_X8_32_MODEL
#define SD_SIZE                 0x04000000
#define RAS_CAS_VALUE           0x00010d0a
#define REFRESH_INTERVAL        7800
#endif

/* Link SDRAM */
#define LINK_SD_BASE            0x04000000
#define LINK_SD_SIZE            0x01000000

#endif
