#ifndef __A_RMT_UART_H__
#define __A_RMT_UART_H__

#include <asm.h>

//#define CPU_CLK				100000000 /* 100Hz */
//#define CPU_CLK				66600000 /* 66.6MHz */
//#define CPU_CLK			50000000 /* 50MHz */
//#define CPU_CLK				33750000 /* 33.75MHz */
#define CPU_CLK				31250000 /* 31.25MHz */

//#define SDTR_INIT_BAUDRATE	57600
#define SDTR_INIT_BAUDRATE	38400
//#define SDTR_INIT_BAUDRATE	19200

#define NR_UART_PORTS	2

#define BE_BYTE_MASK	0x000000ff
#define BE_HWORD_MASK	0x0000ffff

#define UART_BASE(x) 	(0xffff6000 + 0x00000080 * (x))
#define OFFSET_RB		0x0000
#define OFFSET_THR		0x0000
#define OFFSET_DL1		0x0000
#define OFFSET_DL2		0x0004
#define OFFSET_FCR		0x0008
#define OFFSET_LCR		0x000c
#define OFFSET_LSR		0x0014
		
#define UART_RB(x)		UART_BASE(x) + OFFSET_RB
#define UART_THR(x)		UART_BASE(x) + OFFSET_THR
#define UART_FCR(x)		UART_BASE(x) + OFFSET_FCR
#define UART_FCR_RFIFO_RESET	(0x1<<1)
#define UART_FCR_TFIFO_RESET	(0x1<<2)
#define UART_LCR(x)		UART_BASE(x) + OFFSET_LCR
#define UART_LCR_DLA	0x80
#define UART_LCR_CHAR_BIT_8	0x03
#define UART_LSR(x)		UART_BASE(x) + OFFSET_LSR
#define UART_LSR_DR     (0x1<<0)
#define UART_LSR_OE     (0x1<<1)
#define UART_LSR_PE     (0x1<<2)
#define UART_LSR_FE     (0x1<<3)
#define UART_LSR_BI     (0x1<<4)
#define UART_LSR_TFIFO_EMPTY    (0x1<<5)
#define UART_LSR_TE     (0x1<<6)
#define UART_LSR_PERROR (0x1<<7)

#define UART_DL1(x)		UART_BASE(x) + OFFSET_DL1
#define UART_DL2(x)		UART_BASE(x) + OFFSET_DL2

#define OFFSET_LOWER8	0x3

static inline byte_t __get_uart_status(byte_t port)
{
	nop4();
	return iolb(UART_LSR(port) + OFFSET_LOWER8);
}

static inline void __xmt_char(byte_t port, byte_t c)
{
	nop4();
	*(volatile byte_t *)(UART_THR(port) + OFFSET_LOWER8) = c;
	nop4();
}

static inline byte_t __rcv_char(byte_t port)
{
	nop4();
	return iolb(UART_RB(port) + OFFSET_LOWER8);
}

static inline void sdtr_put(byte_t port, byte_t c)
{
	nop4();
	/* wait for the transfer fifo to be empty */
	while ((__get_uart_status(port) & UART_LSR_TFIFO_EMPTY) == 0) {
		nop7();
		sync();
	}

	/* put the char */
	__xmt_char(port, c);
}

static inline byte_t sdtr_get(byte_t port)
{
	byte_t c;
	nop4();
	/* wait for the data ready indicator to be set */
	while ((__get_uart_status(port) & UART_LSR_DR) == 0) {
		nop7();
	}
	/* get the char */
	c = __rcv_char(port);
	return c;
}

extern void sdtr_setup(void);
extern ssize_t sdtr_write(int, const void *, size_t);
extern ssize_t sdtr_read(int, const void *, size_t);
#endif
