/*
 *
 *  $Id:$
 *
 *   Clock Module Header File
 *
 */

#ifndef __CLOCK_H__
#define __CLOCK_H__

/* CPU Clock Speed */
#ifndef CPU_CLOCK_SPEED
#define CPU_CLOCK_SPEED         100000000
#endif

/* Address Map */
#define CLOCK_BASE                          0xffffa000

#define CLOCK_ENABLE                        CLOCK_BASE + 0x00
#define CLOCK_RESET                         CLOCK_BASE + 0x04
#define CLOCK_DIVIDER_CPU                   CLOCK_BASE + 0x08
#define CLOCK_DIVIDER_SDRAM                 CLOCK_BASE + 0x0c
#define CLOCK_DIVIDER_COUNTER               CLOCK_BASE + 0x10
#define CLOCK_DIVIDER_PWM                   CLOCK_BASE + 0x14
#define CLOCK_DIVIDER_OUTER                 CLOCK_BASE + 0x18
#define CLOCK_DIVIDER_LINK                  CLOCK_BASE + 0x1c
#define CLOCK_SYNC                          CLOCK_BASE + 0x20
#define CLOCK_ALL_RESET                     CLOCK_BASE + 0x24
#define CLOCK_DIVIDER_PWMIN                 CLOCK_BASE + 0x28
#define CLOCK_DIVIDER_LINK_SDRAM            CLOCK_BASE + 0x2c

/* Clock Enable / Reset */
#define CLOCK_ENABLE_LINK_SDRAM             ( 0x01 << 21 )
#define CLOCK_ENABLE_PWM_IN                 ( 0x01 << 20 )
#define CLOCK_ENABLE_LINK                   ( 0x01 << 19 )
#define CLOCK_ENABLE_OUTER                  ( 0x01 << 18 )
#define CLOCK_ENABLE_PWM                    ( 0x01 << 17 )
#define CLOCK_ENABLE_COUNTER                ( 0x01 << 16 )
#define CLOCK_ENABLE_SDRAM                  ( 0x01 << 15 )
#define CLOCK_ENABLE_VFP                    ( 0x01 << 14 )
#define CLOCK_ENABLE_VINT                   ( 0x01 << 13 )
#define CLOCK_ENABLE_SYNC                   ( 0x01 << 12 )
#define CLOCK_ENABLE_FPRS                   ( 0x01 << 11 )
#define CLOCK_ENABLE_SIMD                   ( 0x01 << 10 )
#define CLOCK_ENABLE_FP                     ( 0x01 << 9 )
#define CLOCK_ENABLE_CINT                   ( 0x01 << 8 )
#define CLOCK_ENABLE_CC                     ( 0x01 << 7 )
#define CLOCK_ENABLE_PCI                    ( 0x01 << 6 )
#define CLOCK_ENABLE_USB                    ( 0x01 << 5 )
#define CLOCK_ENABLE_IEEE1394               ( 0x01 << 4 )
#define CLOCK_ENABLE_DMAC2                  ( 0x01 << 3 )
#define CLOCK_ENABLE_DMAC1                  ( 0x01 << 2 )
#define CLOCK_ENABLE_DMAC0                  ( 0x01 << 1 )
#define CLOCK_ENABLE_CPU                    ( 0x01 << 0 )

/* Divider */
#define CLOCK_DIVIDER_RATIO(x)              ((( x ) & 0x00ff ) << 0 )
#define CLOCK_DIVIDER_THROUGH               ( 0x01 << 8 )

/* Synchronization */
#define CLOCK_SYNC_LINK_SDRAM               ( 0x01 << 7 )
#define CLOCK_SYNC_PWM_IN                   ( 0x01 << 6 )
#define CLOCK_SYNC_LINK                     ( 0x01 << 5 )
#define CLOCK_SYNC_OUTER                    ( 0x01 << 4 )
#define CLOCK_SYNC_PWM                      ( 0x01 << 3 )
#define CLOCK_SYNC_COUNTER                  ( 0x01 << 2 )
#define CLOCK_SYNC_SDRAM                    ( 0x01 << 1 )

#endif
