/*
 * RT-FRONTIER
 * Copyright (C) Real-Time Network Project / Keio University
 *
 * $Id: regs.h 1662 2005-02-01 08:47:26Z kitsunai $
 */
#ifndef	__A_RMT_REGS_H__
#define	__A_RMT_REGS_H__

/* register size [byte] */
#define SZ_GPR	4
#define SZ_FPR	8
#define SZ_COP	4	/* Coprocessor */

#define NR_GPR		32
#define NR_FPR		8

/*
 * Register names
 */
#define zero	$0	/* Constant 0 */
#define AT 		$1	/* Reserved for Assemblier */
#define v0		$2	/* Expression evaluation & */
#define v1		$3	/* Function result */
#define a0		$4	/* Arguments 1 */
#define a1		$5	/* Arguments 2 */
#define a2		$6	/* Arguments 3 */
#define a3		$7	/* Arguments 4*/
#define t0		$8	/* Temporary (not preserved) */
#define t1		$9	/* Temporary (not preserved) */
#define t2		$10	/* Temporary (not preserved) */
#define t3		$11	/* Temporary (not preserved) */
#define t4		$12	/* Temporary (not preserved) */
#define t5		$13	/* Temporary (not preserved) */
#define t6		$14	/* Temporary (not preserved) */
#define t7		$15	/* Temporary (not preserved) */
#define s0		$16	/* Temporary (preserved) */
#define s1		$17	/* Temporary (preserved) */
#define s2		$18	/* Temporary (preserved) */
#define s3		$19	/* Temporary (preserved) */
#define s4		$20	/* Temporary (preserved) */
#define s5		$21	/* Temporary (preserved) */
#define s6		$22	/* Temporary (preserved) */
#define s7		$23	/* Temporary (preserved) */
#define t8		$24	/* Temporary (not preserved) */
#define t9		$25	/* Temporary (not preserved) */
#define k0		$26	/* Reserved for OS */
#define k1		$27	/* Reserved for OS */
#define gp		$28 /* Pointer to global variables */
#define sp		$29 /* Stack pointer */
#define fp		$30 /* Frame pointer */
#define ra		$31 /* Return address (architected) */

/* RMT-specific registers */
#define HANDLER_REG	k0
#define CURTH_REG	k1

/* context_regs offsets. */
#define CR_ZERO_OFFSET	0
#define CR_AT_OFFSET	4
#define CR_V0_OFFSET	8
#define CR_V1_OFFSET	12
#define CR_A0_OFFSET	16
#define CR_A1_OFFSET	20
#define CR_A2_OFFSET	24
#define CR_A3_OFFSET	28
#define CR_T0_OFFSET	32
#define CR_T1_OFFSET	36
#define CR_T2_OFFSET	40
#define CR_T3_OFFSET	44
#define CR_T4_OFFSET	48
#define CR_T5_OFFSET	52
#define CR_T6_OFFSET	56
#define CR_T7_OFFSET	60
#define CR_S0_OFFSET	64
#define CR_S1_OFFSET	68
#define CR_S2_OFFSET	72
#define CR_S3_OFFSET	76
#define CR_S4_OFFSET	80
#define CR_S5_OFFSET	84
#define CR_S6_OFFSET	88
#define CR_S7_OFFSET	92
#define CR_T8_OFFSET	96
#define CR_T9_OFFSET	100
#define CR_K0_OFFSET	104
#define CR_K1_OFFSET	108
#define CR_GP_OFFSET	112
#define CR_SP_OFFSET	116
#define CR_S8_OFFSET	120
#define CR_RA_OFFSET	124
#define CR_F0_OFFSET	128
#define CR_F1_OFFSET	136
#define CR_F2_OFFSET	144
#define CR_F3_OFFSET	152
#define CR_F4_OFFSET	160
#define CR_F5_OFFSET	168
#define CR_F6_OFFSET	176
#define CR_F7_OFFSET	184
#define CR_STAT_OFFSET	192
#define CR_ICOUNT_OFFSET	196
#define CR_CNT_OFFSET	200
#define CR_COMP_OFFSET	204
#define CR_FPCTRL_OFFSET	208
#define CR_EPC_OFFSET	212
#define CR_CAUSE_OFFSET	216
#define CR_WAIT_OFFSET	220
#define CR_IRL_OFFSET	224
#define CR_SIZE		232

/* full_regs offsets. */
#define FR_PC_OFFSET	0
#define FR_AT_OFFSET	4
#define FR_V0_OFFSET	8
#define FR_V1_OFFSET	12
#define FR_A0_OFFSET	16
#define FR_A1_OFFSET	20
#define FR_A2_OFFSET	24
#define FR_A3_OFFSET	28
#define FR_T0_OFFSET	32
#define FR_T1_OFFSET	36
#define FR_T2_OFFSET	40
#define FR_T3_OFFSET	44
#define FR_T4_OFFSET	48
#define FR_T5_OFFSET	52
#define FR_T6_OFFSET	56
#define FR_T7_OFFSET	60
#define FR_S0_OFFSET	64
#define FR_S1_OFFSET	68
#define FR_S2_OFFSET	72
#define FR_S3_OFFSET	76
#define FR_S4_OFFSET	80
#define FR_S5_OFFSET	84
#define FR_S6_OFFSET	88
#define FR_S7_OFFSET	92
#define FR_T8_OFFSET	96
#define FR_T9_OFFSET	100
#define FR_K0_OFFSET	104
#define FR_K1_OFFSET	108
#define FR_GP_OFFSET	112
#define FR_SP_OFFSET	116
#define FR_FP_OFFSET	120
#define FR_RA_OFFSET	124
#define FR_F0_OFFSET	128
#define FR_F1_OFFSET	132
#define FR_F2_OFFSET	136
#define FR_F3_OFFSET	140
#define FR_F4_OFFSET	144
#define FR_F5_OFFSET	148
#define FR_F6_OFFSET	152
#define FR_F7_OFFSET	156
#define FR_ISSUE_OFFSET	256
#define FR_CPUHI_OFFSET	260
#define FR_CPULO_OFFSET	264
#define FR_EBA_OFFSET	268
#define FR_STAT_OFFSET	272
#define FR_TAB_OFFSET	276
#define FR_ICOUNT_OFFSET	280
#define FR_FPCTRL_OFFSET	284
#define FR_EPC_OFFSET	288
#define FR_CAUSE_OFFSET	292
#define FR_WAIT_OFFSET	296
#define FR_IRL_OFFSET	300
#define FR_SIZE		304

/* stack_frame offsets. */
#define SF_PC_OFFSET	24
#define SF_AT_OFFSET	28
#define SF_V0_OFFSET	32
#define SF_V1_OFFSET	36
#define SF_A0_OFFSET	40
#define SF_A1_OFFSET	44
#define SF_A2_OFFSET	48
#define SF_A3_OFFSET	52
#define SF_T0_OFFSET	56
#define SF_T1_OFFSET	60
#define SF_T2_OFFSET	64
#define SF_T3_OFFSET	68
#define SF_T4_OFFSET	72
#define SF_T5_OFFSET	76
#define SF_T6_OFFSET	80
#define SF_T7_OFFSET	84
#define SF_S0_OFFSET	88
#define SF_S1_OFFSET	92
#define SF_S2_OFFSET	96
#define SF_S3_OFFSET	100
#define SF_S4_OFFSET	104
#define SF_S5_OFFSET	108
#define SF_S6_OFFSET	112
#define SF_S7_OFFSET	116
#define SF_T8_OFFSET	120
#define SF_T9_OFFSET	124
#define SF_K0_OFFSET	128
#define SF_K1_OFFSET	132
#define SF_GP_OFFSET	136
#define SF_SP_OFFSET	140
#define SF_FP_OFFSET	144
#define SF_RA_OFFSET	148
#define SF_SIZE			152

#endif	/* __A_RMT_REGS_H__ */
